/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import info.informatica.doc.style.css.StyleDatabase;

import org.dom4j.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;

/**
 * Center element.<p>
 * Provides equivalent CSS style for this deprecated element.
 * 
 * @author Carlos Amengual
 *
 */
class CenterElement extends CSSStylableElement {

	private static final long serialVersionUID = 1L;
	
	CenterElement(String name) {
		super(name);
	}

	CenterElement(QName qname) {
		super(qname);
	}

    CenterElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

	/**
	 * Gets the style coming from this deprecated element.
	 * <p>Any style specified through the <code>style</code> attribute 
	 * of this deprecated element is ignored.
	 * 
	 * @return the equivalent style declaration.
	 */
	public CSSStyleDeclaration getStyle() {
		DOM4JCSSStyleDeclaration styledecl = new DOM4JCSSStyleDeclaration();
		try {
			styledecl.setCssText("display: block; text-align: center");
			styledecl.setPeerNode(this);
			StyleDatabase styleDb = ((XHTMLDocument) getDocument()).
				getStyleDatabase();
			if(styleDb != null && styledecl.getStyleDatabase() == null){
				styledecl.setStyleDatabase(styleDb);
			}
		} catch (DOMException e) {
			log.error("Could not parse style", e);
			styledecl = null;
		}
		return styledecl;
	}

}
