/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import org.apache.log4j.Logger;
import org.dom4j.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

/**
 * Log4j error handler.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class Log4jErrorHandler implements DOM4JCSSErrorHandler {

	static Logger log = Logger.getLogger(Log4jErrorHandler.class.getName());

	public Log4jErrorHandler() {
		super();
	}
	
	public void error(String message) {
		log.error(message);
	}

	public void error(String message, Throwable t) {
		log.error(message, t);
	}

	public void error(String message, Throwable t, CSSStyleSheet sheet) {
		log.error(message, t);
	}

	public void error(String message, Throwable t, CSSRule rule) {
		log.error(message, t);
	}

	public void error(String message, String property, CSSValue value) {
		log.error(message);
	}

	public void error(String message, Throwable t, CSSStylableElement element) {
		log.error(message, t);
	}

	public void error(String message, Throwable t, Node node) {
		log.error(message, t);
	}

}
