/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;

/**
 * Style attribute.
 * 
 * @author Carlos Amengual
 *
 */
class StyleAttribute extends DOMAttribute {

	private static final long serialVersionUID = 1L;

	StyleAttribute(QName qname) {
		super(qname);
	}

	StyleAttribute(QName qname, String value) {
		super(qname, value);
	}

	StyleAttribute(Element parent, QName qname, String value) {
		super(parent, qname, value);
	}

	@Override
	public void setValue(String value) {
		super.setValue(value);
		// Style is being modified, notify parent element?
		Element parent = getParent();
		if(parent instanceof CachedCSSStylableElement) {
			((CachedCSSStylableElement)parent).onStyleModify();
		}
	}

}
