/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import org.w3c.css.sac.CSSException;

/**
 * Any element containing or referencing a style sheet must implement 
 * this interface.
 * 
 * @author Carlos Amengual
 *
 */
interface StyleDefiner {

	/**
	 * Merges the style referenced (or embedded) by this element with the 
	 * document's main style sheet.
	 * 
	 * @throws CSSException if could not parse the style sheet implied by
	 * this element.
	 */
	void mergeStyle() throws CSSException;

}