/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;

/**
 * An XHTML element.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class XHTMLElement extends DOMElement {

	private static final long serialVersionUID = 2L;
	
	public XHTMLElement(String name) {
		super(name);
	}

	public XHTMLElement(QName qname) {
		super(qname);
	}

    public XHTMLElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }
    
    public String getId() {
    	return attributeValue("id");
    }

	@Override
    protected String elementID(Element element) {
        return element.attributeValue("id");
    }

	@Override
	public XHTMLDocument getDocument() {
		return (XHTMLDocument) super.getDocument();
	}

}
