/**
   Built on top of the DOM4J package, provides XHTML parsing with built-in 
   support for CSS style sheets.
   <p>
   DOM4J is an XML DOM-like software package with better support for Java 
   language constructs, like Collections. See 
   <a href="http://dom4j.sourceforge.net/" target="_blank">http://dom4j.sourceforge.net/</a>
   for more information.
   </p>
   <p>
   This implementation integrates DOM4J with the CSS DOM implementation found 
   in the <code>info.informatica.doc.style.css</code> package and subpackages.
   </p>
   <h3>Short example</h3>
   <p>
   This is the easiest way to use this package:
   </p>
   <pre>
   Reader re = ...  [reader for XHTML document]
   InputSource source = new InputSource(re);
   SAXReader reader = new SAXReader(XHTMLDocumentFactory.getInstance());
   reader.setEntityResolver(new DefaultEntityResolver());
   Document document = reader.read(source);
   </pre>
   <p>
   And once you got the element you want style for (see, for example, the  
   <a href="http://dom4j.sourceforge.net/dom4j-1.6.1/guide.html" target="_blank">DOM4J Guide</a>),
   just get it:
   </p>
   <pre>
   CSSStyleDeclaration style = ((CSSStylableElement)element).getComputedStyle();
   String propertyValue = style.getPropertyValue("display");
   </pre>
   <h3>Non-standard interfaces</h3>
   <p>
   The <code>CSSStyleDeclaration</code> interface may be hard to use, however, 
   so you may want to access the more specialized interface 
   <code>CSS2ComputedProperties</code>.
   </p>
   <p>
   For complete access to this API, first configure the style declaration with a 
   style database according to the target display device, for example:
   </p>
   <pre>
   ((StyleDatabaseAware)style).setStyleDatabase(new Java2DStyleDatabase());
   </pre>
   or, alternatively, set the style database at the <code>XHTMLDocumentFactory</code>
   with the <code>setStyleDatabase</code> method (recommended).
   <p>Then, you just have to cast the style declaration with the 
   <code>CSS2ComputedProperties</code> interface and use it, for example:
   <pre>
   Color color = Java2DStyleDatabase.getAWTColor(((CSS2ComputedProperties)style).getColor());
   </pre>
   Read the documentation of the individual classes for information on 
   additional capabilities, like caching or the use of customized style sheets.</p>
   <h3>Default style sheet and user preferences</h3>
   <p>CSS4J uses a default user-agent style sheet as the basis for style 
   computations, although you can set a different one with the 
   <code>setUserAgentStyleSheet</code> method in <code>XHTMLDocumentFactory</code>. 
   User preferences can be specified with the <code>setUserStyleSheet</code> 
   method.</p>
   <h3>Formatting structure</h3>
   <p>
   The <code>DocumentFormatter</code> class can be used to build a 
   formatting structure from the DOM4J document tree. You get the root 
   box, and then can recurse the contained boxes. For each box, you can 
   obtain the computed properties using the <code>getComputedStyle</code> 
   method. Note that this class is experimental and likely to have bugs.</p>
 */
package info.informatica.doc.dom4j;
