/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.pdf.itext;

import info.informatica.doc.agent.ResourceDownloader;
import info.informatica.doc.dom4j.DOM4JUserAgent;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.visual.ElementReplacer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.imageio.ImageIO;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Image;

/**
 * User Agent based on iText PDF.
 * <p>
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 */
public class PDFUserAgent extends DOM4JUserAgent<Image> {
	
	private StyleDatabase styleDb;

	public PDFUserAgent() {
		this(new PDFStyleDatabase());
	}

	public PDFUserAgent(PDFStyleDatabase styleDb) {
		super();
		this.styleDb = styleDb;
		setElementReplacer(ElementReplacer.NAMESPACE_XHTML, 
				new PDFXHTMLElementReplacer());
	}

	@Override
	public StyleDatabase getStyleDatabase() {
		return styleDb;
	}

	public ResourceDownloader<Image> createDownloader(URL url) {
		return new PDFImageDownloader(url);
	}

	/**
	 * Asynchronous downloading of images.
	 * 
	 * @author Carlos Amengual
	 *
	 */
	class PDFImageDownloader extends ResourceDownloader<Image> {
		
		public PDFImageDownloader(URL url) {
			super(url);
		}

		protected void readContent(InputStream is) throws IOException {
			try {
				nativeContent = Image.getInstance(ImageIO.read(is), null, false);
			} catch (BadElementException e) {
				throw new IOException(e.getLocalizedMessage());
			}
		}

	}

}