/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.structure;



/**
 * A table cell.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public interface TableCell {

	/**
	 * Gets the numeric index for this cell.
	 * 
	 * @return the index of this cell in the row.
	 */
	public int getRowIndex();

	/**
	 * Gets the column span for this table cell.
	 * 
	 * @return the column span.
	 */
	public int columnSpan();

	/**
	 * Gets the row span for this table cell.
	 * 
	 * @return the row span.
	 */
	public int rowSpan();

}