/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css;

import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.DOMCSSStyleSheet;
import info.informatica.doc.style.css.dom.DOMMediaList;

import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

/**
 * CSS2 style sheet factory for DOM.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class DOMCSSStyleSheetFactory extends CSSStyleSheetFactory {

	public DOMCSSStyleSheetFactory() {
		super();
	}

	/**
	 * Creates a CSS style sheet.
	 * <p>
	 * 
	 * @param namespaceUri
	 *            the Namespace URI for the style sheet.
	 * @param mediaList
	 *            the target media list for style information.
	 * @return the style sheet.
	 */
	public CSSStyleSheet createStyleSheet(String namespaceUri, 
			MediaList mediaList) {
		return createStyleSheet(null, namespaceUri, mediaList);
	}

	/**
	 * Creates a CSS style sheet.
	 * <p>
	 * 
	 * @param ownerNode
	 *            the node that associates the style sheet to the document. In
	 *            XHTML it can be a <code>link</code> or <code>style</code>
	 *            element. For style sheets that are included by other style
	 *            sheets, the value of this attribute is <code>null</code>.
	 * @param namespaceUri
	 *            the Namespace URI for the style sheet.
	 * @param mediaList
	 *            the target media list for style information.
	 * @return the style sheet.
	 */
	public CSSStyleSheet createStyleSheet(Node ownerNode,
			String namespaceUri, MediaList mediaList) {
		if(mediaList == null) {
			throw new NullPointerException("Null media list");
		}
		BaseCSSStyleSheet css = new DOMCSSStyleSheet(this, ownerNode, 
				(DOMMediaList)mediaList);
		String title = null;
		if (ownerNode != null) {
			Node titleattr = ownerNode.getAttributes()
					.getNamedItem("title");
			if (titleattr != null) {
				title = titleattr.getNodeValue();
			}
		}
		css.setTitle(title);
		css.setNamespaceURI(namespaceUri);
		return css;
	}

}
