/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.dom;

import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

/**
 * This interface listens to properties found by SAC event handlers.
 * 
 * @author Carlos Amengual
 * 
 */
interface LexicalPropertyListener {

	/**
	 * Set a CSS property, based on lexixal value.
	 * 
	 * @param propertyName
	 *            the name of the property.
	 * @param value
	 *            the lexical value.
	 * @param priority
	 *            the priority string.
	 * @throws DOMException
	 *             if some error or inconsistency is found in the value.
	 */
	abstract void setProperty(String propertyName, LexicalUnit value,
			String priority) throws DOMException;

}
