/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.j2d;

import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.style.css.CSSStyleException;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.net.URL;
import java.util.Date;

import javax.swing.JFrame;

public class CSSComponent extends Component {

	private static final long serialVersionUID = 1L;

	private Java2DRenderer renderer;

	public CSSComponent() {
		super();
		renderer = new Java2DRenderer();
	}

	public void init(XHTMLDocument xdoc) throws CSSStyleException {
		renderer.setDocument(xdoc);
	}

	public void paint(Graphics g) {
		renderer.paint((Graphics2D) g);
	}

	public Dimension getPreferredSize() {
		return new Dimension((int)renderer.getWidth(), 
				(int)renderer.getHeight());
	}

	public static void main(String[] args) throws Exception {
		String urlString = "http://informatica.info/index";
		URL url = new URL(urlString);
		Date ini = new Date();
		Java2DUserAgent agent = new Java2DUserAgent();
		XHTMLDocument xdoc = agent.readURL(url);
		System.err.println("TS readURL =" + ((new Date()).getTime() - ini.getTime()));
		CSSComponent cssComp = new CSSComponent();
		cssComp.init(xdoc);
		System.err.println("TS boxes =" + ((new Date()).getTime() - ini.getTime()));
		JFrame frame = new JFrame("CSS Test");
		frame.add("Center", cssComp);
		frame.pack();
		frame.setVisible(true);
		System.err.println("TS rendering =" + ((new Date()).getTime() - ini.getTime()));
	}

}
