/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.j2d;

import java.awt.image.BufferedImage;

import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.visual.ElementReplacer;
import info.informatica.doc.style.css.visual.ReplacedElementBox;

/**
 * CSS Element replacer for XHTML with Java2D.
 * <p>
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * @see StyleDatabase
 */
public class Java2DXHTMLElementReplacer extends ElementReplacer<BufferedImage> {

	/**
	 * Creates a box for a replaced element.
	 * 
	 * @param element the element that is going to be replaced.
	 * @return the box for the replaced element, or null if the 
	 * element is non-replaced.
	 */
	public ReplacedElementBox<BufferedImage> createReplacedElementBox(CSSStylableElement element) {
		String name = element.getName();
		if(name.equals("img")) {
			return new ImgReplacedBox(element);
		} else if(name.equals("input")) {
		} else if(name.equals("button")) {
		} else if(name.equals("textarea")) {
		} else if(name.equals("select")) {
		} else if(name.equals("object")) {
			
		}
		return null;
	}


}