/**
  This package and its subpackages provide an implementation of the 
  <a href="http://www.w3.org/TR/DOM-Level-2-Style/css.html" target="_blank">CSS
  Object Model API</a>.
  <p>
  Parsing requires a <a href="http://www.w3.org/TR/SAC/" target="_blank">SAC</a> 
  parser implementation, and by default uses the excellent 
  <a href="http://xml.apache.org/batik/" target="_blank">Batik</a> open 
  source SAC parser.
  Only the "batik-css.jar" and "batik-util.jar" files, and not the full 
  Batik, are needed to run this software. Alternatively, you can use the 
  System property <code>org.w3c.css.sac.parser</code> to specify a different 
  parser.
  </p>
  <p>
 Please note that the org.w3c.dom.css classes are already included in 
 version 5 of the J2SE, so you do not need to put the CSS-DOM jarfile 
 in the classpath. Read the release notes for more information about 
 the package dependencies.
 </p>
 <h3>Computed properties for elements in the document tree</h3>
 <p>
 CSS4J gives the computed CSS properties for each element in a DOM4J 
 document tree (limited support for other document object model 
 implementations is included, but requires the developer to scan 
 the tree manually for the style sheets).
 </p>
 <p>
 Style declarations returned by the <code>getComputedStyle</code> can 
 be casted to a non-standard interface (<code>CSS2ComputedProperties</code>), 
 easier to use for retrieving some properties.
 </p>
 <h3>Visual formatting model: the <code>visual</code> subpackage</h3>
 <p>
 Several classes and interfaces make use of the <code>visual</code> 
 subpackage. Boxes created with the subpackage contain the appropriate 
 methods to compute the dimensions and positions. 
 <p>
 For each box, you can obtain the computed properties using the 
 same <code>getComputedStyle</code> method as for document elements.
 </p>
 */
package info.informatica.doc.style.css;
