/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;


/**
 * Transforms HTML attributes into style declarations.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public final class AttributeToStyle {

	protected AttributeToStyle() {
		super();
	}

	public static void bgcolor(String bgcolorAttr, StringBuilder buf) {
		if(bgcolorAttr != null && bgcolorAttr.length() > 0) {
			buf.append("background-color: ").append(bgcolorAttr).append(';');
		}
	}

	public static void width(String widthAttr, StringBuilder buf) {
		if(widthAttr != null && widthAttr.length() > 0) {
			buf.append("width: ").append(widthAttr);
			if(widthAttr.charAt(widthAttr.length() - 1) != '%') {
				buf.append("px");
			}
			buf.append(';');
		}
	}

	public static void height(String heightAttr, StringBuilder buf) {
		if(heightAttr != null && heightAttr.length() > 0) {
			buf.append("height: ").append(heightAttr).append("px;");
		}
	}

}
