/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;

/**
 * CSS property name.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class CSSPropertyName {
	private final String name;
	private boolean inheritance;

	public CSSPropertyName(String name, boolean inherits) {
		super();
		this.name = name;
		inheritance = inherits;
	}

	/**
	 * Gets the name of this property.
	 * 
	 * @return the name.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Does this property inherit value from ancestors ?
	 * 
	 * @return true if this property inherits value, false if not.
	 */
	public boolean inherits() {
		return inheritance;
	}

	/**
	 * Is this property name a shorthand for other (sub)properties?
	 * 
	 * @return true if this is a shorthand, false otherwise.
	 */
	public boolean isShorthand() {
		return this instanceof ShorthandPropertyName;
	}
}
