/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;

import java.util.HashMap;
import java.util.Map;

/**
 * CSS Color identifiers map.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class ColorIdentifiers {
	private static ColorIdentifiers singleton = new ColorIdentifiers();

	private Map<String,String> colorKeywords = new HashMap<String,String>(17); 

	public ColorIdentifiers() {
		super();
		colorKeywords.put("aqua", "#00ffff");
		colorKeywords.put("black", "#000000");
		colorKeywords.put("blue", "#0000ff");
		colorKeywords.put("fuchsia", "#ff00ff");
		colorKeywords.put("gray", "#808080");
		colorKeywords.put("green", "#008000");
		colorKeywords.put("lime", "#00ff00");
		colorKeywords.put("maroon", "#800000");
		colorKeywords.put("navy", "#000080");
		colorKeywords.put("olive", "#808000");
		colorKeywords.put("orange", "#ffA500");
		colorKeywords.put("purple", "#800080");
		colorKeywords.put("red", "#ff0000");
		colorKeywords.put("silver", "#c0c0c0");
		colorKeywords.put("teal", "#008080");
		colorKeywords.put("white", "#ffffff");
		colorKeywords.put("yellow", "#ffff00");
	}

	/**
	 * Gets the instance of this class.
	 * 
	 * @return the singleton instance of this class.
	 */
	public static ColorIdentifiers getInstance() {
		return singleton;
	}

	/**
	 * Gets the color associated to the given keyword.
	 * 
	 * @param keyword the color keyword (orange, blue, etc.)
	 * @return the corresponding #-starting hex color specification.
	 */
	public String getColor(String keyword){
		return colorKeywords.get(keyword);
	}
}
