/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;

import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

/**
 * Color-specific CSSPrimitiveValue.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class DOMCSSColorValue extends AbstractCSSPrimitiveValue {
	
	private CSSRGBColor color = null;

	public DOMCSSColorValue() {
		super(CSSPrimitiveValue.CSS_RGBCOLOR);
		color = new CSSRGBColor();
	}

	@Override
	public String getCssText() {
		return getRGBColorValue().toString();
	}

	@Override
	public RGBColor getRGBColorValue() throws DOMException {
		return color;
	}

	@Override
	void setLexicalUnit(LexicalUnit lunit) {
		super.setLexicalUnit(lunit);
		LexicalUnit lu = lunit.getParameters();
		// red
		CSSPrimitiveValue basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu);
		color.setRed(basiccolor);
		// comma
		lu = lu.getNextLexicalUnit();
		// green
		lu = lu.getNextLexicalUnit();
		basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu);
		color.setGreen(basiccolor);
		// comma
		lu = lu.getNextLexicalUnit();
		// blue
		lu = lu.getNextLexicalUnit();
		basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu);
		color.setBlue(basiccolor);
	}

	public class CSSRGBColor implements RGBColor {
		
		private CSSPrimitiveValue red = null;
		private CSSPrimitiveValue green = null;
		private CSSPrimitiveValue blue = null;

		public CSSRGBColor() {
			super();
		}

		public void setRed(CSSPrimitiveValue red) {
			this.red = red;
		}
	
		public CSSPrimitiveValue getRed() {
			return red;
		}

		public void setGreen(CSSPrimitiveValue green) {
			this.green = green;
		}

		public CSSPrimitiveValue getGreen() {
			return green;
		}

		public void setBlue(CSSPrimitiveValue blue) {
			this.blue = blue;
		}
	
		public CSSPrimitiveValue getBlue() {
			return blue;
		}
		
		public String toString() {
			return "rgb(" + red.getCssText() + ',' + green.getCssText() + ',' +
			blue.getCssText() + ')';
		}
	}
}
