/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;

import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Rect;

/**
 * Rect-specific CSSPrimitiveValue.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class DOMCSSRectValue extends AbstractCSSPrimitiveValue {

	private CSSRect rect = new CSSRect();

	public DOMCSSRectValue() {
		super(CSSPrimitiveValue.CSS_RECT);
	}

	@Override
	public Rect getRectValue() throws DOMException {
		return rect;
	}

	@Override
	void setLexicalUnit(LexicalUnit lunit) {
		super.setLexicalUnit(lunit);
		LexicalUnit lu = lunit.getParameters();
		// top
		CSSPrimitiveValue dimens = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu);
		rect.setTop(dimens);
		// comma
		lu = lu.getNextLexicalUnit();
		// right
		lu = lu.getNextLexicalUnit();
		dimens = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu);
		rect.setRight(dimens);
		// comma
		lu = lu.getNextLexicalUnit();
		// bottom
		lu = lu.getNextLexicalUnit();
		dimens = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu);
		rect.setBottom(dimens);
		// comma
		lu = lu.getNextLexicalUnit();
		// left
		lu = lu.getNextLexicalUnit();
		dimens = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu);
		rect.setLeft(dimens);
	}

	public class CSSRect implements Rect {
		private CSSPrimitiveValue top = null;
		private CSSPrimitiveValue right = null;
		private CSSPrimitiveValue bottom = null;
		private CSSPrimitiveValue left = null;

		public CSSRect() {
			super();
		}
	
		public void setTop(CSSPrimitiveValue top) {
			this.top = top;
		}
	
		public CSSPrimitiveValue getTop() {
			return top;
		}
	
		public void setRight(CSSPrimitiveValue right) {
			this.right = right;
		}
	
		public CSSPrimitiveValue getRight() {
			return right;
		}
	
		public void setBottom(CSSPrimitiveValue bottom) {
			this.bottom = bottom;
		}
	
		public CSSPrimitiveValue getBottom() {
			return bottom;
		}
	
		public void setLeft(CSSPrimitiveValue left) {
			this.left = left;
		}
	
		public CSSPrimitiveValue getLeft() {
			return left;
		}
	}
}
