/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.visual.ItemMarkerFactory;


/**
 * CSS zero-leading decimal list item marker factory.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class DecimalLeadingZeroItemMarkerFactory implements ItemMarkerFactory {
	
	public DecimalLeadingZeroItemMarkerFactory() {
		super();
	}

	public String marker(int order) {
		if(order > 9) {
			return Integer.toString(order);
		} else {
			StringBuilder buf = new StringBuilder(2);
			buf.append('0').append(order);
			return buf.toString();
		}
	}

}
