/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.container.CSSInlineBoxContainer;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.css.CSSPrimitiveValue;

/**
 * Container of CSS inline boxes.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class InlineContainer implements CSSInlineBoxContainer {

	// Inline descendants
	private List<CSSBox> inline;
	
	private boolean overflowsWidth = false;

	public InlineContainer() {
		super();
		inline = new ArrayList<CSSBox>();
	}

	public InlineContainer(int size) {
		super();
		inline = new ArrayList<CSSBox>(size);
	}

	public List<CSSBox> getInlineBoxes() {
		return inline;
	}

	protected void setOverflowsWidth() {
		overflowsWidth  = true;
	}

	public boolean overflowsWidth() {
		return overflowsWidth;
	}

	public float getContentWidth() {
		float width = 0;
		for(int i=0; i<inline.size(); i++){
			if(inline.get(i) instanceof InlineBox) {
				width += ((InlineBox) inline.get(i)).getContentWidth();
			}
		}
		return width;
	}

	public float getMinimumWidth() {
		float width = 0;
		for(int i=0; i<inline.size(); i++){
			if(inline.get(i) instanceof InlineBox) {
				width = Math.max(((InlineBox) inline.get(i)).getMinimumWidth(), width);
			}
		}
		return width;
	}

	public float computeHeight(float width) {
		// FIXME: specify what happens when the scrollbar is permanent
		float height = 0;
		int chStart = 0;
		InlineBox box = null;
		for(int i=0; i<inline.size(); i++){
			if(!(inline.get(i) instanceof InlineBox)){
				continue;
			}
			box = (InlineBox) inline.get(i);
			int chWidth = (int)(Math.floor(box.getStyleDatabase().floatValueConversion(
					width, box.getStyleDatabase().getNaturalUnit(), CSSPrimitiveValue.CSS_PT) / 
				box.getStyleDatabase().getExSizeInPt(box.getFontFamily(), box.getFontSize())));
			// chWidth id the width of the box, expressed in chars with the
			// font of the current inline box.
			if(chWidth == 0) {
				return Float.NaN;
			}
			int availW = chWidth - chStart;
			String text = box.getText();
			int lineCount = 0;
			int j = 0;
			int tLen = text.length();
			if(availW <= tLen) {
				int lbound = 0;
				int from;
				do {
					from = j + availW;
					if(from >= tLen) {
						break;
					}
					j = InlineBox.lastNonLetterOrDigitIndex(text, from, lbound);
					if(j == lbound) {
						setOverflowsWidth();
						j = InlineBox.nonLetterOrDigitIndex(text, from, availW);
					}
					i++;
					lbound = j;
					availW = chWidth;
					lineCount++;
				} while(j < tLen);
			}
			chStart = availW - j;
			height += box.getStyleDatabase().floatValueConversion(
					box.getFontSize() * lineCount, CSSPrimitiveValue.CSS_PT); 
		}
		if(box != null) {
			height += box.getStyleDatabase().floatValueConversion(
					box.getFontSize(), CSSPrimitiveValue.CSS_PT);
		}
		return height;
	}

}
