/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.box;

import org.w3c.dom.css.CSSPrimitiveValue;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.container.CSSBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSTableRowContainer;

/**
 * CSS inline table implementation.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class InlineTable extends AbstractInlineBox 
	implements CSSContainerBox {

	private final float UNSET_FLOAT_VALUE = Float.MIN_VALUE;

	private float boxHeight = UNSET_FLOAT_VALUE;

	private CSSTableRowContainer rowContainer;

	public InlineTable(CSS2ComputedProperties style) {
		super(style);
	}

	public void setBoxContainer(CSSBoxContainer rowContainer) {
		this.rowContainer = (CSSTableRowContainer)rowContainer;
	}

	public CSSBoxContainer asContainerBox() {
		return rowContainer;
	}

	public float getWidth() {
		float boxWidth;
		CSSPrimitiveValue cssValue = getCSSValue("width");
		short primiType = cssValue.getPrimitiveType();
		if(primiType == getStyleDatabase().getNaturalUnit()) {
			boxWidth = cssValue.getFloatValue(getStyleDatabase().getNaturalUnit());
		} else if(primiType == CSSPrimitiveValue.CSS_PERCENTAGE) {
			boxWidth = getContainerWidth() * 
				cssValue.getFloatValue(CSSPrimitiveValue.CSS_PERCENTAGE) / 100f;
		} else if(cssValue instanceof CSSNumberValue) {
			// Expressed in non-natural unit
			boxWidth = cssValue.getFloatValue(primiType);
		} else {
			// auto
			boxWidth = getContentWidth();
		}
		return boxWidth;
	}

	public float getContentWidth() {
		return ((TableRowContainer)rowContainer).getContentWidth();
	}

	public float getMinimumWidth() {
		return ((TableRowContainer)rowContainer).getMinimumWidth();
	}

	public float getHeight() {
		if(boxHeight == UNSET_FLOAT_VALUE){
			CSSPrimitiveValue cssValue = getCSSValue("height");
			short primiType = cssValue.getPrimitiveType();
			if(primiType == getStyleDatabase().getNaturalUnit()) {
				boxHeight = cssValue.getFloatValue(getStyleDatabase().getNaturalUnit());
			} else if(primiType == CSSPrimitiveValue.CSS_PERCENTAGE) {
				if(isContainerHeightAuto()) {
					boxHeight =  computeHeight(getWidth());
				} else {
					// Compute container height
					float containerHeight;
					CSSContainerBox container = getContainingBlock();
					if(container != null){
						containerHeight = container.getHeight();
					} else {
						// root block
						containerHeight = getStyleDatabase().getDocumentHeight();
					}
					boxHeight = containerHeight * 
						cssValue.getFloatValue(CSSPrimitiveValue.CSS_PERCENTAGE) / 100f;
				}
			} else if(cssValue instanceof CSSNumberValue) {
				// Expressed in non-natural unit
				boxHeight = cssValue.getFloatValue(primiType);
			} else {
				// Even if this was not supplied as 'auto', will be handled as such.
				boxHeight = computeHeight(getWidth());
			}
		}
		return boxHeight;
	}

	@Override
	public float computeHeight(float width) {
		return ((TableRowContainer)rowContainer).computeAutoHeight(width);
	}

}
