/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.container;

import java.util.List;

import info.informatica.doc.style.css.visual.CSSContainerBox;


/**
 * A CSS block box that contains other block boxes.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public interface CSSBlockBoxContainer extends CSSBoxContainer {

	/**
	 * Gets the descendant boxes that are to be formatted according to 
	 * normal flow. Boxes are ordered according to document tree 
	 * ordering.
	 * 
	 * @return an array with the descendant statically 
	 * positioned boxes, or null if does not contain static boxes.
	 */
	public List<CSSContainerBox> getStaticallyPositioned();

	/**
	 * Gets the descendant boxes that are absolutely positioned.
	 * 
	 * @return an array with the absolutely positioned descendant boxes,
	 * or null if does not contain absolutely positioned boxes.
	 */
	public List<CSSContainerBox> getAbsolutelyPositioned();

	/**
	 * Compute the box height for 'auto'.
	 * 
	 * @return the box height, expressed in the device's natural unit.
	 */
	public float computeAutoHeight();

}