/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.container;


/**
 * Base interface for CSS box containers.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public interface CSSBoxContainer {

	/**
	 * Gets the width of the content, expressed in natural units.
	 * 
	 * @return the content width.
	 */
	public float getContentWidth();

	/**
	 * Gets the minimum width required to avoid width overflowing 
	 * (horizontal scroll bar).
	 * 
	 * @return the minimum width, expressed in natural units.
	 */
	public float getMinimumWidth();

}