/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.container;

import java.util.List;

import info.informatica.doc.style.css.visual.CSSTableRowBox;


/**
 * A CSS block-level table box that contains table rows.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public interface CSSTableRowContainer extends CSSBoxContainer {

	/**
	 * Gets the table rows.
	 * 
	 * @return an array with the table rows.
	 */
	public List<CSSTableRowBox> getRows();

	/**
	 * Compute the box height for 'auto'.
	 * 
	 * @return the box height, expressed in the device's natural unit.
	 */
	public float computeAutoHeight(float containerWidth);

}