/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.pdf.itext;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.TextElementArray;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import info.informatica.doc.RenderingException;
import info.informatica.doc.dom4j.DOM4JCSSStyleDeclaration;
import info.informatica.doc.dom4j.DocumentFormatter;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.pdf.itext.PDFImgReplacedBox;
import info.informatica.doc.pdf.itext.PDFInputTextReplacedBox;
import info.informatica.doc.pdf.itext.PDFStyleDatabase;
import info.informatica.doc.pdf.itext.PDFStyleFormatter;
import info.informatica.doc.pdf.itext.PDFUserAgent;
import info.informatica.doc.style.css.CSSStyleException;
import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.CSSInlineBox;
import info.informatica.doc.style.css.visual.CSSTableCellBox;
import info.informatica.doc.style.css.visual.CSSTableRowBox;
import info.informatica.doc.style.css.visual.ReplacedElementBox;
import info.informatica.doc.style.css.visual.box.ListItemBox;
import info.informatica.doc.style.css.visual.box.RunInBox;
import info.informatica.doc.style.css.visual.container.CSSBlockBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSInlineBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSTableRowContainer;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class PDFRenderer {
    private CSSContainerBox rootBox;
    protected Document pdf = null;
    private PdfWriter wri = null;
    private PDFStyleFormatter pdfFormatter;
    static Logger log = Logger.getLogger((String)PDFRenderer.class.getName());

    public PDFRenderer() {
        this(new Document(PageSize.A4, 36.0f, 36.0f, 40.0f, 40.0f));
    }

    public PDFRenderer(Document pdf) {
        this.pdf = pdf;
        this.pdfFormatter = new PDFStyleFormatter(new PDFUserAgent(new PDFStyleDatabase(pdf.getPageSize())));
    }

    public void setDocument(XHTMLDocument xdoc) throws CSSStyleException {
        this.rootBox = new DocumentFormatter(new PDFUserAgent()).formatDocument(xdoc);
    }

    protected CSSContainerBox getRootBox() {
        return this.rootBox;
    }

    protected PdfWriter getPdfWriter() {
        return this.wri;
    }

    public synchronized void open(OutputStream out) throws RenderingException {
        if (this.pdf.isOpen()) {
            throw new IllegalStateException("Report output already opened");
        }
        try {
            this.wri = PdfWriter.getInstance((Document)this.pdf, (OutputStream)out);
        }
        catch (DocumentException e) {
            throw new RenderingException("Could not open PDF report", e);
        }
        this.wri.setStrictImageSequence(true);
        XHTMLDocument xhtmlDoc = (XHTMLDocument)((Object)((DOM4JCSSStyleDeclaration)this.getRootBox().getComputedStyle()).getPeerNode().getOwnerDocument());
        org.dom4j.Element headEl = xhtmlDoc.getRootElement().element("head");
        String title = headEl.element("title").getTextTrim();
        if (title != null) {
            log.debug((Object)("Setting title: " + title));
            this.pdf.addTitle(title);
        }
        this.pdf.addCreationDate();
        this.pdf.addCreator(this.getClass().getPackage().toString());
        Iterator it = headEl.elementIterator("meta");
        while (it.hasNext()) {
            org.dom4j.Element metaEl = (org.dom4j.Element)it.next();
            String keyw = metaEl.attributeValue("http-equiv");
            if (keyw.equals("keywords")) {
                keyw = metaEl.attributeValue("content");
                if (keyw == null || keyw.equals("")) continue;
                this.pdf.addKeywords(keyw);
                continue;
            }
            if (keyw.equals("author")) {
                keyw = metaEl.attributeValue("content");
                if (keyw == null || keyw.equals("")) continue;
                this.pdf.addAuthor(keyw);
                continue;
            }
            if (!keyw.equals("description") || (keyw = metaEl.attributeValue("content")) == null || keyw.equals("")) continue;
            this.pdf.addSubject(keyw);
        }
        this.pdf.open();
    }

    public synchronized void close() {
        log.debug((Object)"Closing the document.");
        this.pdf.close();
        this.pdf = null;
    }

    public PDFStyleFormatter getStyleFormatter() {
        return this.pdfFormatter;
    }

    public void print() throws RenderingException {
        this.renderStaticBlockBox(this.pdf, this.rootBox);
    }

    protected void renderStaticBlockBox(Object nativeContainer, CSSContainerBox box) {
        CSSBoxContainer container = box.asContainerBox();
        if (container instanceof CSSBlockBoxContainer) {
            List<CSSContainerBox> blockBoxes = ((CSSBlockBoxContainer)container).getStaticallyPositioned();
            for (CSSContainerBox bbox : blockBoxes) {
                System.err.println("Rendering box: " + bbox.getComputedStyle().getPeerXPath());
                if (bbox instanceof ReplacedElementBox) continue;
                Element elem = this.nativePeer(bbox);
                if (elem == null) {
                    if (nativeContainer instanceof Element) {
                        elem = (Element)nativeContainer;
                    } else {
                        this.renderStaticBlockBox(nativeContainer, bbox);
                        continue;
                    }
                }
                this.renderStaticBlockBox(elem, bbox);
                this.addNativeObject(nativeContainer, elem);
            }
        } else if (container instanceof CSSInlineBoxContainer) {
            List<CSSBox> inBoxes = ((CSSInlineBoxContainer)container).getInlineBoxes();
            for (CSSBox b : inBoxes) {
                CSSInlineBox inBox;
                if (b instanceof CSSInlineBox) {
                    inBox = (CSSInlineBox)b;
                } else {
                    if (!((b = ((RunInBox)b).finalBox()) instanceof CSSInlineBox)) continue;
                    inBox = (CSSInlineBox)b;
                }
                this.addNativeObject(nativeContainer, (Element)this.renderInlineBox(inBox));
            }
        }
        this.format(nativeContainer, box);
    }

    protected Phrase renderInlineBox(CSSInlineBox box) {
        System.err.println("Rendering inline box: " + box.getComputedStyle().getPeerXPath());
        Chunk chunk = this.pdfFormatter.createChunk(box);
        Phrase phrase = this.pdfFormatter.createPhrase(box);
        phrase.add((Element)chunk);
        return phrase;
    }

    protected void addNativeObject(Object nativeContainer, Element child) {
        if (nativeContainer instanceof TextElementArray) {
            ((TextElementArray)nativeContainer).add(child);
        } else if (nativeContainer instanceof PdfPCell) {
            ((PdfPCell)nativeContainer).addElement(child);
        } else if (nativeContainer instanceof Document) {
            try {
                ((Document)nativeContainer).add(child);
            }
            catch (DocumentException e) {
                throw new IllegalStateException(e);
            }
        } else if (nativeContainer != null) {
            System.err.println("Lost child: " + child.getClass().getName() + " for parent " + nativeContainer.getClass().getName());
        }
    }

    protected Element nativePeer(CSSContainerBox box) {
        List<CSSTableRowBox> rows;
        CSSBoxContainer container = box.asContainerBox();
        PdfPCell wrapped = null;
        if (box instanceof CSSTableCellBox) {
            wrapped = new PdfPCell();
        } else if (container instanceof CSSInlineBoxContainer) {
            wrapped = new Paragraph();
        } else if (box instanceof ListItemBox) {
            wrapped = new ListItem();
        } else if (container instanceof CSSBlockBoxContainer) {
            CSSContainerBox firstChild;
            List<CSSContainerBox> childBlocks = ((CSSBlockBoxContainer)container).getStaticallyPositioned();
            if (!childBlocks.isEmpty() && (firstChild = childBlocks.get(0)) instanceof ListItemBox) {
                wrapped = new com.itextpdf.text.List();
            }
        } else if (container instanceof CSSTableRowContainer && !(rows = ((CSSTableRowContainer)container).getRows()).isEmpty()) {
            int columns = rows.get(0).getColumnCount();
            wrapped = new PdfPTable(columns);
        }
        return wrapped;
    }

    protected Object nativePeer(ReplacedElementBox<Image> box) {
        Image peer = null;
        if (box instanceof PDFImgReplacedBox) {
            peer = ((PDFImgReplacedBox)box).getNativeContent();
        } else if (box instanceof PDFInputTextReplacedBox) {
            peer = ((PDFInputTextReplacedBox)box).createPDFField(this.getPdfWriter());
        }
        return peer;
    }

    protected void format(Object o, CSSContainerBox box) {
        if (o instanceof Rectangle) {
            this.pdfFormatter.formatRectangle(box, (Rectangle)o);
        }
        if (o instanceof Paragraph) {
            this.pdfFormatter.formatParagraph(box, (Paragraph)o);
            if (o instanceof ListItem) {
                this.pdfFormatter.formatListItem(box, (ListItem)o);
            }
        } else if (o instanceof PdfPCell) {
            this.pdfFormatter.formatPCell((CSSTableCellBox)box, (PdfPCell)o);
        } else if (o instanceof PdfPTable) {
            this.pdfFormatter.formatPTable(box, (PdfPTable)o);
        } else if (o instanceof com.itextpdf.text.List) {
            this.pdfFormatter.formatList(box, (com.itextpdf.text.List)o);
        } else if (o instanceof Document) {
            this.pdfFormatter.formatDocument(box, (Document)o);
        }
    }

    public static void main(String[] args) throws Exception {
        String urlString = "http://informatica.info/index";
        URL url = new URL(urlString);
        PDFUserAgent agent = new PDFUserAgent();
        XHTMLDocument xdoc = agent.readURL(url);
        PDFRenderer renderer = new PDFRenderer();
        renderer.setDocument(xdoc);
        String fileName = "c:/tmp/test.pdf";
        FileOutputStream out = new FileOutputStream(fileName);
        renderer.open(out);
        renderer.print();
        renderer.close();
        out.close();
    }
}

