/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.pdf.itext;

import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import info.informatica.doc.style.css.AbstractStyleDatabase;
import org.w3c.dom.DOMException;

public class PDFStyleDatabase
extends AbstractStyleDatabase {
    protected Rectangle pageSize = null;

    public PDFStyleDatabase() {
        this(PageSize.A4);
    }

    public PDFStyleDatabase(Rectangle pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String getDefaultGenericFontFamily(String genericFamily) {
        String fontName = null;
        if (genericFamily.equals("serif")) {
            fontName = "Times-Roman";
        } else if (genericFamily.equals("sans serif")) {
            fontName = "Helvetica";
        } else if (genericFamily.equals("monospace")) {
            fontName = "Courier";
        } else if (genericFamily.equals("fantasy")) {
            fontName = "ZapfDingbats";
        }
        return fontName;
    }

    @Override
    public boolean isFontFamilyAvailable(String fontFamily) {
        return !Font.getFamily((String)fontFamily).equals((Object)Font.FontFamily.UNDEFINED);
    }

    @Override
    public int getFontSizeFromIdentifier(String familyName, String fontSizeIdentifier) throws DOMException {
        int sz;
        if (fontSizeIdentifier.equals("xx-small")) {
            sz = 8;
        } else if (fontSizeIdentifier.equals("x-small")) {
            sz = 9;
        } else if (fontSizeIdentifier.equals("small")) {
            sz = 10;
        } else if (fontSizeIdentifier.equals("medium")) {
            sz = 12;
        } else if (fontSizeIdentifier.equals("large")) {
            sz = 14;
        } else if (fontSizeIdentifier.equals("x-large")) {
            sz = 16;
        } else if (fontSizeIdentifier.equals("xx-large")) {
            sz = 18;
        } else {
            throw new DOMException(15, "Unknown size identifier: " + fontSizeIdentifier);
        }
        return sz;
    }

    @Override
    public float getDocumentHeight() {
        return this.pageSize.getHeight();
    }

    public short getFontSizeUnit() {
        return 9;
    }

    @Override
    public short getNaturalUnit() {
        return 9;
    }

    @Override
    public float getDocumentWidth() {
        return this.pageSize.getWidth();
    }

    @Override
    public float getWidthSize(String widthIdentifier) throws DOMException {
        if ("thin".equals(widthIdentifier)) {
            return 0.1f;
        }
        if ("thick".equals(widthIdentifier)) {
            return 1.2f;
        }
        if ("medium".equals(widthIdentifier)) {
            return 0.8f;
        }
        throw new DOMException(12, "Unknown identifier " + widthIdentifier);
    }

    @Override
    protected float cmToPixels(float cm) {
        double width = 1024.0;
        double height = 768.0;
        double diag = Math.sqrt(width * width + height * height);
        return (float)((double)cm * diag / 43.18);
    }

    @Override
    protected float pxTocm(int px) {
        double width = 1024.0;
        double height = 768.0;
        double diag = Math.sqrt(width * width + height * height);
        return (float)((double)px * 43.18 / diag);
    }
}

