/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.pdf.itext;

import com.itextpdf.text.BadElementException;
import info.informatica.doc.agent.ResourceDownloader;
import info.informatica.doc.dom4j.DOM4JUserAgent;
import info.informatica.doc.pdf.itext.PDFStyleDatabase;
import info.informatica.doc.pdf.itext.PDFXHTMLElementReplacer;
import info.informatica.doc.style.css.StyleDatabase;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class PDFUserAgent
extends DOM4JUserAgent<com.itextpdf.text.Image> {
    private StyleDatabase styleDb;

    public PDFUserAgent() {
        this(new PDFStyleDatabase());
    }

    public PDFUserAgent(PDFStyleDatabase styleDb) {
        this.styleDb = styleDb;
        this.setElementReplacer("http://www.w3.org/1999/xhtml", new PDFXHTMLElementReplacer());
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    @Override
    public ResourceDownloader<com.itextpdf.text.Image> createDownloader(URL url) {
        return new PDFImageDownloader(url);
    }

    class PDFImageDownloader
    extends ResourceDownloader<com.itextpdf.text.Image> {
        public PDFImageDownloader(URL url) {
            super(url);
        }

        @Override
        protected void readContent(InputStream is) throws IOException {
            try {
                this.nativeContent = com.itextpdf.text.Image.getInstance((Image)ImageIO.read(is), null, (boolean)false);
            }
            catch (BadElementException e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
    }
}

