/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.AbstractStyleDatabase;
import info.informatica.doc.style.css.SACParserFactory;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.StyleDeclarationFactory;
import info.informatica.doc.style.css.dom.CSSStyleDeclarationRule;
import info.informatica.doc.style.css.dom.LexicalPropertyListener;
import info.informatica.doc.style.css.dom.PropertyDocumentHandler;
import info.informatica.doc.style.css.property.AbstractCSSPrimitiveValue;
import info.informatica.doc.style.css.property.AbstractCSSValue;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.property.CSSShorthandValue;
import info.informatica.doc.style.css.property.PropertyDatabase;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSS2Properties;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class BaseCSSStyleDeclaration
implements CSSStyleDeclaration,
LexicalPropertyListener,
Cloneable {
    private CSSStyleDeclarationRule parentRule;
    private HashMap<String, CSSValue> propValue = null;
    private ArrayList<String> propertyList = null;
    private ArrayList<String> priorities = null;
    private StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = null;
    private CSS2Properties css2properties = new CSS2PropertiesImpl();
    private StyleDatabase styleDb = null;
    static Logger log = Logger.getLogger((String)BaseCSSStyleDeclaration.class.getName());

    BaseCSSStyleDeclaration(CSSStyleDeclarationRule parentRule) {
        this.parentRule = parentRule;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
    }

    public BaseCSSStyleDeclaration() {
        this.parentRule = null;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
    }

    protected BaseCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
        this.parentRule = (CSSStyleDeclarationRule)copiedObject.getParentRule();
        this.priorities = (ArrayList)copiedObject.priorities.clone();
        this.propertyList = (ArrayList)copiedObject.propertyList.clone();
        this.propValue = (HashMap)copiedObject.propValue.clone();
    }

    @Override
    public String getCssText() {
        int sz = this.propertyList.size();
        StringBuilder sb = new StringBuilder(50 + sz * 10);
        for (int i = 0; i < sz; ++i) {
            String ptyname = this.propertyList.get(i);
            CSSValue cssVal = this.propValue.get(ptyname);
            if (cssVal instanceof AbstractCSSPrimitiveValue && ((AbstractCSSPrimitiveValue)cssVal).isSubproperty()) continue;
            String prio = this.priorities.get(i);
            sb.append(ptyname).append(':').append(' ').append(this.propValue.get(ptyname).getCssText());
            if (prio != null && "important".equals(prio)) {
                sb.append(" ! important");
            }
            sb.append(';').append(' ');
        }
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource();
        StringReader re = new StringReader(cssText);
        source.setCharacterStream((Reader)re);
        this.clear();
        StyleDeclarationDocumentHandler handler = this.getStyleDeclarationDocumentHandler();
        handler.setLexicalRuleListener(this);
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseStyleDeclaration(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(12, e.getMessage());
        }
    }

    @Override
    public String getPropertyValue(String propertyName) {
        CSSValue value = this.getCSSValue(propertyName);
        if (value != null) {
            if (value instanceof CSSPrimitiveValue && ((CSSPrimitiveValue)value).getPrimitiveType() == 19) {
                return ((CSSPrimitiveValue)value).getStringValue();
            }
            return value.getCssText();
        }
        return "";
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        if (PropertyDatabase.getInstance().isShorthand(propertyName)) {
            return null;
        }
        return this.getCSSValue(propertyName);
    }

    protected CSSValue getCSSValue(String propertyName) {
        return this.getDeclaredCSSValue(propertyName);
    }

    protected CSSValue getDeclaredCSSValue(String propertyName) {
        return this.propValue.get(propertyName);
    }

    @Override
    public synchronized String removeProperty(String propertyName) throws DOMException {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx >= 0) {
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            return this.propValue.remove(propertyName).getCssText();
        }
        return "";
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx < 0) {
            return "";
        }
        String prio = this.priorities.get(idx);
        if (prio != null) {
            return prio;
        }
        return "";
    }

    @Override
    public void setProperty(String propertyName, LexicalUnit value, String priority) throws DOMException {
        if (priority != null) {
            priority = priority.intern();
        }
        if (PropertyDatabase.getInstance().isShorthand(propertyName)) {
            CSSShorthandValue shVal = new CSSShorthandValue();
            this.setProperty(propertyName, shVal, priority);
            String cssText = this.setSubproperties(propertyName, value, priority);
            shVal.setShorthandText(cssText);
        } else {
            CSSValue cssvalue = AbstractCSSValue.createCSSValue(value);
            this.setProperty(propertyName, cssvalue, priority);
        }
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        Parser parser;
        try {
            parser = SACParserFactory.createSACParser();
        }
        catch (DOMException e) {
            throw new DOMException(7, e.getMessage());
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(value);
        source.setCharacterStream((Reader)re);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        this.setProperty(propertyName, lunit, priority);
    }

    void setProperty(String propertyName, CSSValue cssValue, String priority) {
        if (!this.propertyList.contains(propertyName = propertyName.intern())) {
            this.addProperty(propertyName, cssValue, priority);
        } else {
            int idx = this.propertyList.indexOf(propertyName);
            if (!"important".equals(this.priorities.get(idx)) || "important".equals(priority)) {
                this.propertyList.remove(idx);
                this.priorities.remove(idx);
                this.addProperty(propertyName, cssValue, priority);
            }
        }
    }

    private void addProperty(String propertyName, CSSValue cssValue, String priority) {
        this.propertyList.add(propertyName);
        this.priorities.add(priority);
        this.propValue.put(propertyName, cssValue);
    }

    @Override
    public int getLength() {
        return this.propertyList.size();
    }

    @Override
    public String item(int index) {
        if (index < 0 || index > this.propertyList.size()) {
            return "";
        }
        return this.propertyList.get(index);
    }

    void clear() {
        this.propValue.clear();
        this.propertyList.clear();
        this.priorities.clear();
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule;
    }

    public void addStyle(BaseCSSStyleDeclaration style) {
        Iterator<String> it = style.propertyList.iterator();
        int i = 0;
        while (it.hasNext()) {
            String propertyName = it.next();
            if (!this.propertyList.contains(propertyName)) {
                this.propertyList.add(propertyName);
                this.priorities.add(style.priorities.get(i));
            } else {
                if ("important".equals(this.priorities.get(i))) continue;
                this.priorities.set(i, style.priorities.get(i));
            }
            this.propValue.put(propertyName, style.propValue.get(propertyName));
        }
    }

    public void prioritySplit(BaseCSSStyleDeclaration importantDecl, BaseCSSStyleDeclaration normalDecl) {
        int psz = this.propertyList.size();
        for (int i = 0; i < psz; ++i) {
            String propertyName = this.propertyList.get(i);
            String priority = this.priorities.get(i);
            if ("important".equals(priority)) {
                importantDecl.addProperty(propertyName, this.propValue.get(propertyName), priority);
                continue;
            }
            normalDecl.addProperty(propertyName, this.propValue.get(propertyName), priority);
        }
    }

    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    public void setStyleDatabase(StyleDatabase styleDb) {
        this.styleDb = styleDb;
    }

    protected CSSValue defaultPropertyValue(String propertyName) {
        CSSValue defval = PropertyDatabase.getInstance().getInitialValue(propertyName);
        if (defval == null) {
            if (propertyName.equals("color")) {
                defval = this.getStyleDatabase().getInitialColor();
            } else if (propertyName.equals("font-family")) {
                defval = StyleDeclarationFactory.parseProperty(this.getStyleDatabase().getDefaultGenericFontFamily());
            } else if (propertyName.equals("text-align")) {
                String directionValue = this.getPropertyValue("direction");
                defval = directionValue.equals("rtl") ? StyleDeclarationFactory.parseProperty("right") : StyleDeclarationFactory.parseProperty("left");
            } else if (propertyName.equals("border-top-color")) {
                defval = this.getColor();
            } else if (propertyName.equals("border-right-color")) {
                defval = this.getColor();
            } else if (propertyName.equals("border-bottom-color")) {
                defval = this.getColor();
            } else if (propertyName.equals("border-left-color")) {
                defval = this.getColor();
            } else if (propertyName.equals("quotes")) {
                defval = StyleDeclarationFactory.parseProperty("\" \"");
            }
        }
        return defval;
    }

    public CSSPrimitiveValue getColor() {
        CSSPrimitiveValue color = (CSSPrimitiveValue)this.getCSSValue("color");
        if (color == null) {
            color = this.styleDb != null ? this.getStyleDatabase().getInitialColor() : AbstractStyleDatabase.DEFAULT_INITIAL_COLOR;
        }
        return color;
    }

    protected String setSubproperties(String propertyName, LexicalUnit value, String priority) throws DOMException {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        if (pdb.isShorthand(propertyName)) {
            ShorthandSetter setter = "font".equals(propertyName) ? new FontShorthandSetter() : ("margin".equals(propertyName) ? new BoxShorthandSetter(propertyName) : ("padding".equals(propertyName) ? new BoxShorthandSetter("padding") : ("border".equals(propertyName) ? new BorderShorthandSetter() : ("border-width".equals(propertyName) ? new BoxShorthandSetter("border-width") : ("border-style".equals(propertyName) ? new BoxShorthandSetter("border-style") : ("border-color".equals(propertyName) ? new BoxShorthandSetter("border-color") : ("border-top".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "top") : ("border-right".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "right") : ("border-bottom".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "bottom") : ("border-left".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "left") : new ShorthandSetter(propertyName)))))))))));
            setter.init(value, priority);
            setter.assignSubproperties();
            return setter.getCssText();
        }
        return null;
    }

    public BaseCSSStyleDeclaration clone() {
        return new BaseCSSStyleDeclaration(this);
    }

    StyleDeclarationDocumentHandler getStyleDeclarationDocumentHandler() {
        if (this.styleDeclarationDocumentHandler == null) {
            this.styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
        }
        return this.styleDeclarationDocumentHandler;
    }

    public CSS2Properties getCSS2Properties() {
        return this.css2properties;
    }

    class CSS2PropertiesImpl
    implements CSS2Properties {
        CSS2PropertiesImpl() {
        }

        @Override
        public String getAzimuth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("azimuth");
        }

        @Override
        public void setAzimuth(String azimuth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("azimuth").setCssText(azimuth);
        }

        @Override
        public String getBackground() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background");
        }

        @Override
        public void setBackground(String background) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background").setCssText(background);
        }

        @Override
        public String getBackgroundAttachment() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background-attachment");
        }

        @Override
        public void setBackgroundAttachment(String backgroundAttachment) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background-attachment").setCssText(backgroundAttachment);
        }

        @Override
        public String getBackgroundColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background-color");
        }

        @Override
        public void setBackgroundColor(String backgroundColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background-color").setCssText(backgroundColor);
        }

        @Override
        public String getBackgroundImage() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background-image");
        }

        @Override
        public void setBackgroundImage(String backgroundImage) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background-attachment").setCssText(backgroundImage);
        }

        @Override
        public String getBackgroundPosition() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background-position");
        }

        @Override
        public void setBackgroundPosition(String backgroundPosition) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background-position").setCssText(backgroundPosition);
        }

        @Override
        public String getBackgroundRepeat() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background-repeat");
        }

        @Override
        public void setBackgroundRepeat(String backgroundRepeat) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background-repeat").setCssText(backgroundRepeat);
        }

        @Override
        public String getBorder() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border");
        }

        @Override
        public void setBorder(String border) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border").setCssText(border);
        }

        @Override
        public String getBorderCollapse() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-collapse");
        }

        @Override
        public void setBorderCollapse(String borderCollapse) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-collapse").setCssText(borderCollapse);
        }

        @Override
        public String getBorderColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-color");
        }

        @Override
        public void setBorderColor(String borderColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-color").setCssText(borderColor);
        }

        @Override
        public String getBorderSpacing() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-spacing");
        }

        @Override
        public void setBorderSpacing(String borderSpacing) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-spacing").setCssText(borderSpacing);
        }

        @Override
        public String getBorderStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-style");
        }

        @Override
        public void setBorderStyle(String borderStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-style").setCssText(borderStyle);
        }

        @Override
        public String getBorderTop() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-top");
        }

        @Override
        public void setBorderTop(String borderTop) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-top").setCssText(borderTop);
        }

        @Override
        public String getBorderRight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-right");
        }

        @Override
        public void setBorderRight(String borderRight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-right").setCssText(borderRight);
        }

        @Override
        public String getBorderBottom() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-bottom");
        }

        @Override
        public void setBorderBottom(String borderBottom) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-bottom").setCssText(borderBottom);
        }

        @Override
        public String getBorderLeft() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-left");
        }

        @Override
        public void setBorderLeft(String borderLeft) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-left").setCssText(borderLeft);
        }

        @Override
        public String getBorderTopColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-top-color");
        }

        @Override
        public void setBorderTopColor(String borderTopColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-top-color").setCssText(borderTopColor);
        }

        @Override
        public String getBorderRightColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-right-color");
        }

        @Override
        public void setBorderRightColor(String borderRightColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-right-color").setCssText(borderRightColor);
        }

        @Override
        public String getBorderBottomColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-bottom-color");
        }

        @Override
        public void setBorderBottomColor(String borderBottomColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-bottom-color").setCssText(borderBottomColor);
        }

        @Override
        public String getBorderLeftColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-left-color");
        }

        @Override
        public void setBorderLeftColor(String borderLeftColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-left-color").setCssText(borderLeftColor);
        }

        @Override
        public String getBorderTopStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-top-style");
        }

        @Override
        public void setBorderTopStyle(String borderTopStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-top-style").setCssText(borderTopStyle);
        }

        @Override
        public String getBorderRightStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-right-style");
        }

        @Override
        public void setBorderRightStyle(String borderRightStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-right-style").setCssText(borderRightStyle);
        }

        @Override
        public String getBorderBottomStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-bottom-style");
        }

        @Override
        public void setBorderBottomStyle(String borderBottomStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-bottom-style").setCssText(borderBottomStyle);
        }

        @Override
        public String getBorderLeftStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-left-style");
        }

        @Override
        public void setBorderLeftStyle(String borderLeftStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-left-style").setCssText(borderLeftStyle);
        }

        @Override
        public String getBorderTopWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-top-width");
        }

        @Override
        public void setBorderTopWidth(String borderTopWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-top-width").setCssText(borderTopWidth);
        }

        @Override
        public String getBorderRightWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-right-width");
        }

        @Override
        public void setBorderRightWidth(String borderRightWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-right-width").setCssText(borderRightWidth);
        }

        @Override
        public String getBorderBottomWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-bottom-width");
        }

        @Override
        public void setBorderBottomWidth(String borderBottomWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-bottom-width").setCssText(borderBottomWidth);
        }

        @Override
        public String getBorderLeftWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-left-width");
        }

        @Override
        public void setBorderLeftWidth(String borderLeftWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-left-width").setCssText(borderLeftWidth);
        }

        @Override
        public String getBorderWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-width");
        }

        @Override
        public void setBorderWidth(String borderWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-width").setCssText(borderWidth);
        }

        @Override
        public String getBottom() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("bottom");
        }

        @Override
        public void setBottom(String bottom) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("bottom").setCssText(bottom);
        }

        @Override
        public String getCaptionSide() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("caption-side");
        }

        @Override
        public void setCaptionSide(String captionSide) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("caption-side").setCssText(captionSide);
        }

        @Override
        public String getClear() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("clear");
        }

        @Override
        public void setClear(String clear) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("clear").setCssText(clear);
        }

        @Override
        public String getClip() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("clip");
        }

        @Override
        public void setClip(String clip) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("clip").setCssText(clip);
        }

        @Override
        public String getColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("color");
        }

        @Override
        public void setColor(String color) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("color").setCssText(color);
        }

        @Override
        public String getContent() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("content");
        }

        @Override
        public void setContent(String content) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("content").setCssText(content);
        }

        @Override
        public String getCounterIncrement() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("counter-increment");
        }

        @Override
        public void setCounterIncrement(String counterIncrement) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("counter-increment").setCssText(counterIncrement);
        }

        @Override
        public String getCounterReset() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("counter-reset");
        }

        @Override
        public void setCounterReset(String counterReset) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("counter-reset").setCssText(counterReset);
        }

        @Override
        public String getCue() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("cue");
        }

        @Override
        public void setCue(String cue) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("cue").setCssText(cue);
        }

        @Override
        public String getCueAfter() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("cue-after");
        }

        @Override
        public void setCueAfter(String cueAfter) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("cue-after").setCssText(cueAfter);
        }

        @Override
        public String getCueBefore() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("cue-before");
        }

        @Override
        public void setCueBefore(String cueBefore) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("cue-before").setCssText(cueBefore);
        }

        @Override
        public String getCursor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("cursor");
        }

        @Override
        public void setCursor(String cursor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("cursor").setCssText(cursor);
        }

        @Override
        public String getDirection() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("direction");
        }

        @Override
        public void setDirection(String direction) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("direction").setCssText(direction);
        }

        @Override
        public String getDisplay() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("display");
        }

        @Override
        public void setDisplay(String display) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("display").setCssText(display);
        }

        @Override
        public String getElevation() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("elevation");
        }

        @Override
        public void setElevation(String elevation) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("elevation").setCssText(elevation);
        }

        @Override
        public String getEmptyCells() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("empty-cells");
        }

        @Override
        public void setEmptyCells(String emptyCells) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("empty-cells").setCssText(emptyCells);
        }

        @Override
        public String getCssFloat() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("css-float");
        }

        @Override
        public void setCssFloat(String cssFloat) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("css-float").setCssText(cssFloat);
        }

        @Override
        public String getFont() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font");
        }

        @Override
        public void setFont(String font) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font").setCssText(font);
        }

        @Override
        public String getFontFamily() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-family");
        }

        @Override
        public void setFontFamily(String fontFamily) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-family").setCssText(fontFamily);
        }

        @Override
        public String getFontSize() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-size");
        }

        @Override
        public void setFontSize(String fontSize) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-size").setCssText(fontSize);
        }

        @Override
        public String getFontSizeAdjust() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-size-adjust");
        }

        @Override
        public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-size-adjust").setCssText(fontSizeAdjust);
        }

        @Override
        public String getFontStretch() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-stretch");
        }

        @Override
        public void setFontStretch(String fontStretch) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-stretch").setCssText(fontStretch);
        }

        @Override
        public String getFontStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-style");
        }

        @Override
        public void setFontStyle(String fontStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-style").setCssText(fontStyle);
        }

        @Override
        public String getFontVariant() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-variant");
        }

        @Override
        public void setFontVariant(String fontVariant) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-variant").setCssText(fontVariant);
        }

        @Override
        public String getFontWeight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-weight");
        }

        @Override
        public void setFontWeight(String fontWeight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-weight").setCssText(fontWeight);
        }

        @Override
        public String getHeight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("height");
        }

        @Override
        public void setHeight(String height) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("height").setCssText(height);
        }

        @Override
        public String getLeft() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("left");
        }

        @Override
        public void setLeft(String left) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("left").setCssText(left);
        }

        @Override
        public String getLetterSpacing() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("letter-spacing");
        }

        @Override
        public void setLetterSpacing(String letterSpacing) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("letter-spacing").setCssText(letterSpacing);
        }

        @Override
        public String getLineHeight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("line-height");
        }

        @Override
        public void setLineHeight(String lineHeight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("line-height").setCssText(lineHeight);
        }

        @Override
        public String getListStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("list-style");
        }

        @Override
        public void setListStyle(String listStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("list-style").setCssText(listStyle);
        }

        @Override
        public String getListStyleImage() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("list-style-image");
        }

        @Override
        public void setListStyleImage(String listStyleImage) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("list-style-image").setCssText(listStyleImage);
        }

        @Override
        public String getListStylePosition() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("list-style-position");
        }

        @Override
        public void setListStylePosition(String listStylePosition) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("list-style-position").setCssText(listStylePosition);
        }

        @Override
        public String getListStyleType() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("list-style-type");
        }

        @Override
        public void setListStyleType(String listStyleType) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("list-style-type").setCssText(listStyleType);
        }

        @Override
        public String getMargin() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("margin");
        }

        @Override
        public void setMargin(String margin) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("margin").setCssText(margin);
        }

        @Override
        public String getMarginTop() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("margin-top");
        }

        @Override
        public void setMarginTop(String marginTop) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("margin-top").setCssText(marginTop);
        }

        @Override
        public String getMarginRight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("margin-right");
        }

        @Override
        public void setMarginRight(String marginRight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("margin-right").setCssText(marginRight);
        }

        @Override
        public String getMarginBottom() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("margin-bottom");
        }

        @Override
        public void setMarginBottom(String marginBottom) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("margin-bottom").setCssText(marginBottom);
        }

        @Override
        public String getMarginLeft() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("margin-left");
        }

        @Override
        public void setMarginLeft(String marginLeft) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("margin-left").setCssText(marginLeft);
        }

        @Override
        public String getMarkerOffset() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("marker-offset");
        }

        @Override
        public void setMarkerOffset(String markerOffset) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("marker-offset").setCssText(markerOffset);
        }

        @Override
        public String getMarks() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("marks");
        }

        @Override
        public void setMarks(String marks) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("marks").setCssText(marks);
        }

        @Override
        public String getMaxHeight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("max-height");
        }

        @Override
        public void setMaxHeight(String maxHeight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("max-height").setCssText(maxHeight);
        }

        @Override
        public String getMaxWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("max-width");
        }

        @Override
        public void setMaxWidth(String maxWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("max-width").setCssText(maxWidth);
        }

        @Override
        public String getMinHeight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("min-height");
        }

        @Override
        public void setMinHeight(String minHeight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("min-height").setCssText(minHeight);
        }

        @Override
        public String getMinWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("min-width");
        }

        @Override
        public void setMinWidth(String minWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("min-width").setCssText(minWidth);
        }

        @Override
        public String getOrphans() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("orphans");
        }

        @Override
        public void setOrphans(String orphans) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("orphans").setCssText(orphans);
        }

        @Override
        public String getOutline() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("outline");
        }

        @Override
        public void setOutline(String outline) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("outline").setCssText(outline);
        }

        @Override
        public String getOutlineColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("outline-color");
        }

        @Override
        public void setOutlineColor(String outlineColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("outline-color").setCssText(outlineColor);
        }

        @Override
        public String getOutlineStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("outline-style");
        }

        @Override
        public void setOutlineStyle(String outlineStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("outline-style").setCssText(outlineStyle);
        }

        @Override
        public String getOutlineWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("outline-width");
        }

        @Override
        public void setOutlineWidth(String outlineWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("outline-width").setCssText(outlineWidth);
        }

        @Override
        public String getOverflow() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("overflow");
        }

        @Override
        public void setOverflow(String overflow) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("overflow").setCssText(overflow);
        }

        @Override
        public String getPadding() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("padding");
        }

        @Override
        public void setPadding(String padding) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("padding").setCssText(padding);
        }

        @Override
        public String getPaddingTop() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("padding-top");
        }

        @Override
        public void setPaddingTop(String paddingTop) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("padding-top").setCssText(paddingTop);
        }

        @Override
        public String getPaddingRight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("padding-right");
        }

        @Override
        public void setPaddingRight(String paddingRight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("padding-right").setCssText(paddingRight);
        }

        @Override
        public String getPaddingBottom() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("padding-bottom");
        }

        @Override
        public void setPaddingBottom(String paddingBottom) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("padding-bottom").setCssText(paddingBottom);
        }

        @Override
        public String getPaddingLeft() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("padding-left");
        }

        @Override
        public void setPaddingLeft(String paddingLeft) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("padding-left").setCssText(paddingLeft);
        }

        @Override
        public String getPage() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("page");
        }

        @Override
        public void setPage(String page) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("page").setCssText(page);
        }

        @Override
        public String getPageBreakAfter() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("page-break-after");
        }

        @Override
        public void setPageBreakAfter(String pageBreakAfter) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("page-break-after").setCssText(pageBreakAfter);
        }

        @Override
        public String getPageBreakBefore() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("page-break-before");
        }

        @Override
        public void setPageBreakBefore(String pageBreakBefore) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("page-break-before").setCssText(pageBreakBefore);
        }

        @Override
        public String getPageBreakInside() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("page-break-inside");
        }

        @Override
        public void setPageBreakInside(String pageBreakInside) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("page-break-inside").setCssText(pageBreakInside);
        }

        @Override
        public String getPause() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("pause");
        }

        @Override
        public void setPause(String pause) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("pause").setCssText(pause);
        }

        @Override
        public String getPauseAfter() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("pause-after");
        }

        @Override
        public void setPauseAfter(String pauseAfter) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("pause-after").setCssText(pauseAfter);
        }

        @Override
        public String getPauseBefore() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("pause-before");
        }

        @Override
        public void setPauseBefore(String pauseBefore) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("pause-before").setCssText(pauseBefore);
        }

        @Override
        public String getPitch() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("pitch");
        }

        @Override
        public void setPitch(String pitch) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("pitch").setCssText(pitch);
        }

        @Override
        public String getPitchRange() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("pitch-range");
        }

        @Override
        public void setPitchRange(String pitchRange) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("pitch-range").setCssText(pitchRange);
        }

        @Override
        public String getPlayDuring() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("play-during");
        }

        @Override
        public void setPlayDuring(String playDuring) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("play-during").setCssText(playDuring);
        }

        @Override
        public String getPosition() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("position");
        }

        @Override
        public void setPosition(String position) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("position").setCssText(position);
        }

        @Override
        public String getQuotes() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("quotes");
        }

        @Override
        public void setQuotes(String quotes) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("quotes").setCssText(quotes);
        }

        @Override
        public String getRichness() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("richness");
        }

        @Override
        public void setRichness(String richness) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("richness").setCssText(richness);
        }

        @Override
        public String getRight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("right");
        }

        @Override
        public void setRight(String right) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("right").setCssText(right);
        }

        @Override
        public String getSize() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("size");
        }

        @Override
        public void setSize(String size) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("size").setCssText(size);
        }

        @Override
        public String getSpeak() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("speak");
        }

        @Override
        public void setSpeak(String speak) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("speak").setCssText(speak);
        }

        @Override
        public String getSpeakHeader() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("speak-header");
        }

        @Override
        public void setSpeakHeader(String speakHeader) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("speak-header").setCssText(speakHeader);
        }

        @Override
        public String getSpeakNumeral() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("speak-numeral");
        }

        @Override
        public void setSpeakNumeral(String speakNumeral) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("speak-numeral").setCssText(speakNumeral);
        }

        @Override
        public String getSpeakPunctuation() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("speak-punctuation");
        }

        @Override
        public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("speak-punctuation").setCssText(speakPunctuation);
        }

        @Override
        public String getSpeechRate() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("speech-rate");
        }

        @Override
        public void setSpeechRate(String speechRate) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("speech-rate").setCssText(speechRate);
        }

        @Override
        public String getStress() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("stress");
        }

        @Override
        public void setStress(String stress) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("stress").setCssText(stress);
        }

        @Override
        public String getTableLayout() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("table-layout");
        }

        @Override
        public void setTableLayout(String tableLayout) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("table-layout").setCssText(tableLayout);
        }

        @Override
        public String getTextAlign() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("text-align");
        }

        @Override
        public void setTextAlign(String textAlign) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("text-align").setCssText(textAlign);
        }

        @Override
        public String getTextDecoration() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("text-decoration");
        }

        @Override
        public void setTextDecoration(String textDecoration) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("text-decoration").setCssText(textDecoration);
        }

        @Override
        public String getTextIndent() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("text-indent");
        }

        @Override
        public void setTextIndent(String textIndent) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("text-indent").setCssText(textIndent);
        }

        @Override
        public String getTextShadow() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("text-shadow");
        }

        @Override
        public void setTextShadow(String textShadow) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("text-shadow").setCssText(textShadow);
        }

        @Override
        public String getTextTransform() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("text-transform");
        }

        @Override
        public void setTextTransform(String textTransform) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("text-transform").setCssText(textTransform);
        }

        @Override
        public String getTop() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("top");
        }

        @Override
        public void setTop(String top) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("top").setCssText(top);
        }

        @Override
        public String getUnicodeBidi() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("unicode-bidi");
        }

        @Override
        public void setUnicodeBidi(String unicodeBidi) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("unicode-bidi").setCssText(unicodeBidi);
        }

        @Override
        public String getVerticalAlign() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("vertical-align");
        }

        @Override
        public void setVerticalAlign(String verticalAlign) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("vertical-align").setCssText(verticalAlign);
        }

        @Override
        public String getVisibility() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("visibility");
        }

        @Override
        public void setVisibility(String visibility) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("visibility").setCssText(visibility);
        }

        @Override
        public String getVoiceFamily() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("voice-family");
        }

        @Override
        public void setVoiceFamily(String voiceFamily) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("voice-family").setCssText(voiceFamily);
        }

        @Override
        public String getVolume() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("volume");
        }

        @Override
        public void setVolume(String volume) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("volume").setCssText(volume);
        }

        @Override
        public String getWhiteSpace() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("white-space");
        }

        @Override
        public void setWhiteSpace(String whiteSpace) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("white-space").setCssText(whiteSpace);
        }

        @Override
        public String getWidows() {
            return null;
        }

        @Override
        public void setWidows(String widows) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("widows").setCssText(widows);
        }

        @Override
        public String getWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("width");
        }

        @Override
        public void setWidth(String width) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("width").setCssText(width);
        }

        @Override
        public String getWordSpacing() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("word-spacing");
        }

        @Override
        public void setWordSpacing(String wordSpacing) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("word-spacing").setCssText(wordSpacing);
        }

        @Override
        public String getZIndex() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("z-index");
        }

        @Override
        public void setZIndex(String zIndex) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("z-index").setCssText(zIndex);
        }
    }

    class BorderSideShorthandSetter
    extends ShorthandSetter {
        private String pnameWidth;
        private String pnameStyle;
        private String pnameColor;

        BorderSideShorthandSetter(String shorthandName, String side) {
            super(shorthandName);
            this.pnameWidth = "border-" + side + "-width";
            this.pnameStyle = "border-" + side + "-style";
            this.pnameColor = "border-" + side + "-color";
        }

        @Override
        protected boolean assignSubproperty(String subproperty) {
            if (this.pnameWidth.equals(subproperty)) {
                CSSValue cssValue = this.createCSSValue(this.currentValue);
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("border-width") || cssValue instanceof CSSNumberValue) {
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.nextCurrentValue();
                    return true;
                }
            } else if (this.pnameStyle.equals(subproperty)) {
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("border-style")) {
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.nextCurrentValue();
                    return true;
                }
            } else if (this.pnameColor.equals(subproperty) && this.testColor(subproperty)) {
                CSSValue cssValue = this.createCSSValue(this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.currentValue = null;
                return true;
            }
            return false;
        }
    }

    class BorderShorthandSetter
    extends ShorthandSetter {
        BorderShorthandSetter() {
            super("border");
        }

        @Override
        protected boolean assignSubproperty(String subproperty) {
            if ("border-width".equals(subproperty)) {
                CSSValue cssValue = this.createCSSValue(this.currentValue);
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subproperty) || cssValue instanceof CSSNumberValue) {
                    String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                    for (int i = 0; i < subparray.length; ++i) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                    }
                    this.nextCurrentValue();
                    return true;
                }
            } else if ("border-style".equals(subproperty)) {
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subproperty)) {
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                    for (int i = 0; i < subparray.length; ++i) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                    }
                    this.nextCurrentValue();
                    return true;
                }
            } else if ("border-color".equals(subproperty) && this.testColor(subproperty)) {
                CSSValue cssValue = this.createCSSValue(this.currentValue);
                String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                for (int i = 0; i < subparray.length; ++i) {
                    this.setSubpropertyValue(subparray[i], cssValue);
                }
                this.currentValue = null;
                return true;
            }
            return false;
        }
    }

    class BoxShorthandSetter
    extends ShorthandSetter {
        BoxShorthandSetter(String shorthand) {
            super(shorthand);
        }

        @Override
        public void assignSubproperties() {
            String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
            switch (this.getPropertyCount()) {
                case 1: {
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    for (int i = 0; i < subparray.length; ++i) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                    }
                    break;
                }
                case 2: {
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subparray[0], cssValue);
                    this.setSubpropertyValue(subparray[2], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subparray[1], cssValue);
                    this.setSubpropertyValue(subparray[3], cssValue);
                    break;
                }
                case 3: {
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subparray[0], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subparray[1], cssValue);
                    this.setSubpropertyValue(subparray[3], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subparray[2], cssValue);
                    break;
                }
                case 4: {
                    for (int i = 0; i < subparray.length; ++i) {
                        CSSValue cssValue = this.createCSSValue(this.currentValue);
                        this.setSubpropertyValue(subparray[i], cssValue);
                        this.nextCurrentValue();
                    }
                    break;
                }
                default: {
                    log.error((Object)("Found " + Integer.toString(this.getPropertyCount()) + " values for '" + this.getShorthandName() + "' shorthand property"));
                }
            }
        }
    }

    class FontShorthandSetter
    extends ShorthandSetter {
        private LexicalUnit nextLex;

        FontShorthandSetter() {
            super("font");
            this.nextLex = null;
        }

        @Override
        protected void nextCurrentValue() {
            super.nextCurrentValue();
            this.nextLex = this.currentValue != null ? this.currentValue.getNextLexicalUnit() : null;
        }

        @Override
        protected boolean assignSubproperty(String subproperty) {
            if (subproperty.equals("font-size") && this.assignFontSize()) {
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 4) {
                    this.nextCurrentValue();
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    BaseCSSStyleDeclaration.this.setProperty("line-height", cssValue, this.getPriority());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Assigning shorthand subproperty line-height: " + cssValue.getCssText()));
                    }
                }
                this.nextCurrentValue();
                return true;
            }
            switch (this.currentValue.getLexicalUnitType()) {
                case 35: {
                    if (super.assignSubproperty(subproperty)) {
                        return true;
                    }
                    if (!subproperty.equals("font-family") || this.nextLex != null && this.nextLex.getLexicalUnitType() != 0) break;
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.currentValue = null;
                    this.nextLex = null;
                    return true;
                }
                case 36: {
                    if (!subproperty.equals("font-family")) break;
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.nextCurrentValue();
                    return true;
                }
            }
            return false;
        }

        protected boolean assignFontSize() {
            if (this.currentValue.getLexicalUnitType() == 35) {
                return super.assignSubproperty("font-size");
            }
            CSSValue cssValue = this.createCSSValue(this.currentValue);
            if (cssValue instanceof CSSNumberValue) {
                this.setSubpropertyValue("font-size", cssValue);
                this.nextCurrentValue();
                return true;
            }
            return false;
        }
    }

    class ShorthandSetter {
        private String shorthandName;
        private String priority = null;
        private PropertyDatabase pdb = PropertyDatabase.getInstance();
        protected LexicalUnit currentValue = null;
        private short valueCount = 0;
        private short propertyCount = 0;
        protected short lookupCount = 0;
        private StringBuilder valueBuffer = new StringBuilder(32);
        private List<String> unassignedProperties = new ArrayList<String>(6);
        private List<LexicalUnit> unassignedValues = new ArrayList<LexicalUnit>(8);

        ShorthandSetter(String shorthandName) {
            this.shorthandName = shorthandName;
        }

        public String getShorthandName() {
            return this.shorthandName;
        }

        public String getPriority() {
            return this.priority;
        }

        public final PropertyDatabase getPropertyDatabase() {
            return this.pdb;
        }

        public short getValueCount() {
            return this.valueCount;
        }

        public short getPropertyCount() {
            return this.propertyCount;
        }

        protected void addUnassignedProperty(String propertyName) {
            this.unassignedProperties.add(propertyName);
            int sz = this.unassignedValues.size();
            if (sz > 0 && !this.unassignedValues.get(sz - 1).equals(this.currentValue)) {
                this.unassignedValues.add(this.currentValue);
            }
        }

        protected List<String> getUnassignedProperties() {
            return this.unassignedProperties;
        }

        protected void nextCurrentValue() {
            if (this.currentValue != null) {
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 0) {
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                }
                this.appendValueString();
            }
        }

        public void init(LexicalUnit shorthandValue, String priority) {
            this.currentValue = shorthandValue;
            this.priority = priority;
            this.unassignedValues.clear();
            this.valueCount = 0;
            this.propertyCount = 0;
            this.valueBuffer.setLength(0);
            this.appendValueString();
            for (LexicalUnit value = shorthandValue; value != null; value = value.getNextLexicalUnit()) {
                this.valueCount = (short)(this.valueCount + 1);
                this.propertyCount = value.getLexicalUnitType() != 0 ? (short)(this.propertyCount + 1) : (short)(this.propertyCount - 1);
            }
        }

        protected void resetSubproperties() {
            List<String> props = this.getUnassignedProperties();
            for (String pname : props) {
                if (!this.getPropertyDatabase().isShorthand(pname)) {
                    this.setPropertyDefault(pname);
                    continue;
                }
                String[] sh = this.getPropertyDatabase().getShorthandSubproperties(pname);
                for (int i = 0; i < sh.length; ++i) {
                    this.setPropertyDefault(sh[i]);
                }
            }
        }

        private void setPropertyDefault(String pname) {
            CSSValue cssVal = BaseCSSStyleDeclaration.this.defaultPropertyValue(pname);
            if (cssVal != null) {
                ((AbstractCSSPrimitiveValue)cssVal).setSubproperty(true);
                BaseCSSStyleDeclaration.this.setProperty(pname, cssVal, this.getPriority());
            } else {
                log.info((Object)("No default for property " + pname));
            }
        }

        public void assignSubproperties() {
            String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
            ArrayList<Object> subp = new ArrayList<Object>(subparray.length);
            subp.addAll(Arrays.asList((Object[])subparray.clone()));
            block0: while (this.currentValue != null && this.lookupCount <= this.getValueCount()) {
                this.unassignedProperties.clear();
                for (int i = 0; i < subp.size(); ++i) {
                    String pname = (String)subp.get(i);
                    if (this.currentValue == null) continue block0;
                    if (!this.assignSubproperty(pname)) {
                        this.addUnassignedProperty(pname);
                    } else {
                        subp.remove(i);
                        --i;
                    }
                    this.lookupCount = (short)(this.lookupCount + 1);
                }
            }
            if (subp.size() > 0) {
                Iterator it = subp.iterator();
                while (it.hasNext()) {
                    this.addUnassignedProperty((String)it.next());
                }
            }
            this.resetSubproperties();
        }

        protected boolean assignSubproperty(String subproperty) {
            return 35 == this.currentValue.getLexicalUnitType() && this.assignIdentifiers(subproperty);
        }

        protected boolean assignIdentifiers(String subproperty) {
            if (this.testIdentifiers(subproperty)) {
                CSSValue cssValue = this.createCSSValue(this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.nextCurrentValue();
                return true;
            }
            return false;
        }

        protected boolean testIdentifiers(String subproperty) {
            return this.getPropertyDatabase().isIdentifierValue(subproperty, this.currentValue.getStringValue());
        }

        protected void setSubpropertyValue(String subproperty, CSSValue cssValue) {
            int szm1;
            BaseCSSStyleDeclaration.this.setProperty(subproperty, cssValue, this.getPriority());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Assigning shorthand subproperty " + subproperty + ": " + cssValue.getCssText()));
            }
            if ((szm1 = this.unassignedValues.size() - 1) >= 0) {
                if (this.unassignedValues.get(szm1).equals(this.currentValue)) {
                    this.unassignedValues.remove(szm1);
                    --szm1;
                }
                if (szm1 >= 0) {
                    StringBuilder sb = new StringBuilder(64);
                    sb.append("Unable to assign properties: ");
                    Iterator<String> it = this.unassignedProperties.iterator();
                    while (it.hasNext()) {
                        sb.append(' ').append(it.next());
                    }
                    log.warn((Object)sb.toString());
                }
            }
        }

        public CSSValue createCSSValue(LexicalUnit lunit) {
            return AbstractCSSValue.createCSSValue(this.currentValue, true);
        }

        protected void appendValueString() {
            CSSValue currentCss;
            if (this.currentValue != null && (currentCss = this.createCSSValue(this.currentValue)) != null) {
                String cssText = currentCss.getCssText();
                if (this.valueBuffer.length() > 0) {
                    this.valueBuffer.append(' ');
                }
                this.valueBuffer.append(cssText);
            }
        }

        public String getCssText() {
            return this.valueBuffer.toString();
        }

        protected boolean testColor(String subproperty) {
            if (35 == this.currentValue.getLexicalUnitType()) {
                return this.getPropertyDatabase().isIdentifierValue(subproperty, this.currentValue.getStringValue());
            }
            if (27 == this.currentValue.getLexicalUnitType()) {
                return true;
            }
            return 36 == this.currentValue.getLexicalUnitType() && this.currentValue.getStringValue().charAt(0) == '#';
        }
    }

    public class StyleDeclarationDocumentHandler
    extends PropertyDocumentHandler {
        @Override
        public void startSelector(SelectorList selectors) throws CSSException {
            BaseCSSStyleDeclaration.this.parentRule.setSelectorList(selectors);
        }

        @Override
        public void endSelector(SelectorList selectors) throws CSSException {
        }
    }
}

