/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.j2d;

import info.informatica.doc.dom4j.DocumentFormatter;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.CSSStyleException;
import info.informatica.doc.style.css.j2d.Java2DStyleDatabase;
import info.informatica.doc.style.css.j2d.Java2DUserAgent;
import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.CSSInlineBox;
import info.informatica.doc.style.css.visual.box.RunInBox;
import info.informatica.doc.style.css.visual.container.CSSBlockBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSInlineBoxContainer;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;

public class Java2DRenderer {
    private CSSContainerBox rootBox;

    public void setDocument(XHTMLDocument xdoc) throws CSSStyleException {
        this.rootBox = new DocumentFormatter(new Java2DUserAgent()).formatDocument(xdoc);
    }

    public void paint(Graphics2D g2) {
        this.drawStaticBlockBox(g2, this.rootBox, 0.0f, 0.0f);
    }

    protected void drawStaticBlockBox(Graphics2D g2, CSSContainerBox box, float x, float initialY) {
        block5: {
            float y;
            CSSBoxContainer container;
            block4: {
                Java2DRenderer.configureGraphics(g2, box);
                g2.draw(new Rectangle2D.Double(x += box.getLeft(), initialY, box.getWidth(), box.getHeight()));
                System.err.println("y=" + initialY);
                container = box.asContainerBox();
                x += box.getMarginLeft();
                y = initialY + box.getMarginTop();
                if (!(container instanceof CSSBlockBoxContainer)) break block4;
                List<CSSContainerBox> blockBoxes = ((CSSBlockBoxContainer)container).getStaticallyPositioned();
                for (CSSContainerBox bbox : blockBoxes) {
                    this.drawStaticBlockBox(g2, bbox, x, y);
                    y += bbox.getHeight();
                }
                break block5;
            }
            if (!(container instanceof CSSInlineBoxContainer)) break block5;
            List<CSSBox> inBoxes = ((CSSInlineBoxContainer)container).getInlineBoxes();
            for (CSSBox b : inBoxes) {
                CSSInlineBox inBox;
                if (b instanceof CSSInlineBox) {
                    inBox = (CSSInlineBox)b;
                } else {
                    if (!((b = ((RunInBox)b).finalBox()) instanceof CSSInlineBox)) continue;
                    inBox = (CSSInlineBox)b;
                }
                x += this.drawInlineBox(g2, inBox, x, y);
            }
        }
    }

    protected float drawInlineBox(Graphics2D g2, CSSInlineBox box, float x, float y) {
        g2.setFont(Java2DRenderer.createFont(box.getComputedStyle()));
        String text = box.getText();
        g2.drawString(text, x += box.getMarginLeft(), y += box.getMarginTop());
        return box.textLengthToNaturalUnit(text.length());
    }

    public static Font createFont(CSS2ComputedProperties styledecl) {
        String fontweight;
        String fontfamily = styledecl.getFontFamily();
        int sz = styledecl.getFontSize();
        String stylename = styledecl.getPropertyValue("font-style");
        int style = 0;
        if (stylename.length() > 0 && (stylename = stylename.toLowerCase()).equals("italic")) {
            style = 2;
        }
        if ((fontweight = styledecl.getFontWeight()) != null && (fontweight = fontweight.toLowerCase()).equals("bold")) {
            style = style != 2 ? 1 : 0;
        }
        HashMap<TextAttribute, Constable> textAttrs = new HashMap<TextAttribute, Constable>();
        String decoration = styledecl.getPropertyValue("text-decoration");
        if (decoration.length() > 0) {
            if ((decoration = decoration.toLowerCase()).equals("underline")) {
                textAttrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            } else if (decoration.equals("line-through")) {
                textAttrs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
        }
        Font font = new Font(fontfamily, style, sz);
        return font.deriveFont(textAttrs);
    }

    public static void configureGraphics(Graphics2D g2, CSSContainerBox box) {
        g2.setColor(Java2DStyleDatabase.getAWTColor(box.getComputedStyle().getColor()));
        g2.setBackground(Java2DStyleDatabase.getAWTColor(box.getComputedStyle().getBackgroundColor()));
    }

    public float getWidth() {
        return this.rootBox.getWidth();
    }

    public float getHeight() {
        return this.rootBox.getHeight();
    }
}

