/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.property.CSSStringValue;
import info.informatica.doc.style.css.visual.NonStaticallyPositioned;
import info.informatica.doc.style.css.visual.box.BlockBox;
import info.informatica.doc.style.css.visual.container.CSSBoxContainer;
import org.w3c.dom.css.CSSPrimitiveValue;

public class AbsolutelyPositionedBox
extends BlockBox
implements NonStaticallyPositioned {
    private float left;
    private float marginRight;
    private float marginLeft;
    private float width;
    private float right;

    public AbsolutelyPositionedBox(CSS2ComputedProperties style) {
        super(style);
        this.computeDimension(0.0f, 0.0f);
    }

    @Override
    public void computeDimension() {
        CSSBoxContainer container = this.asContainerBox();
        this.computeDimension(container.getMinimumWidth(), container.getContentWidth());
    }

    public void computeDimension(float preferredMinimumWidth, float preferredWidth) {
        CSSPrimitiveValue cssLeft = this.getCSSValue("left");
        CSSPrimitiveValue cssMarginLeft = this.getCSSValue("margin-left");
        CSSPrimitiveValue cssWidth = this.getCSSValue("width");
        CSSPrimitiveValue cssMarginRight = this.getCSSValue("margin-right");
        CSSPrimitiveValue cssRight = this.getCSSValue("right");
        boolean autoLeft = cssLeft instanceof CSSStringValue;
        boolean autoMarginLeft = cssMarginLeft instanceof CSSStringValue;
        boolean autoWidth = cssWidth instanceof CSSStringValue;
        boolean autoMarginRight = cssMarginRight instanceof CSSStringValue;
        boolean autoRight = cssRight instanceof CSSStringValue;
        if (!autoLeft) {
            this.left = this.computeNumberOrZero(cssLeft);
        }
        this.marginLeft = this.computeNumberOrZero(cssMarginLeft);
        if (!autoWidth) {
            this.width = this.computeNumberOrZero(cssWidth);
        }
        this.marginRight = this.computeNumberOrZero(cssMarginRight);
        if (!autoRight) {
            this.right = this.computeNumberOrZero(cssRight);
        }
        if (autoLeft && autoWidth && autoRight) {
            this.computeLeftWidthRightAreAuto(preferredMinimumWidth, preferredWidth);
        } else if (!(autoLeft || autoWidth || autoRight)) {
            if (autoMarginLeft) {
                if (autoMarginRight) {
                    this.marginLeft = (this.getContainerWidth() - this.left - this.getBorderLeftWidth() - this.getPaddingLeft() - this.width - this.getPaddingRight() - this.getBorderRightWidth() - this.right - this.computeScrollbarWidth()) / 2.0f;
                    if (this.marginLeft < 0.0f) {
                        this.marginLeft = 0.0f;
                    }
                    this.marginRight = this.marginLeft;
                } else {
                    this.marginLeft = this.getContainerWidth() - this.left - this.getBorderLeftWidth() - this.getPaddingLeft() - this.width - this.getPaddingRight() - this.getBorderRightWidth() - this.marginRight - this.right - this.computeScrollbarWidth();
                }
            } else if (autoMarginRight) {
                this.marginRight = this.getContainerWidth() - this.left - this.marginLeft - this.getBorderLeftWidth() - this.getPaddingLeft() - this.width - this.getPaddingRight() - this.getBorderRightWidth() - this.right - this.computeScrollbarWidth();
            }
        } else if (autoLeft) {
            if (autoWidth) {
                this.width = this.getContainerWidth() - this.marginLeft - this.getBorderLeftWidth() - this.getPaddingLeft() - this.right - this.getPaddingRight() - this.getBorderRightWidth() - this.marginRight - this.computeScrollbarWidth();
                if (preferredWidth != 0.0f) {
                    this.width = this.shrinkToFit(preferredMinimumWidth, this.width, preferredWidth);
                }
            }
            this.left = this.getContainerWidth() - this.marginLeft - this.getBorderLeftWidth() - this.getPaddingLeft() - this.width - this.right - this.getPaddingRight() - this.getBorderRightWidth() - this.marginRight - this.computeScrollbarWidth();
        } else if (autoRight) {
            if (autoWidth) {
                this.width = this.getContainerWidth() - this.left - this.marginLeft - this.getBorderLeftWidth() - this.getPaddingLeft() - this.getPaddingRight() - this.getBorderRightWidth() - this.marginRight - this.computeScrollbarWidth();
                if (preferredWidth != 0.0f) {
                    this.width = this.shrinkToFit(preferredMinimumWidth, this.width, preferredWidth);
                }
            }
            this.right = this.getContainerWidth() - this.left - this.marginLeft - this.getBorderLeftWidth() - this.getPaddingLeft() - this.width - this.getPaddingRight() - this.getBorderRightWidth() - this.marginRight - this.computeScrollbarWidth();
        } else {
            this.width = this.getContainerWidth() - this.left - this.marginLeft - this.getBorderLeftWidth() - this.getPaddingLeft() - this.right - this.getPaddingRight() - this.getBorderRightWidth() - this.marginRight - this.computeScrollbarWidth();
        }
    }

    private void computeLeftWidthRightAreAuto(float preferredMinimumWidth, float preferredWidth) {
        String direction = this.getCSSValue("direction").getStringValue();
        if (direction.equals("ltr")) {
            this.left = 0.0f;
            this.width = this.getContainerWidth() - this.left - this.marginLeft - this.getBorderLeftWidth() - this.getPaddingLeft() - this.getPaddingRight() - this.getBorderRightWidth() - this.marginRight - this.computeScrollbarWidth();
            if (preferredWidth != 0.0f) {
                this.width = this.shrinkToFit(preferredMinimumWidth, this.width, preferredWidth);
            }
        } else {
            this.right = 0.0f;
            this.width = this.getContainerWidth() - this.marginLeft - this.getBorderLeftWidth() - this.getPaddingLeft() - this.right - this.getPaddingRight() - this.getBorderRightWidth() - this.marginRight - this.computeScrollbarWidth();
            if (preferredWidth != 0.0f) {
                this.width = this.shrinkToFit(preferredMinimumWidth, this.width, preferredWidth);
            }
        }
    }

    @Override
    public float getMarginRight() {
        return this.marginRight;
    }

    @Override
    public float getMarginLeft() {
        return this.marginLeft;
    }

    @Override
    public float getLeft() {
        return this.left;
    }

    @Override
    public float getRight() {
        return this.right;
    }

    @Override
    public float getWidth() {
        return this.width;
    }
}

