/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.CSSErrorHandler;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.property.CSSPercentageValue;
import info.informatica.doc.style.css.property.CSSStringValue;
import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.CSSPoint;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractCSSBox
implements CSSBox {
    private CSS2ComputedProperties style;
    private CSSContainerBox containingBlock = null;
    private CSSErrorHandler errorHandler = null;

    public AbstractCSSBox(CSS2ComputedProperties style) {
        this.style = style;
    }

    @Override
    public CSS2ComputedProperties getComputedStyle() {
        return this.style;
    }

    protected CSSPrimitiveValue getCSSValue(String property) {
        return (CSSPrimitiveValue)((ComputedCSSStyle)this.getComputedStyle()).getCSSValue(property);
    }

    @Override
    public CSSContainerBox getContainingBlock() {
        return this.containingBlock;
    }

    public void setContainingBlock(CSSContainerBox enclosingBlock) {
        this.containingBlock = enclosingBlock;
    }

    StyleDatabase getStyleDatabase() {
        return this.style.getStyleDatabase();
    }

    protected CSSErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(CSSErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public CSSBox getGeneratedSibling() {
        return null;
    }

    protected float computeNumberOrZero(String property) {
        return this.computeNumberOrZero(this.getCSSValue(property));
    }

    protected float computeNumberOrZero(CSSPrimitiveValue cssValue) {
        float value;
        if (cssValue.getPrimitiveType() == 2) {
            value = cssValue.getFloatValue((short)2);
            if (value != 0.0f) {
                value = this.getContainerWidth() * value / 100.0f;
            }
        } else {
            value = cssValue.getPrimitiveType() == 3 ? (float)this.getFontSize() * cssValue.getFloatValue((short)3) : (cssValue instanceof CSSNumberValue ? cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit()) : 0.0f);
        }
        return value;
    }

    protected abstract float getWidth();

    protected abstract float getHeight();

    protected boolean isWidthAuto() {
        CSSPrimitiveValue cssVal = this.getCSSValue("width");
        return cssVal instanceof CSSStringValue;
    }

    protected boolean isHeightAuto() {
        CSSPrimitiveValue cssVal = this.getCSSValue("height");
        return cssVal instanceof CSSStringValue;
    }

    protected float getContainerWidth() {
        CSSContainerBox container = this.getContainingBlock();
        float containerWidth = container != null ? container.getWidth() : this.getStyleDatabase().getDocumentWidth();
        return containerWidth;
    }

    protected boolean isContainerHeightAuto() {
        CSSContainerBox container = this.getContainingBlock();
        if (container != null) {
            CSSValue cssVal = container.getComputedStyle().getPropertyCSSValue("height");
            return cssVal instanceof CSSStringValue;
        }
        return false;
    }

    protected float shrinkToFit(float preferredMinimum, float available, float preferred) {
        float shrink = preferredMinimum >= available ? preferredMinimum : available;
        if (shrink > preferred) {
            shrink = preferred;
        }
        return shrink;
    }

    protected boolean overflowsWithScroll() {
        return this.getCSSValue("overflow").getStringValue().equals("scroll");
    }

    protected float textLengthToNaturalUnit(int length) {
        return this.getStyleDatabase().floatValueConversion(length * this.getStyleDatabase().getExSizeInPt(this.getFontFamily(), this.getFontSize()), (short)9);
    }

    @Override
    public float getLeft() {
        return this.computeNumberOrZero("left");
    }

    @Override
    public float getRight() {
        return this.computeNumberOrZero("right");
    }

    @Override
    public float getBorderTopWidth() {
        return this.computeBorderWidth("border-top-width");
    }

    @Override
    public float getBorderRightWidth() {
        return this.computeBorderWidth("border-right-width");
    }

    @Override
    public float getBorderBottomWidth() {
        return this.computeBorderWidth("border-bottom-width");
    }

    @Override
    public float getBorderLeftWidth() {
        return this.computeBorderWidth("border-left-width");
    }

    private float computeBorderWidth(String borderWidthProperty) {
        CSSPrimitiveValue width = this.getCSSValue(borderWidthProperty);
        if (width instanceof CSSStringValue) {
            return this.getStyleDatabase().getWidthSize(width.getStringValue());
        }
        if (width instanceof CSSNumberValue) {
            return width.getFloatValue(this.getStyleDatabase().getNaturalUnit());
        }
        return 0.0f;
    }

    @Override
    public float getMarginTop() {
        return this.computeNumberOrZero("margin-top");
    }

    @Override
    public float getMarginBottom() {
        return this.computeNumberOrZero("margin-bottom");
    }

    @Override
    public float getMarginRight() {
        return this.computeNumberOrZero("margin-right");
    }

    @Override
    public float getMarginLeft() {
        return this.computeNumberOrZero("margin-left");
    }

    @Override
    public float getPaddingTop() {
        return this.getPaddingSubproperty("padding-top");
    }

    @Override
    public float getPaddingRight() {
        return this.getPaddingSubproperty("padding-right");
    }

    @Override
    public float getPaddingBottom() {
        return this.getPaddingSubproperty("padding-bottom");
    }

    @Override
    public float getPaddingLeft() {
        return this.getPaddingSubproperty("padding-left");
    }

    protected float getPaddingSubproperty(String subpropertyName) {
        float padding;
        CSSPrimitiveValue cssval = this.getCSSValue(subpropertyName);
        if (cssval.getPrimitiveType() == 2) {
            CSS2ComputedProperties pStyledecl;
            CSS2ComputedProperties styledecl = this.getComputedStyle();
            String display = styledecl.getPropertyValue("display");
            if ("table-cell".equals(display)) {
                pStyledecl = styledecl;
                do {
                    if ((pStyledecl = pStyledecl.getParentComputedStyle()) == null) {
                        if (this.errorHandler != null) {
                            this.errorHandler.error("Unable to find table ancestor for " + styledecl.getPeerXPath(), subpropertyName, cssval);
                        }
                        padding = 0.0f;
                        continue;
                    }
                    display = pStyledecl.getPropertyValue("display");
                } while ("table".equals(display));
            } else {
                pStyledecl = styledecl;
                do {
                    if ((pStyledecl = pStyledecl.getParentComputedStyle()) == null) {
                        if (this.errorHandler != null) {
                            this.errorHandler.error("Unable to find enclosing block for " + styledecl.getPeerXPath(), subpropertyName, cssval);
                        }
                        padding = 0.0f;
                        continue;
                    }
                    display = pStyledecl.getPropertyValue("display");
                } while ("block".equals(display));
            }
            CSSValue cssWidth = styledecl.getPropertyCSSValue("width");
            if (cssWidth instanceof CSSNumberValue) {
                padding = cssval.getFloatValue((short)2);
                if (padding != 0.0f) {
                    float parentWidth = ((CSSNumberValue)cssWidth).getFloatValue(this.getStyleDatabase().getNaturalUnit());
                    padding = parentWidth * padding / 100.0f;
                } else {
                    padding = 0.0f;
                }
            } else {
                if (this.errorHandler != null) {
                    this.errorHandler.error("Got percent of an auto value at " + styledecl.getPeerXPath(), subpropertyName, cssval);
                }
                padding = 0.0f;
            }
        } else {
            padding = cssval.getPrimitiveType() == 3 ? (float)this.getFontSize() * cssval.getFloatValue((short)3) : (cssval instanceof CSSNumberValue ? cssval.getFloatValue(this.getStyleDatabase().getNaturalUnit()) : 0.0f);
        }
        return padding;
    }

    public String getFontFamily() {
        return this.getComputedStyle().getFontFamily();
    }

    public String getFontWeight() {
        return this.getComputedStyle().getFontWeight();
    }

    public int getFontSize() {
        return this.getComputedStyle().getFontSize();
    }

    public float getLineHeight() {
        return this.getLineHeight((float)this.getFontSize() * 1.16f);
    }

    public float getLineHeight(float defval) {
        float height;
        CSSPrimitiveValue cssval = this.getCSSValue("line-height");
        if (cssval == null) {
            return defval;
        }
        if (cssval.getPrimitiveType() == 2) {
            height = (float)this.getFontSize() * cssval.getFloatValue((short)2) / 100.0f;
        } else if (cssval.getPrimitiveType() == 3) {
            height = (float)this.getFontSize() * cssval.getFloatValue((short)3);
        } else if (cssval.getPrimitiveType() == 21 || cssval.getPrimitiveType() == 19) {
            if (!"normal".equals(cssval.getStringValue()) && this.errorHandler != null) {
                this.errorHandler.error("Expected 'normal', found " + cssval.getStringValue());
            }
            height = defval;
        } else if (cssval instanceof CSSNumberValue) {
            height = cssval.getFloatValue(this.getStyleDatabase().getNaturalUnit());
        } else {
            if (this.errorHandler != null) {
                this.errorHandler.error("Expected number or identifier, found " + cssval.getCssText());
            }
            height = defval;
        }
        return height;
    }

    public float getLeading() {
        return this.getLeading((float)this.getFontSize() * 0.16f);
    }

    public float getLeading(float defval) {
        float leading;
        CSSPrimitiveValue cssval = this.getCSSValue("line-height");
        if (cssval == null) {
            return defval;
        }
        if (cssval.getPrimitiveType() == 2) {
            leading = (float)this.getFontSize() * (cssval.getFloatValue((short)2) - 100.0f) / 100.0f;
        } else if (cssval.getPrimitiveType() == 3) {
            leading = (float)this.getFontSize() * (cssval.getFloatValue((short)3) - 1.0f);
        } else if (cssval.getPrimitiveType() == 21 || cssval.getPrimitiveType() == 19) {
            if (!"normal".equals(cssval.getStringValue()) && this.errorHandler != null) {
                this.errorHandler.error("Expected 'normal', found " + cssval.getStringValue());
            }
            leading = defval;
        } else if (cssval instanceof CSSNumberValue) {
            leading = cssval.getFloatValue(this.getStyleDatabase().getNaturalUnit()) - (float)this.getFontSize();
        } else {
            if (this.errorHandler != null) {
                this.errorHandler.error("Expected number or identifier, found " + cssval.getCssText());
            }
            leading = defval;
        }
        return leading;
    }

    public CSSValue getLineHeightCSSValue() {
        return this.getCSSValue("line-height");
    }

    @Override
    public CSSPrimitiveValue getBorderTopColor() {
        return this.getCSSValue("border-top-color");
    }

    @Override
    public CSSPrimitiveValue getBorderRightColor() {
        return this.getCSSValue("border-right-color");
    }

    @Override
    public CSSPrimitiveValue getBorderBottomColor() {
        return this.getCSSValue("border-bottom-color");
    }

    @Override
    public CSSPrimitiveValue getBorderLeftColor() {
        return this.getCSSValue("border-left-color");
    }

    @Override
    public CSSPoint getBackgroundPosition() {
        CSSPrimitiveValue cssVal = this.getCSSValue("background-position");
        CSSPoint point = new CSSPoint();
        if (cssVal instanceof CSSNumberValue) {
            float fval = this.getComputedStyle().computeFloatValue((CSSNumberValue)cssVal);
            if (cssVal instanceof CSSPercentageValue && fval != 0.0f) {
                point.setLeft(fval * this.getWidth() * 0.01f);
            } else {
                point.setLeft(fval);
            }
            cssVal = ((CSSNumberValue)cssVal).nextPrimitiveValue();
            if (cssVal == null) {
                point.setTop(this.getWidth() * 0.5f);
            } else if (cssVal instanceof CSSNumberValue) {
                fval = this.getComputedStyle().computeFloatValue((CSSNumberValue)cssVal);
                if (cssVal instanceof CSSPercentageValue && fval != 0.0f) {
                    point.setTop(fval * this.getHeight() * 0.01f);
                } else {
                    point.setTop(fval);
                }
            } else if (cssVal instanceof CSSStringValue) {
                String ident = cssVal.getStringValue();
                if (ident.equals("top")) {
                    point.setTop(this.getHeight());
                } else if (ident.equals("bottom")) {
                    point.setTop(0.0f);
                } else {
                    point.setTop(this.getHeight() * 0.5f);
                }
            }
        } else if (cssVal instanceof CSSStringValue) {
            String ident = cssVal.getStringValue();
            if ((cssVal = ((CSSStringValue)cssVal).nextPrimitiveValue()) == null) {
                point.setTop(this.getWidth() * 0.5f);
            } else if (cssVal instanceof CSSNumberValue) {
                if (ident.equals("left")) {
                    point.setLeft(0.0f);
                } else if (ident.equals("right")) {
                    point.setLeft(this.getWidth());
                } else {
                    point.setLeft(this.getWidth() * 0.5f);
                }
                float fval = this.getComputedStyle().computeFloatValue((CSSNumberValue)cssVal);
                if (cssVal instanceof CSSPercentageValue && fval != 0.0f) {
                    point.setTop(fval * this.getHeight() * 0.01f);
                } else {
                    point.setTop(fval);
                }
            } else if (cssVal instanceof CSSStringValue) {
                String ident2 = cssVal.getStringValue();
                if (ident.equals("left") || ident2.equals("left")) {
                    point.setLeft(0.0f);
                } else if (ident.equals("right") || ident2.equals("right")) {
                    point.setLeft(this.getWidth());
                } else {
                    point.setLeft(this.getWidth() * 0.5f);
                }
                if (ident.equals("top") || ident2.equals("top")) {
                    point.setLeft(0.0f);
                } else if (ident.equals("bottom") || ident2.equals("bottom")) {
                    point.setLeft(this.getHeight());
                } else {
                    point.setTop(this.getHeight() * 0.5f);
                }
            }
        }
        return point;
    }
}

