/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.box.AbstractInlineBox;
import info.informatica.doc.style.css.visual.box.TableRowContainer;
import info.informatica.doc.style.css.visual.container.CSSBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSTableRowContainer;
import org.w3c.dom.css.CSSPrimitiveValue;

public class InlineTable
extends AbstractInlineBox
implements CSSContainerBox {
    private final float UNSET_FLOAT_VALUE = Float.MIN_VALUE;
    private float boxHeight = Float.MIN_VALUE;
    private CSSTableRowContainer rowContainer;

    public InlineTable(CSS2ComputedProperties style) {
        super(style);
    }

    @Override
    public void setBoxContainer(CSSBoxContainer rowContainer) {
        this.rowContainer = (CSSTableRowContainer)rowContainer;
    }

    @Override
    public CSSBoxContainer asContainerBox() {
        return this.rowContainer;
    }

    @Override
    public float getWidth() {
        CSSPrimitiveValue cssValue = this.getCSSValue("width");
        short primiType = cssValue.getPrimitiveType();
        float boxWidth = primiType == this.getStyleDatabase().getNaturalUnit() ? cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit()) : (primiType == 2 ? this.getContainerWidth() * cssValue.getFloatValue((short)2) / 100.0f : (cssValue instanceof CSSNumberValue ? cssValue.getFloatValue(primiType) : this.getContentWidth()));
        return boxWidth;
    }

    @Override
    public float getContentWidth() {
        return ((TableRowContainer)this.rowContainer).getContentWidth();
    }

    public float getMinimumWidth() {
        return ((TableRowContainer)this.rowContainer).getMinimumWidth();
    }

    @Override
    public float getHeight() {
        if (this.boxHeight == Float.MIN_VALUE) {
            CSSPrimitiveValue cssValue = this.getCSSValue("height");
            short primiType = cssValue.getPrimitiveType();
            if (primiType == this.getStyleDatabase().getNaturalUnit()) {
                this.boxHeight = cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit());
            } else if (primiType == 2) {
                if (this.isContainerHeightAuto()) {
                    this.boxHeight = this.computeHeight(this.getWidth());
                } else {
                    CSSContainerBox container = this.getContainingBlock();
                    float containerHeight = container != null ? container.getHeight() : this.getStyleDatabase().getDocumentHeight();
                    this.boxHeight = containerHeight * cssValue.getFloatValue((short)2) / 100.0f;
                }
            } else {
                this.boxHeight = cssValue instanceof CSSNumberValue ? cssValue.getFloatValue(primiType) : this.computeHeight(this.getWidth());
            }
        }
        return this.boxHeight;
    }

    @Override
    public float computeHeight(float width) {
        return ((TableRowContainer)this.rowContainer).computeAutoHeight(width);
    }
}

