/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.agent;

import info.informatica.doc.agent.DownloadListener;
import info.informatica.doc.agent.IllegalOriginException;
import info.informatica.doc.style.css.CSSDocument;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class ResourceDownloader<C>
extends Thread {
    private URL url;
    protected C nativeContent = null;
    protected List<DownloadListener<C>> listeners = new LinkedList<DownloadListener<C>>();
    private String contentType = null;
    private boolean done = false;

    protected ResourceDownloader(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public void addListener(DownloadListener<C> listener) {
        if (this.done) {
            if (this.nativeContent == null) {
                listener.doFailedDownload();
            } else {
                listener.doContentDownloaded(this.nativeContent);
            }
        } else {
            this.listeners.add(listener);
        }
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void run() {
        try {
            InputStream is = this.openStream();
            if (is == null) {
                this.notifyFailure(new IOException("Cannot open URL " + this.getURL().toExternalForm()));
            }
            this.readContent(is);
            is.close();
            this.done = true;
            this.notifyDownload();
        }
        catch (IOException e) {
            this.notifyFailure(e);
        }
        this.listeners.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InputStream openStream() throws IOException {
        URLConnection con;
        CSSDocument doc = null;
        if (!this.listeners.isEmpty()) {
            int nl = this.listeners.size();
            int i = 0;
            while (i < nl) {
                doc = this.listeners.get(i).getDocument();
                if (doc != null) break;
                ++i;
            }
        }
        if (doc != null) {
            if (!doc.isSafeOrigin(this.getURL())) throw new IllegalOriginException("Illegal origin: " + this.getURL().toExternalForm());
            con = doc.openConnection(this.getURL());
        } else {
            con = this.getURL().openConnection();
        }
        this.contentType = con.getContentType();
        return con.getInputStream();
    }

    public String getContentType() {
        return this.contentType;
    }

    protected abstract void readContent(InputStream var1) throws IOException;

    protected void notifyDownload() {
        Iterator<DownloadListener<C>> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().doContentDownloaded(this.nativeContent);
        }
        this.nativeContent = null;
    }

    protected void notifyFailure(Exception e) {
        System.err.println("Failed downloader: " + e.getMessage());
        Iterator<DownloadListener<C>> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().doFailedDownload();
        }
    }

    public C getNativeContent() {
        return this.nativeContent;
    }
}

