/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.dom4j.BaseURLElement;
import info.informatica.doc.dom4j.XHTMLElement;
import org.dom4j.Node;
import org.dom4j.QName;
import org.w3c.dom.Element;
import org.w3c.dom.stylesheets.LinkStyle;

class HeadElement
extends XHTMLElement {
    private static final long serialVersionUID = 2L;

    HeadElement(String name) {
        super(name);
    }

    HeadElement(QName qname) {
        super(qname);
    }

    HeadElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    protected void childAdded(Node node) {
        super.childAdded(node);
        if (node instanceof LinkStyle) {
            this.getOwnerDocument().onEmbeddedStyleAdd((LinkStyle)node);
        } else if (node instanceof BaseURLElement) {
            this.getOwnerDocument().setBaseURL(((BaseURLElement)node).base);
            ((BaseURLElement)node).base = null;
        } else if ("meta".equals(node.getName())) {
            Element elt = (Element)node;
            String name = elt.getAttribute("http-equiv");
            if ("".equals(name)) {
                name = elt.getAttribute("name");
            }
            this.getOwnerDocument().onMetaAdded(name, elt.getAttribute("content"));
        }
    }

    protected void childRemoved(Node node) {
        if (node instanceof LinkStyle) {
            this.getOwnerDocument().onEmbeddedStyleRemove((LinkStyle)node);
        } else if ("meta".equals(node.getName())) {
            Element elt = (Element)node;
            String name = elt.getAttribute("http-equiv");
            if ("".equals(name)) {
                name = elt.getAttribute("name");
            }
            this.getOwnerDocument().onMetaRemoved(name, elt.getAttribute("content"));
        }
        super.childRemoved(node);
    }
}

