/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.agent.CSSCanvas;
import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.dom4j.DOM4JCSSStyleDeclaration;
import info.informatica.doc.dom4j.DOM4JCSSStyleSheet;
import info.informatica.doc.dom4j.DOM4JDocumentCSSStyleSheet;
import info.informatica.doc.dom4j.LinkElement;
import info.informatica.doc.dom4j.StyleElement;
import info.informatica.doc.dom4j.XHTMLDocumentFactory;
import info.informatica.doc.style.css.CSSDocument;
import info.informatica.doc.style.css.CSSMediaException;
import info.informatica.doc.style.css.CSSRuleListener;
import info.informatica.doc.style.css.DocumentCSSStyleSheet;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.dom.AbstractCSSRule;
import info.informatica.doc.style.css.dom.AbstractCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.AbstractCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.DOMCSSFontFaceRule;
import info.informatica.doc.style.css.dom.DOMCSSMediaRule;
import info.informatica.doc.style.css.dom.DOMCSSPageRule;
import info.informatica.doc.style.css.dom.DOMMediaList;
import info.informatica.doc.style.css.dom.DOMStyleSheetList;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class XHTMLDocument
extends DOMDocument
implements CSSDocument,
CSSRuleListener {
    public static final String XHTML_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    private static final long serialVersionUID = 4L;
    private DOM4JDocumentCSSStyleSheet defStyleSheet = null;
    private AbstractCSSStyleDeclaration userImportantStyle = null;
    private DOM4JDocumentCSSStyleSheet mergedStyleSheet = null;
    private int styleCacheSerial = Integer.MIN_VALUE;
    private URL baseURL = null;
    Set<LinkElement> linkedStyle = new LinkedHashSet<LinkElement>(4);
    Set<StyleElement> embeddedStyle = new LinkedHashSet<StyleElement>(3);
    private MyDOMStyleSheetList sheets = new MyDOMStyleSheetList(7);
    private String metaDefaultStyleSet = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);
    static Logger log = LoggerFactory.getLogger((String)XHTMLDocument.class.getName());

    protected XHTMLDocument() {
    }

    protected XHTMLDocument(String name) {
        super(name);
    }

    protected XHTMLDocument(DOMElement rootElement) {
        super(rootElement);
    }

    protected XHTMLDocument(DOMDocumentType docType) {
        super(docType);
    }

    protected XHTMLDocument(DOMElement rootElement, DOMDocumentType docType) {
        super(rootElement, docType);
    }

    protected XHTMLDocument(String name, DOMElement rootElement, DOMDocumentType docType) {
        super(name, rootElement, docType);
    }

    protected String elementID(org.dom4j.Element element) {
        return element.attributeValue("id");
    }

    @Override
    public CSSDocument getOwnerDocument() {
        return null;
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.updateStyleLists();
        }
        return this.sheets;
    }

    protected void updateStyleLists() {
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            this.addLinkedSheet(links.next().getSheet());
        }
        Iterator<StyleElement> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            this.addLinkedSheet(embd.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else if (this.metaDefaultStyleSet.length() > 0) {
            this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
        } else {
            this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
        }
    }

    private void addLinkedSheet(StyleSheet linkedSheet) {
        if (linkedSheet != null) {
            this.sheets.add(linkedSheet);
        }
    }

    @Override
    public DOM4JDocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.mergedStyleSheet = this.targetMedium == null ? this.defStyleSheet.clone() : this.defStyleSheet.clone(this.targetMedium);
        this.mergedStyleSheet.setOwnerDocument(this);
        this.getStyleSheets();
        Iterator<StyleSheet> it = this.sheets.iterator();
        while (it.hasNext()) {
            this.getStyleSheet().addStyleSheet((AbstractCSSStyleSheet)it.next());
        }
    }

    public boolean addStyleSheet(InputSource cssSrc) throws DOMException, IOException, CSSException {
        String media = cssSrc.getMedia();
        if (media != null && !"all".equals(media)) {
            AbstractCSSStyleSheet sheet = (AbstractCSSStyleSheet)((XHTMLDocumentFactory)this.getDocumentFactory()).getCSSStyleSheetFactory().createStyleSheet(cssSrc.getTitle(), cssSrc.getMedia());
            ((DOM4JDocumentCSSStyleSheet)sheet).setOwnerDocument(this);
            boolean result = sheet.parseCSSStyleSheet(cssSrc);
            DOMCSSMediaRule mrule = this.getStyleSheet().createCSSMediaRule(DOMMediaList.create(media));
            CSSRuleArrayList otherRules = sheet.getCssRules();
            int orl = otherRules.getLength();
            int i = 0;
            while (i < orl) {
                AbstractCSSRule orule = (AbstractCSSRule)otherRules.item(i);
                orule.setParentRule(mrule);
                mrule.addRule(orule);
                ++i;
            }
            this.getStyleSheet().addRule(mrule);
            return result;
        }
        return this.getStyleSheet().parseCSSStyleSheet(cssSrc);
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.updateStyleLists();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        String selectedSetName = "";
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            DOM4JCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equals(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        return selectedSetName;
    }

    @Override
    public void setSelectedStyleSheetSet(String name) {
        if (name == null || name.length() > 0 && !this.getStyleSheetSets().contains(name)) {
            return;
        }
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            DOM4JCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0) continue;
            if (title.equals(name)) {
                sheet.setDisabled(false);
                this.lastStyleSheetSet = name;
                continue;
            }
            sheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        Iterator<LinkElement> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            DOM4JCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || !title.equals(name)) continue;
            sheet.setDisabled(false);
        }
    }

    void onEmbeddedStyleAdd(LinkStyle element) {
        if (element instanceof LinkElement) {
            this.linkedStyle.add((LinkElement)element);
        } else if (element instanceof StyleElement) {
            this.embeddedStyle.add((StyleElement)element);
        }
        this.onStyleModify();
    }

    void onEmbeddedStyleRemove(LinkStyle element) {
        String title;
        if (element instanceof LinkElement) {
            this.linkedStyle.remove(element);
        } else if (element instanceof StyleElement) {
            this.embeddedStyle.remove(element);
        }
        StyleSheet sheet = element.getSheet();
        if (sheet != null && (title = sheet.getTitle()) != null) {
            this.sheets.remove(title);
        }
        this.onStyleModify();
    }

    void onStyleModify() {
        if (this.mergedStyleSheet != null) {
            this.mergedStyleSheet = null;
            this.sheets.setNeedsUpdate(true);
            ++this.styleCacheSerial;
        } else if (this.sheets != null) {
            this.sheets.setNeedsUpdate(true);
        }
    }

    int getStyleCacheSerial() {
        return this.styleCacheSerial;
    }

    @Override
    public DocumentCSSStyleSheet getDefaultStyleSheet() {
        return this.defStyleSheet;
    }

    public void setDefaultStyleSheet(DOM4JDocumentCSSStyleSheet styleSheet) {
        this.defStyleSheet = styleSheet;
        this.onStyleModify();
    }

    protected void setUserImportantStyleDeclaration(AbstractCSSStyleDeclaration style) {
        this.userImportantStyle = style;
        this.onStyleModify();
    }

    @Override
    public AbstractCSSStyleDeclaration getUserImportantStyleDeclaration() {
        return this.userImportantStyle;
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        if (elt instanceof CSSStylableElement) {
            return ((CSSStylableElement)elt).getOverrideStyle(pseudoElt);
        }
        DOM4JCSSStyleDeclaration overrideStyle = new DOM4JCSSStyleDeclaration();
        overrideStyle.setPeerNode(this);
        return overrideStyle;
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        StyleDatabase sdb = null;
        if (this.targetMedium != null) {
            sdb = ((XHTMLDocumentFactory)this.getDocumentFactory()).getDeviceFactory().getStyleDatabase(this.targetMedium);
        }
        if (sdb == null) {
            sdb = ((XHTMLDocumentFactory)this.getDocumentFactory()).getDeviceFactory().getStyleDatabase();
        }
        return sdb;
    }

    @Override
    public void setTargetMedium(String medium) throws CSSMediaException {
        this.targetMedium = "all".equals(medium = medium.intern()) ? null : medium;
        this.onStyleModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        CSSCanvas canvas = ((XHTMLDocumentFactory)this.getDocumentFactory()).getDeviceFactory().createCanvas(this.targetMedium, this);
        this.canvases.put(this.targetMedium, canvas);
        return canvas;
    }

    @Override
    public void onFontFaceRule(DOMCSSFontFaceRule rule) {
        for (CSSCanvas canvas : this.canvases.values()) {
            if (canvas == null) continue;
            canvas.loadFontFace(rule);
        }
    }

    @Override
    public void onPageRule(DOMCSSPageRule rule) {
    }

    public void onMetaAdded(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = attribute;
        }
    }

    public void onMetaRemoved(String name, String attribute) {
        if ("Default-Style".equals(name)) {
            this.metaDefaultStyleSet = "";
        }
    }

    @Override
    public URL getBaseURL() {
        return this.baseURL;
    }

    @Override
    public String getBaseURI() {
        return this.getBaseURL().toExternalForm();
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    @Override
    public URL getURL(String uri) throws MalformedURLException {
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL url = uri.indexOf("://") < 0 ? new URL(this.getBaseURL(), uri) : new URL(uri);
        return url;
    }

    @Override
    public boolean isSafeOrigin(URL linkedURL) {
        URL base = this.getBaseURL();
        String docHost = base.getHost();
        int docPort = base.getPort();
        if (docPort == -1) {
            docPort = base.getDefaultPort();
        }
        String linkedHost = linkedURL.getHost();
        int linkedPort = linkedURL.getPort();
        if (linkedPort == -1) {
            linkedPort = linkedURL.getDefaultPort();
        }
        return (docHost.equalsIgnoreCase(linkedHost) || linkedHost.endsWith(docHost)) && docPort == linkedPort;
    }

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        return url.openConnection();
    }

    public InputStream openStream(String uri) throws IOException {
        return this.openConnection(this.getURL(uri)).getInputStream();
    }

    class MyDOMStyleSheetList
    extends DOMStyleSheetList {
        protected MyDOMStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected Iterator<StyleSheet> iterator() {
            return super.iterator();
        }

        @Override
        protected void clear() {
            super.clear();
        }

        @Override
        protected boolean needsUpdate() {
            return super.needsUpdate();
        }

        @Override
        protected void setNeedsUpdate(boolean needsUpdate) {
            super.setNeedsUpdate(needsUpdate);
        }

        @Override
        protected void update() {
            super.update();
            XHTMLDocument.this.updateStyleLists();
        }
    }
}

