/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css;

import info.informatica.doc.style.css.CSSElement;
import info.informatica.doc.style.css.DocumentCSSStyleSheet;
import info.informatica.doc.style.css.ErrorHandler;
import info.informatica.doc.style.css.SheetErrorHandler;
import info.informatica.doc.style.css.StyleDeclarationErrorHandler;
import info.informatica.doc.style.css.dom.CSSStyleDeclarationRule;
import info.informatica.doc.style.css.dom.DOMMediaList;
import info.informatica.doc.style.css.dom.DefaultSheetErrorHandler;
import info.informatica.doc.style.css.dom.DefaultStyleDeclarationErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;

public abstract class CSSStyleSheetFactory {
    private static final String XHTML11_DEFAULT_SHEET = "html.css";
    private ClassLoader classLoader = null;

    protected CSSStyleSheetFactory() {
    }

    public abstract DocumentCSSStyleSheet createDocumentStyleSheet();

    public CSSStyleSheet createStyleSheet(String title, String media) {
        DOMMediaList mediaList = media == null || media.equals("all") ? DOMMediaList.create() : DOMMediaList.create(media);
        return this.createLinkedStyleSheet(null, title, mediaList);
    }

    public abstract CSSStyleSheet createRuleStyleSheet(CSSRule var1, String var2, DOMMediaList var3);

    public abstract CSSStyleSheet createLinkedStyleSheet(CSSElement var1, String var2, DOMMediaList var3);

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public DocumentCSSStyleSheet loadXHTMLDefaultSheet() throws IOException {
        return this.loadDefaultSheet(this.loadCSSfromClasspath(XHTML11_DEFAULT_SHEET));
    }

    private DocumentCSSStyleSheet loadDefaultSheet(InputStream is) throws IOException {
        DocumentCSSStyleSheet cssSheet;
        Reader re = null;
        try {
            re = new InputStreamReader(is);
            InputSource source = new InputSource(re);
            cssSheet = this.createDocumentStyleSheet();
            cssSheet.parseCSSStyleSheet(source);
        }
        finally {
            try {
                re.close();
            }
            catch (IOException iOException) {}
        }
        return cssSheet;
    }

    private InputStream loadCSSfromClasspath(final String cssFilename) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                if (CSSStyleSheetFactory.this.classLoader != null) {
                    return CSSStyleSheetFactory.this.classLoader.getResourceAsStream(CSSStyleSheetFactory.resourcePath(CSSStyleSheetFactory.class.getPackage().getName(), cssFilename));
                }
                return this.getClass().getResourceAsStream(cssFilename);
            }
        });
    }

    private static String resourcePath(String clase, String filename) {
        return String.valueOf('/') + clase.replace('.', '/') + '/' + filename;
    }

    public StyleDeclarationErrorHandler createStyleDeclarationErrorHandler(CSSStyleDeclarationRule rule) {
        return new DefaultStyleDeclarationErrorHandler();
    }

    public SheetErrorHandler createSheetErrorHandler() {
        return new DefaultSheetErrorHandler();
    }

    public abstract ErrorHandler getErrorHandler();
}

