/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css;

import info.informatica.doc.DocumentException;
import info.informatica.doc.agent.AbstractUserAgent;
import info.informatica.doc.agent.DeviceFactory;
import info.informatica.doc.agent.UserAgent;
import info.informatica.doc.style.css.CSSDocument;
import info.informatica.doc.style.css.CSSElement;
import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.ErrorHandler;
import info.informatica.doc.style.css.LogErrorHandler;
import info.informatica.doc.style.css.StylableDocumentWrapper;
import info.informatica.doc.style.css.dom.AbstractCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.AbstractCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.DOMCSSStyleSheet;
import info.informatica.doc.style.css.dom.DOMDocumentCSSStyleSheet;
import info.informatica.doc.style.css.dom.DOMMediaList;
import info.informatica.doc.xml.dtd.DefaultEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleRule;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class DOMCSSStyleSheetFactory
extends CSSStyleSheetFactory {
    private DOMDocumentCSSStyleSheet defStyleSheet = null;
    private AbstractCSSStyleDeclaration userImportantStyle = null;
    private AbstractCSSStyleDeclaration userNormalStyle = null;
    private DOMDocumentCSSStyleSheet uaStyleSheet = null;
    private EntityResolver resolver = new DefaultEntityResolver();
    private MyUserAgent myUserAgent = null;
    private DeviceFactory deviceFactory;
    private ErrorHandler errorHandler = new LogErrorHandler();

    @Override
    public DOMDocumentCSSStyleSheet createDocumentStyleSheet() {
        return new DOMDocumentCSSStyleSheet(this);
    }

    @Override
    public DOMCSSStyleSheet createRuleStyleSheet(CSSRule ownerRule, String title, DOMMediaList mediaList) {
        return new DOMCSSStyleSheet(this, title, null, mediaList, ownerRule);
    }

    @Override
    public DOMCSSStyleSheet createLinkedStyleSheet(CSSElement ownerNode, String title, DOMMediaList mediaList) {
        Node titleattr;
        if (title == null && ownerNode != null && (titleattr = ownerNode.getAttributes().getNamedItem("title")) != null) {
            title = titleattr.getNodeValue();
        }
        return new DOMCSSStyleSheet(this, title, ownerNode, mediaList, null);
    }

    public DOMDocumentCSSStyleSheet getUserAgentStyleSheet() {
        if (this.uaStyleSheet == null) {
            this.uaStyleSheet = this.createDocumentStyleSheet();
        }
        return this.uaStyleSheet;
    }

    protected DOMDocumentCSSStyleSheet getDefaultStyleSheet() {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        return this.defStyleSheet;
    }

    public void setUserAgentStyleSheet(DOMDocumentCSSStyleSheet styleSheet) {
        this.uaStyleSheet = styleSheet;
        this.defStyleSheet = null;
    }

    public void setUserStyleSheet(AbstractCSSStyleSheet styleSheet) {
        if (styleSheet != null) {
            this.userImportantStyle = styleSheet.createCSSStyleDeclaration();
            this.userNormalStyle = styleSheet.createCSSStyleDeclaration();
            CSSRuleArrayList rules = styleSheet.getCssRules();
            int rl = rules.getLength();
            int i = 0;
            while (i < rl) {
                CSSRule r = rules.item(i);
                if (r.getType() == 1) {
                    AbstractCSSStyleDeclaration st = (AbstractCSSStyleDeclaration)((CSSStyleRule)r).getStyle();
                    st.prioritySplit(this.userImportantStyle, this.userNormalStyle);
                }
                ++i;
            }
        } else {
            this.userImportantStyle = null;
            this.userNormalStyle = null;
        }
    }

    protected AbstractCSSStyleDeclaration getUserImportantStyle() {
        return this.userImportantStyle;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet().clone();
        if (this.userNormalStyle != null) {
            this.defStyleSheet.addRule(this.userNormalStyle.getParentRule());
        }
    }

    public UserAgent getUserAgent() {
        if (this.myUserAgent == null) {
            this.myUserAgent = new MyUserAgent();
        }
        return this.myUserAgent;
    }

    public DeviceFactory getDeviceFactory() {
        return this.deviceFactory;
    }

    public void setDeviceFactory(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
    }

    public StylableDocumentWrapper createCSSDocument(Document document) {
        MyStylableDocumentWrapper mydoc = new MyStylableDocumentWrapper(document);
        mydoc.setDefaultStyleSheet(this.getDefaultStyleSheet());
        mydoc.setUserImportantStyleDeclaration(this.getUserImportantStyle());
        return mydoc;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    private class MyStylableDocumentWrapper
    extends StylableDocumentWrapper {
        private long loadingTime;

        public MyStylableDocumentWrapper(Document document) {
            super(document);
        }

        @Override
        protected DOMCSSStyleSheetFactory getCSSStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return ((MyUserAgent)DOMCSSStyleSheetFactory.this.getUserAgent()).openConnection(url, this.loadingTime);
        }

        public void setLoadingTime(long time) {
            this.loadingTime = time;
        }
    }

    private class MyUserAgent
    extends AbstractUserAgent {
        private MyUserAgent() {
        }

        @Override
        public CSSDocument readURL(URL url) throws IOException, DocumentException {
            DocumentBuilder docb;
            DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
            try {
                docb = dbFac.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new DocumentException("Error creating a document builder", e);
            }
            docb.setEntityResolver(DOMCSSStyleSheetFactory.this.resolver);
            long time = System.currentTimeMillis();
            URLConnection con = this.openConnection(url, time);
            String conType = con.getContentType();
            InputStream is = null;
            Document xdoc = null;
            try {
                try {
                    PushbackReader re;
                    int iread;
                    int idx;
                    is = con.getInputStream();
                    String charset = null;
                    if (conType == null) {
                        conType = URLConnection.guessContentTypeFromStream(is);
                    }
                    if (conType != null && (idx = conType.indexOf("charset=")) >= 0) {
                        charset = conType.substring(idx + 8);
                    }
                    if ((iread = (re = charset != null ? new PushbackReader(new InputStreamReader(is, charset), 1) : new PushbackReader(new InputStreamReader(is, "utf-8"), 1)).read()) != -1 && iread == 0xEFBBBF) {
                        charset = "utf-8";
                    } else {
                        re.unread(iread);
                    }
                    xdoc = docb.parse(is);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (SAXException e) {
                    throw new DocumentException("Error parsing XML document at " + url.toExternalForm(), e);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            xdoc.getDocumentElement().normalize();
            xdoc.setDocumentURI(url.toExternalForm());
            MyStylableDocumentWrapper wrapper = (MyStylableDocumentWrapper)DOMCSSStyleSheetFactory.this.createCSSDocument(xdoc);
            wrapper.setLoadingTime(time);
            String defStyle = con.getHeaderField("Default-Style");
            NodeList list = xdoc.getElementsByTagName("meta");
            int listL = list.getLength();
            int i = listL - 1;
            while (i >= 0) {
                String metaDefStyle;
                if ("Default-Style".equalsIgnoreCase(((Element)list.item(i)).getAttribute("http-equiv")) && (metaDefStyle = ((Element)list.item(i)).getAttribute("content")).length() == 0) {
                    defStyle = metaDefStyle;
                }
                --i;
            }
            if (defStyle != null) {
                wrapper.setSelectedStyleSheetSet(defStyle);
            }
            if (con instanceof HttpURLConnection) {
                HttpURLConnection hcon = (HttpURLConnection)con;
                this.readCookies(hcon, time);
                hcon.disconnect();
            }
            return wrapper;
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            DOMCSSStyleSheetFactory.this.resolver = resolver;
        }

        @Override
        public URLConnection openConnection(URL url, long creationDate) throws IOException {
            return super.openConnection(url, creationDate);
        }
    }
}

