/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.AbstractStyleDatabase;
import info.informatica.doc.style.css.SACParserFactory;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.StyleDeclarationErrorHandler;
import info.informatica.doc.style.css.dom.AbstractCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.CSSShorthandValue;
import info.informatica.doc.style.css.dom.CSSStyleDeclarationRule;
import info.informatica.doc.style.css.dom.PropertyDocumentHandler;
import info.informatica.doc.style.css.property.AbstractCSSPrimitiveValue;
import info.informatica.doc.style.css.property.AbstractCSSValue;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.property.CSSPropertyValueException;
import info.informatica.doc.style.css.property.CSSStringValue;
import info.informatica.doc.style.css.property.DOMCSSValueList;
import info.informatica.doc.style.css.property.ExtendedCSSValue;
import info.informatica.doc.style.css.property.PropertyDatabase;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSS2Properties;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class BaseCSSStyleDeclaration
extends AbstractCSSStyleDeclaration
implements CSS2Properties,
Cloneable {
    private CSSStyleDeclarationRule parentRule;
    private HashMap<String, ExtendedCSSValue> propValue = null;
    private ArrayList<String> propertyList = null;
    private ArrayList<String> priorities = null;
    private LinkedList<String> shorthandList = null;
    private StyleDatabase styleDb = null;

    protected BaseCSSStyleDeclaration(CSSStyleDeclarationRule parentRule) {
        this.parentRule = parentRule;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
        this.shorthandList = new LinkedList();
    }

    public BaseCSSStyleDeclaration() {
        this.parentRule = null;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
        this.shorthandList = new LinkedList();
    }

    protected BaseCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
        this.parentRule = copiedObject.getParentRule();
        this.priorities = (ArrayList)copiedObject.priorities.clone();
        this.propertyList = (ArrayList)copiedObject.propertyList.clone();
        this.propValue = (HashMap)copiedObject.propValue.clone();
        this.shorthandList = (LinkedList)copiedObject.shorthandList.clone();
    }

    @Override
    public String getMinifiedCssText() {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        LinkedList<String> unusedShorthands = new LinkedList<String>(this.shorthandList);
        int sz = this.propertyList.size();
        StringBuilder sb = new StringBuilder(50 + sz * 10);
        int i = 0;
        while (i < sz) {
            String ptyname = this.propertyList.get(i);
            CSSValue cssVal = this.propValue.get(ptyname);
            if (cssVal instanceof AbstractCSSPrimitiveValue && ((AbstractCSSPrimitiveValue)cssVal).isSubproperty()) {
                Iterator it = unusedShorthands.iterator();
                while (it.hasNext()) {
                    String sh = (String)it.next();
                    if (!pdb.isShorthandSubpropertyOf(sh, ptyname)) continue;
                    it.remove();
                    CSSShorthandValue shval = (CSSShorthandValue)this.propValue.get(sh);
                    sb.append(sh).append(':').append(shval.getCssText());
                    if (shval.isImportant()) {
                        sb.append("!important");
                    }
                    sb.append(';');
                }
            } else {
                String prio = this.priorities.get(i);
                sb.append(ptyname).append(':').append(this.propValue.get(ptyname).getMinifiedCssText(ptyname).trim());
                if (prio != null && "important".equals(prio)) {
                    sb.append("!important");
                }
                sb.append(';');
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getCssText() {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        LinkedList<String> unusedShorthands = new LinkedList<String>(this.shorthandList);
        int sz = this.propertyList.size();
        StringBuilder sb = new StringBuilder(50 + sz * 10);
        int i = 0;
        while (i < sz) {
            String ptyname = this.propertyList.get(i);
            CSSValue cssVal = this.propValue.get(ptyname);
            if (cssVal instanceof AbstractCSSPrimitiveValue && ((AbstractCSSPrimitiveValue)cssVal).isSubproperty()) {
                Iterator it = unusedShorthands.iterator();
                while (it.hasNext()) {
                    String sh = (String)it.next();
                    if (!pdb.isShorthandSubpropertyOf(sh, ptyname)) continue;
                    it.remove();
                    CSSShorthandValue shval = (CSSShorthandValue)this.propValue.get(sh);
                    sb.append(sh).append(':').append(' ').append(shval.getCssText());
                    if (shval.isImportant()) {
                        sb.append(" ! important");
                    }
                    sb.append(';').append(' ');
                }
            } else {
                String prio = this.priorities.get(i);
                sb.append(ptyname).append(':').append(' ').append(this.propValue.get(ptyname).getCssText());
                if (prio != null && "important".equals(prio)) {
                    sb.append(" ! important");
                }
                sb.append(';').append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        StyleDeclarationErrorHandler eh;
        Parser parser = SACParserFactory.createSACParser();
        StyleDeclarationDocumentHandler handler = this.getStyleDeclarationDocumentHandler();
        CSSStyleDeclarationRule prule = this.getParentRule();
        if (prule != null && (eh = prule.getStyleDeclarationErrorHandler()) != null) {
            parser.setErrorHandler((ErrorHandler)handler);
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(cssText);
        source.setCharacterStream((Reader)re);
        this.clear();
        handler.setLexicalRuleListener(this);
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseStyleDeclaration(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(12, e.getMessage());
        }
    }

    @Override
    public String getPropertyValue(String propertyName) {
        ExtendedCSSValue value = this.getCSSValue(propertyName);
        if (value != null) {
            if (value instanceof CSSPrimitiveValue && ((CSSPrimitiveValue)((Object)value)).getPrimitiveType() == 19) {
                return ((CSSPrimitiveValue)((Object)value)).getStringValue();
            }
            return value.getCssText();
        }
        return "";
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        if (PropertyDatabase.getInstance().isShorthand(propertyName)) {
            return null;
        }
        return this.getCSSValue(propertyName);
    }

    protected ExtendedCSSValue getCSSValue(String propertyName) {
        return this.getDeclaredCSSValue(propertyName);
    }

    protected ExtendedCSSValue getDeclaredCSSValue(String propertyName) {
        return this.propValue.get(propertyName);
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx >= 0 && !((AbstractCSSValue)this.propValue.get(propertyName)).isSubproperty()) {
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            CSSValue oldvalue = this.propValue.remove(propertyName);
            PropertyDatabase pdb = PropertyDatabase.getInstance();
            if (!this.shorthandList.isEmpty() && pdb.isShorthandSubproperty(propertyName)) {
                String shorthand = propertyName;
                boolean hasShorthand = false;
                while (!(hasShorthand = this.shorthandList.contains(shorthand = pdb.getShorthand(shorthand))) && pdb.isShorthandSubproperty(shorthand)) {
                }
                if (hasShorthand) {
                    CSSShorthandValue shval = (CSSShorthandValue)this.propValue.get(shorthand);
                    this.setSubproperties(shorthand, shval.getLexicalUnit(), shval.isImportant() ? "important" : null);
                }
            }
            return oldvalue.getCssText();
        }
        if (this.shorthandList.contains(propertyName)) {
            String text = this.propValue.get(propertyName).getCssText();
            this.removeSubproperties(PropertyDatabase.getInstance(), propertyName);
            return text;
        }
        return "";
    }

    private void removeSubproperties(PropertyDatabase pdb, String shorthandName) {
        this.shorthandList.remove(shorthandName);
        String[] subp = pdb.getShorthandSubproperties(shorthandName);
        int i = 0;
        while (i < subp.length) {
            int idx = this.propertyList.indexOf(subp[i]);
            if (idx == -1) {
                this.removeSubproperties(pdb, subp[i]);
            } else if (((AbstractCSSValue)this.propValue.get(subp[i])).isSubproperty()) {
                this.propertyList.remove(idx);
                this.priorities.remove(idx);
                this.propValue.remove(subp[i]);
            }
            ++i;
        }
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx < 0) {
            if (this.shorthandList.contains(propertyName) && ((CSSShorthandValue)this.propValue.get(propertyName)).isImportant()) {
                return "important";
            }
            return "";
        }
        String prio = this.priorities.get(idx);
        if (prio != null) {
            return prio;
        }
        return "";
    }

    @Override
    public void setProperty(String propertyName, LexicalUnit value, String priority) throws DOMException {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        if (pdb.isShorthand(propertyName)) {
            boolean important = priority == "important";
            CSSShorthandValue shVal = (CSSShorthandValue)this.propValue.get(propertyName);
            if (shVal == null || important || !shVal.isImportant()) {
                if (!this.shorthandList.isEmpty()) {
                    if (this.shorthandList.contains(propertyName)) {
                        this.shorthandList.remove(propertyName);
                    }
                    Iterator it = this.shorthandList.iterator();
                    while (it.hasNext()) {
                        String sh = (String)it.next();
                        if (pdb.isShorthandSubpropertyOf(propertyName, sh)) {
                            if (!important && ((CSSShorthandValue)this.propValue.get(sh)).isImportant()) continue;
                            it.remove();
                            this.propValue.remove(sh);
                            continue;
                        }
                        if (!pdb.isShorthandSubpropertyOf(sh, propertyName) || important || !((CSSShorthandValue)this.propValue.get(sh)).isImportant()) continue;
                        return;
                    }
                }
                shVal = new CSSShorthandValue(value, important);
                shVal.setShorthandText(this.setSubproperties(propertyName, value, priority));
                this.propValue.put(propertyName, shVal);
                this.shorthandList.add(propertyName);
            }
        } else {
            ExtendedCSSValue cssvalue = AbstractCSSValue.createCSSValue(value);
            if (propertyName.equals("font-family") || propertyName.equals("content")) {
                if (cssvalue.getCssValueType() == 2) {
                    DOMCSSValueList list = (DOMCSSValueList)cssvalue;
                    if (list.isCommaSeparated()) {
                        int sz = list.getLength();
                        int i = 0;
                        while (i < sz) {
                            if (list.item(i).getCssValueType() == 2) {
                                list.set(i, this.listToString((DOMCSSValueList)list.item(i)));
                            }
                            ++i;
                        }
                    } else {
                        cssvalue = this.listToString(list);
                    }
                }
            } else if (propertyName.equals("background-position") && cssvalue.getCssValueType() == 2 && !BaseCSSStyleDeclaration.checkBackgroundPosition((DOMCSSValueList)cssvalue)) {
                CSSStyleDeclarationRule prule = this.getParentRule();
                if (prule != null) {
                    CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for background-position");
                    ex.setValueText(cssvalue.getCssText());
                    prule.getStyleDeclarationErrorHandler().wrongValue("background-position", ex);
                }
                return;
            }
            this.setProperty(propertyName, cssvalue, priority);
        }
    }

    private CSSStringValue listToString(DOMCSSValueList cssvalue) {
        int len = cssvalue.getLength();
        StringBuilder buf = new StringBuilder(cssvalue.getLength() * 7 + 8);
        buf.append(cssvalue.item(0).getCssText());
        int i = 1;
        while (i < len) {
            buf.append(' ').append(cssvalue.item(i).getCssText());
            ++i;
        }
        CSSStringValue csstr = new CSSStringValue();
        csstr.setStringValue((short)19, buf.toString());
        return csstr;
    }

    private static boolean checkBackgroundPosition(DOMCSSValueList list) {
        int count = list.getLength();
        if (count < 3) {
            return true;
        }
        if (count == 4) {
            return ((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(3))).getPrimitiveType() != 21;
        }
        if (((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() != 21) {
            return false;
        }
        if (((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() != 21) {
            return true;
        }
        return ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21;
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        Parser parser;
        try {
            parser = SACParserFactory.createSACParser();
        }
        catch (DOMException e) {
            throw new DOMException(7, e.getMessage());
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(value);
        source.setCharacterStream((Reader)re);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        if (priority != null) {
            priority = priority.toLowerCase(Locale.US).intern();
        }
        this.setProperty(propertyName, lunit, priority);
    }

    boolean setProperty(String propertyName, ExtendedCSSValue cssValue, String priority) {
        if (!this.propertyList.contains(propertyName = propertyName.intern())) {
            this.addProperty(propertyName, cssValue, priority);
            return true;
        }
        int idx = this.propertyList.indexOf(propertyName);
        if (!"important".equals(this.priorities.get(idx)) || "important".equals(priority)) {
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            this.addProperty(propertyName, cssValue, priority);
            return true;
        }
        return false;
    }

    @Override
    void addProperty(String propertyName, ExtendedCSSValue cssValue, String priority) {
        if (cssValue instanceof CSSShorthandValue) {
            this.shorthandList.add(propertyName);
        } else {
            this.propertyList.add(propertyName);
            this.priorities.add(priority);
        }
        this.propValue.put(propertyName, cssValue);
    }

    @Override
    public boolean isEmpty() {
        return this.propertyList.isEmpty();
    }

    @Override
    public int getLength() {
        return this.propertyList.size();
    }

    @Override
    public String item(int index) {
        if (index < 0 || index > this.propertyList.size()) {
            return "";
        }
        return this.propertyList.get(index);
    }

    @Override
    void clear() {
        this.propValue.clear();
        this.propertyList.clear();
        this.priorities.clear();
        this.shorthandList.clear();
        CSSStyleDeclarationRule prule = this.getParentRule();
        if (prule != null) {
            prule.getStyleDeclarationErrorHandler().reset();
        }
    }

    @Override
    public CSSStyleDeclarationRule getParentRule() {
        return this.parentRule;
    }

    public void addStyle(BaseCSSStyleDeclaration style) {
        Iterator<String> it = style.propertyList.iterator();
        int i = -1;
        while (it.hasNext()) {
            ++i;
            String propertyName = it.next();
            int pIndex = this.propertyList.indexOf(propertyName);
            if (pIndex == -1) {
                this.propertyList.add(propertyName);
                this.priorities.add(style.priorities.get(i));
            } else if (!"important".equals(this.priorities.get(pIndex))) {
                this.priorities.set(pIndex, style.priorities.get(i));
            } else if (!"important".equals(style.priorities.get(i))) continue;
            this.setPropertyCSSValue(propertyName, style.propValue.get(propertyName), style.getParentRule());
        }
    }

    protected void setPropertyCSSValue(String propertyName, ExtendedCSSValue value, CSSStyleDeclarationRule parentRule) {
        this.propValue.put(propertyName, value);
    }

    @Override
    public void prioritySplit(AbstractCSSStyleDeclaration importantDecl, AbstractCSSStyleDeclaration normalDecl) {
        ExtendedCSSValue value;
        int psz = this.propertyList.size();
        int i = 0;
        while (i < psz) {
            String propertyName = this.propertyList.get(i);
            value = this.propValue.get(propertyName);
            String priority = this.priorities.get(i);
            if ("important".equals(priority)) {
                importantDecl.addProperty(propertyName, value, priority);
            } else {
                normalDecl.addProperty(propertyName, value, priority);
            }
            ++i;
        }
        for (String sh : this.shorthandList) {
            value = (CSSShorthandValue)this.propValue.get(sh);
            if (((CSSShorthandValue)value).isImportant()) {
                importantDecl.addProperty(sh, value, "important");
                continue;
            }
            normalDecl.addProperty(sh, value, null);
        }
    }

    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    public void setStyleDatabase(StyleDatabase styleDb) {
        this.styleDb = styleDb;
    }

    protected ExtendedCSSValue defaultPropertyValue(String propertyName) {
        ExtendedCSSValue defval = PropertyDatabase.getInstance().getInitialValue(propertyName);
        if (defval == null) {
            if (propertyName.equals("color")) {
                defval = (ExtendedCSSValue)((Object)this.getStyleDatabase().getInitialColor());
            } else if (propertyName.equals("font-family")) {
                defval = AbstractCSSValue.parseProperty(this.getStyleDatabase().getDefaultGenericFontFamily());
            } else if (propertyName.equals("text-align")) {
                String directionValue = this.getPropertyValue("direction");
                defval = directionValue.equals("rtl") ? AbstractCSSValue.parseProperty("right") : AbstractCSSValue.parseProperty("left");
            } else if (propertyName.equals("border-top-color")) {
                defval = this.getCSSColor();
            } else if (propertyName.equals("border-right-color")) {
                defval = this.getCSSColor();
            } else if (propertyName.equals("border-bottom-color")) {
                defval = this.getCSSColor();
            } else if (propertyName.equals("border-left-color")) {
                defval = this.getCSSColor();
            } else if (propertyName.equals("quotes")) {
                defval = AbstractCSSValue.parseProperty("\" \"");
            }
        }
        return defval;
    }

    protected boolean isFontFamilyAvailable(String requestedFamily) {
        return this.getStyleDatabase().isFontFamilyAvailable(requestedFamily);
    }

    public AbstractCSSPrimitiveValue getCSSColor() {
        AbstractCSSPrimitiveValue color = (AbstractCSSPrimitiveValue)this.getCSSValue("color");
        if (color == null) {
            StyleDatabase sdb = this.getStyleDatabase();
            color = sdb != null ? (AbstractCSSPrimitiveValue)this.getStyleDatabase().getInitialColor() : AbstractStyleDatabase.DEFAULT_INITIAL_COLOR;
        }
        return color;
    }

    protected String setSubproperties(String propertyName, LexicalUnit value, String priority) throws DOMException {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        if (pdb.isShorthand(propertyName)) {
            ShorthandSetter setter = "font".equals(propertyName) ? new FontShorthandSetter() : ("margin".equals(propertyName) ? new BoxShorthandSetter(propertyName) : ("padding".equals(propertyName) ? new BoxShorthandSetter("padding") : ("border".equals(propertyName) ? new BorderShorthandSetter() : ("border-width".equals(propertyName) ? new BoxShorthandSetter("border-width") : ("border-style".equals(propertyName) ? new BoxShorthandSetter("border-style") : ("border-color".equals(propertyName) ? new BoxShorthandSetter("border-color") : ("border-top".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "top") : ("border-right".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "right") : ("border-bottom".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "bottom") : ("border-left".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "left") : ("background".equals(propertyName) ? new BackgroundShorthandSetter() : ("transition".equals(propertyName) ? new TransitionShorthandSetter() : ("border-image".equals(propertyName) ? new BorderImageShorthandSetter() : new ShorthandSetter(propertyName))))))))))))));
            setter.init(value, priority);
            setter.assignSubproperties();
            return setter.getCssText();
        }
        return null;
    }

    public BaseCSSStyleDeclaration clone() {
        return new BaseCSSStyleDeclaration(this);
    }

    StyleDeclarationDocumentHandler getStyleDeclarationDocumentHandler() {
        return new StyleDeclarationDocumentHandler();
    }

    @Override
    public String getAzimuth() {
        return this.getPropertyValue("azimuth");
    }

    @Override
    public void setAzimuth(String azimuth) throws DOMException {
        this.getPropertyCSSValue("azimuth").setCssText(azimuth);
    }

    @Override
    public String getBackground() {
        return this.getPropertyValue("background");
    }

    @Override
    public void setBackground(String background) throws DOMException {
        this.getPropertyCSSValue("background").setCssText(background);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.getPropertyValue("background-attachment");
    }

    @Override
    public void setBackgroundAttachment(String backgroundAttachment) throws DOMException {
        this.getPropertyCSSValue("background-attachment").setCssText(backgroundAttachment);
    }

    @Override
    public String getBackgroundColor() {
        return this.getPropertyValue("background-color");
    }

    @Override
    public void setBackgroundColor(String backgroundColor) throws DOMException {
        this.getPropertyCSSValue("background-color").setCssText(backgroundColor);
    }

    @Override
    public String getBackgroundImage() {
        return this.getPropertyValue("background-image");
    }

    @Override
    public void setBackgroundImage(String backgroundImage) throws DOMException {
        this.getPropertyCSSValue("background-attachment").setCssText(backgroundImage);
    }

    @Override
    public String getBackgroundPosition() {
        return this.getPropertyValue("background-position");
    }

    @Override
    public void setBackgroundPosition(String backgroundPosition) throws DOMException {
        this.getPropertyCSSValue("background-position").setCssText(backgroundPosition);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.getPropertyValue("background-repeat");
    }

    @Override
    public void setBackgroundRepeat(String backgroundRepeat) throws DOMException {
        this.getPropertyCSSValue("background-repeat").setCssText(backgroundRepeat);
    }

    @Override
    public String getBorder() {
        return this.getPropertyValue("border");
    }

    @Override
    public void setBorder(String border) throws DOMException {
        this.getPropertyCSSValue("border").setCssText(border);
    }

    @Override
    public String getBorderCollapse() {
        return this.getPropertyValue("border-collapse");
    }

    @Override
    public void setBorderCollapse(String borderCollapse) throws DOMException {
        this.getPropertyCSSValue("border-collapse").setCssText(borderCollapse);
    }

    @Override
    public String getBorderColor() {
        return this.getPropertyValue("border-color");
    }

    @Override
    public void setBorderColor(String borderColor) throws DOMException {
        this.getPropertyCSSValue("border-color").setCssText(borderColor);
    }

    @Override
    public String getBorderSpacing() {
        return this.getPropertyValue("border-spacing");
    }

    @Override
    public void setBorderSpacing(String borderSpacing) throws DOMException {
        this.getPropertyCSSValue("border-spacing").setCssText(borderSpacing);
    }

    @Override
    public String getBorderStyle() {
        return this.getPropertyValue("border-style");
    }

    @Override
    public void setBorderStyle(String borderStyle) throws DOMException {
        this.getPropertyCSSValue("border-style").setCssText(borderStyle);
    }

    @Override
    public String getBorderTop() {
        return this.getPropertyValue("border-top");
    }

    @Override
    public void setBorderTop(String borderTop) throws DOMException {
        this.getPropertyCSSValue("border-top").setCssText(borderTop);
    }

    @Override
    public String getBorderRight() {
        return this.getPropertyValue("border-right");
    }

    @Override
    public void setBorderRight(String borderRight) throws DOMException {
        this.getPropertyCSSValue("border-right").setCssText(borderRight);
    }

    @Override
    public String getBorderBottom() {
        return this.getPropertyValue("border-bottom");
    }

    @Override
    public void setBorderBottom(String borderBottom) throws DOMException {
        this.getPropertyCSSValue("border-bottom").setCssText(borderBottom);
    }

    @Override
    public String getBorderLeft() {
        return this.getPropertyValue("border-left");
    }

    @Override
    public void setBorderLeft(String borderLeft) throws DOMException {
        this.getPropertyCSSValue("border-left").setCssText(borderLeft);
    }

    @Override
    public String getBorderTopColor() {
        return this.getPropertyValue("border-top-color");
    }

    @Override
    public void setBorderTopColor(String borderTopColor) throws DOMException {
        this.getPropertyCSSValue("border-top-color").setCssText(borderTopColor);
    }

    @Override
    public String getBorderRightColor() {
        return this.getPropertyValue("border-right-color");
    }

    @Override
    public void setBorderRightColor(String borderRightColor) throws DOMException {
        this.getPropertyCSSValue("border-right-color").setCssText(borderRightColor);
    }

    @Override
    public String getBorderBottomColor() {
        return this.getPropertyValue("border-bottom-color");
    }

    @Override
    public void setBorderBottomColor(String borderBottomColor) throws DOMException {
        this.getPropertyCSSValue("border-bottom-color").setCssText(borderBottomColor);
    }

    @Override
    public String getBorderLeftColor() {
        return this.getPropertyValue("border-left-color");
    }

    @Override
    public void setBorderLeftColor(String borderLeftColor) throws DOMException {
        this.getPropertyCSSValue("border-left-color").setCssText(borderLeftColor);
    }

    @Override
    public String getBorderTopStyle() {
        return this.getPropertyValue("border-top-style");
    }

    @Override
    public void setBorderTopStyle(String borderTopStyle) throws DOMException {
        this.getPropertyCSSValue("border-top-style").setCssText(borderTopStyle);
    }

    @Override
    public String getBorderRightStyle() {
        return this.getPropertyValue("border-right-style");
    }

    @Override
    public void setBorderRightStyle(String borderRightStyle) throws DOMException {
        this.getPropertyCSSValue("border-right-style").setCssText(borderRightStyle);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.getPropertyValue("border-bottom-style");
    }

    @Override
    public void setBorderBottomStyle(String borderBottomStyle) throws DOMException {
        this.getPropertyCSSValue("border-bottom-style").setCssText(borderBottomStyle);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.getPropertyValue("border-left-style");
    }

    @Override
    public void setBorderLeftStyle(String borderLeftStyle) throws DOMException {
        this.getPropertyCSSValue("border-left-style").setCssText(borderLeftStyle);
    }

    @Override
    public String getBorderTopWidth() {
        return this.getPropertyValue("border-top-width");
    }

    @Override
    public void setBorderTopWidth(String borderTopWidth) throws DOMException {
        this.getPropertyCSSValue("border-top-width").setCssText(borderTopWidth);
    }

    @Override
    public String getBorderRightWidth() {
        return this.getPropertyValue("border-right-width");
    }

    @Override
    public void setBorderRightWidth(String borderRightWidth) throws DOMException {
        this.getPropertyCSSValue("border-right-width").setCssText(borderRightWidth);
    }

    @Override
    public String getBorderBottomWidth() {
        return this.getPropertyValue("border-bottom-width");
    }

    @Override
    public void setBorderBottomWidth(String borderBottomWidth) throws DOMException {
        this.getPropertyCSSValue("border-bottom-width").setCssText(borderBottomWidth);
    }

    @Override
    public String getBorderLeftWidth() {
        return this.getPropertyValue("border-left-width");
    }

    @Override
    public void setBorderLeftWidth(String borderLeftWidth) throws DOMException {
        this.getPropertyCSSValue("border-left-width").setCssText(borderLeftWidth);
    }

    @Override
    public String getBorderWidth() {
        return this.getPropertyValue("border-width");
    }

    @Override
    public void setBorderWidth(String borderWidth) throws DOMException {
        this.getPropertyCSSValue("border-width").setCssText(borderWidth);
    }

    @Override
    public String getBottom() {
        return this.getPropertyValue("bottom");
    }

    @Override
    public void setBottom(String bottom) throws DOMException {
        this.getPropertyCSSValue("bottom").setCssText(bottom);
    }

    @Override
    public String getCaptionSide() {
        return this.getPropertyValue("caption-side");
    }

    @Override
    public void setCaptionSide(String captionSide) throws DOMException {
        this.getPropertyCSSValue("caption-side").setCssText(captionSide);
    }

    @Override
    public String getClear() {
        return this.getPropertyValue("clear");
    }

    @Override
    public void setClear(String clear) throws DOMException {
        this.getPropertyCSSValue("clear").setCssText(clear);
    }

    @Override
    public String getClip() {
        return this.getPropertyValue("clip");
    }

    @Override
    public void setClip(String clip) throws DOMException {
        this.getPropertyCSSValue("clip").setCssText(clip);
    }

    @Override
    public String getColor() {
        return this.getPropertyValue("color");
    }

    @Override
    public void setColor(String color) throws DOMException {
        this.getPropertyCSSValue("color").setCssText(color);
    }

    @Override
    public String getContent() {
        return this.getPropertyValue("content");
    }

    @Override
    public void setContent(String content) throws DOMException {
        this.getPropertyCSSValue("content").setCssText(content);
    }

    @Override
    public String getCounterIncrement() {
        return this.getPropertyValue("counter-increment");
    }

    @Override
    public void setCounterIncrement(String counterIncrement) throws DOMException {
        this.getPropertyCSSValue("counter-increment").setCssText(counterIncrement);
    }

    @Override
    public String getCounterReset() {
        return this.getPropertyValue("counter-reset");
    }

    @Override
    public void setCounterReset(String counterReset) throws DOMException {
        this.getPropertyCSSValue("counter-reset").setCssText(counterReset);
    }

    @Override
    public String getCue() {
        return this.getPropertyValue("cue");
    }

    @Override
    public void setCue(String cue) throws DOMException {
        this.getPropertyCSSValue("cue").setCssText(cue);
    }

    @Override
    public String getCueAfter() {
        return this.getPropertyValue("cue-after");
    }

    @Override
    public void setCueAfter(String cueAfter) throws DOMException {
        this.getPropertyCSSValue("cue-after").setCssText(cueAfter);
    }

    @Override
    public String getCueBefore() {
        return this.getPropertyValue("cue-before");
    }

    @Override
    public void setCueBefore(String cueBefore) throws DOMException {
        this.getPropertyCSSValue("cue-before").setCssText(cueBefore);
    }

    @Override
    public String getCursor() {
        return this.getPropertyValue("cursor");
    }

    @Override
    public void setCursor(String cursor) throws DOMException {
        this.getPropertyCSSValue("cursor").setCssText(cursor);
    }

    @Override
    public String getDirection() {
        return this.getPropertyValue("direction");
    }

    @Override
    public void setDirection(String direction) throws DOMException {
        this.getPropertyCSSValue("direction").setCssText(direction);
    }

    @Override
    public String getDisplay() {
        return this.getPropertyValue("display");
    }

    @Override
    public void setDisplay(String display) throws DOMException {
        this.getPropertyCSSValue("display").setCssText(display);
    }

    @Override
    public String getElevation() {
        return this.getPropertyValue("elevation");
    }

    @Override
    public void setElevation(String elevation) throws DOMException {
        this.getPropertyCSSValue("elevation").setCssText(elevation);
    }

    @Override
    public String getEmptyCells() {
        return this.getPropertyValue("empty-cells");
    }

    @Override
    public void setEmptyCells(String emptyCells) throws DOMException {
        this.getPropertyCSSValue("empty-cells").setCssText(emptyCells);
    }

    @Override
    public String getCssFloat() {
        return this.getPropertyValue("css-float");
    }

    @Override
    public void setCssFloat(String cssFloat) throws DOMException {
        this.getPropertyCSSValue("css-float").setCssText(cssFloat);
    }

    @Override
    public String getFont() {
        return this.getPropertyValue("font");
    }

    @Override
    public void setFont(String font) throws DOMException {
        this.getPropertyCSSValue("font").setCssText(font);
    }

    @Override
    public String getFontFamily() {
        return this.getPropertyValue("font-family");
    }

    @Override
    public void setFontFamily(String fontFamily) throws DOMException {
        this.getPropertyCSSValue("font-family").setCssText(fontFamily);
    }

    @Override
    public String getFontSize() {
        return this.getPropertyValue("font-size");
    }

    @Override
    public void setFontSize(String fontSize) throws DOMException {
        this.getPropertyCSSValue("font-size").setCssText(fontSize);
    }

    @Override
    public String getFontSizeAdjust() {
        return this.getPropertyValue("font-size-adjust");
    }

    @Override
    public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
        this.getPropertyCSSValue("font-size-adjust").setCssText(fontSizeAdjust);
    }

    @Override
    public String getFontStretch() {
        return this.getPropertyValue("font-stretch");
    }

    @Override
    public void setFontStretch(String fontStretch) throws DOMException {
        this.getPropertyCSSValue("font-stretch").setCssText(fontStretch);
    }

    @Override
    public String getFontStyle() {
        return this.getPropertyValue("font-style");
    }

    @Override
    public void setFontStyle(String fontStyle) throws DOMException {
        this.getPropertyCSSValue("font-style").setCssText(fontStyle);
    }

    @Override
    public String getFontVariant() {
        return this.getPropertyValue("font-variant");
    }

    @Override
    public void setFontVariant(String fontVariant) throws DOMException {
        this.getPropertyCSSValue("font-variant").setCssText(fontVariant);
    }

    @Override
    public String getFontWeight() {
        return this.getPropertyValue("font-weight");
    }

    @Override
    public void setFontWeight(String fontWeight) throws DOMException {
        this.getPropertyCSSValue("font-weight").setCssText(fontWeight);
    }

    @Override
    public String getHeight() {
        return this.getPropertyValue("height");
    }

    @Override
    public void setHeight(String height) throws DOMException {
        this.getPropertyCSSValue("height").setCssText(height);
    }

    @Override
    public String getLeft() {
        return this.getPropertyValue("left");
    }

    @Override
    public void setLeft(String left) throws DOMException {
        this.getPropertyCSSValue("left").setCssText(left);
    }

    @Override
    public String getLetterSpacing() {
        return this.getPropertyValue("letter-spacing");
    }

    @Override
    public void setLetterSpacing(String letterSpacing) throws DOMException {
        this.getPropertyCSSValue("letter-spacing").setCssText(letterSpacing);
    }

    @Override
    public String getLineHeight() {
        return this.getPropertyValue("line-height");
    }

    @Override
    public void setLineHeight(String lineHeight) throws DOMException {
        this.getPropertyCSSValue("line-height").setCssText(lineHeight);
    }

    @Override
    public String getListStyle() {
        return this.getPropertyValue("list-style");
    }

    @Override
    public void setListStyle(String listStyle) throws DOMException {
        this.getPropertyCSSValue("list-style").setCssText(listStyle);
    }

    @Override
    public String getListStyleImage() {
        return this.getPropertyValue("list-style-image");
    }

    @Override
    public void setListStyleImage(String listStyleImage) throws DOMException {
        this.getPropertyCSSValue("list-style-image").setCssText(listStyleImage);
    }

    @Override
    public String getListStylePosition() {
        return this.getPropertyValue("list-style-position");
    }

    @Override
    public void setListStylePosition(String listStylePosition) throws DOMException {
        this.getPropertyCSSValue("list-style-position").setCssText(listStylePosition);
    }

    @Override
    public String getListStyleType() {
        return this.getPropertyValue("list-style-type");
    }

    @Override
    public void setListStyleType(String listStyleType) throws DOMException {
        this.getPropertyCSSValue("list-style-type").setCssText(listStyleType);
    }

    @Override
    public String getMargin() {
        return this.getPropertyValue("margin");
    }

    @Override
    public void setMargin(String margin) throws DOMException {
        this.getPropertyCSSValue("margin").setCssText(margin);
    }

    @Override
    public String getMarginTop() {
        return this.getPropertyValue("margin-top");
    }

    @Override
    public void setMarginTop(String marginTop) throws DOMException {
        this.getPropertyCSSValue("margin-top").setCssText(marginTop);
    }

    @Override
    public String getMarginRight() {
        return this.getPropertyValue("margin-right");
    }

    @Override
    public void setMarginRight(String marginRight) throws DOMException {
        this.getPropertyCSSValue("margin-right").setCssText(marginRight);
    }

    @Override
    public String getMarginBottom() {
        return this.getPropertyValue("margin-bottom");
    }

    @Override
    public void setMarginBottom(String marginBottom) throws DOMException {
        this.getPropertyCSSValue("margin-bottom").setCssText(marginBottom);
    }

    @Override
    public String getMarginLeft() {
        return this.getPropertyValue("margin-left");
    }

    @Override
    public void setMarginLeft(String marginLeft) throws DOMException {
        this.getPropertyCSSValue("margin-left").setCssText(marginLeft);
    }

    @Override
    public String getMarkerOffset() {
        return this.getPropertyValue("marker-offset");
    }

    @Override
    public void setMarkerOffset(String markerOffset) throws DOMException {
        this.getPropertyCSSValue("marker-offset").setCssText(markerOffset);
    }

    @Override
    public String getMarks() {
        return this.getPropertyValue("marks");
    }

    @Override
    public void setMarks(String marks) throws DOMException {
        this.getPropertyCSSValue("marks").setCssText(marks);
    }

    @Override
    public String getMaxHeight() {
        return this.getPropertyValue("max-height");
    }

    @Override
    public void setMaxHeight(String maxHeight) throws DOMException {
        this.getPropertyCSSValue("max-height").setCssText(maxHeight);
    }

    @Override
    public String getMaxWidth() {
        return this.getPropertyValue("max-width");
    }

    @Override
    public void setMaxWidth(String maxWidth) throws DOMException {
        this.getPropertyCSSValue("max-width").setCssText(maxWidth);
    }

    @Override
    public String getMinHeight() {
        return this.getPropertyValue("min-height");
    }

    @Override
    public void setMinHeight(String minHeight) throws DOMException {
        this.getPropertyCSSValue("min-height").setCssText(minHeight);
    }

    @Override
    public String getMinWidth() {
        return this.getPropertyValue("min-width");
    }

    @Override
    public void setMinWidth(String minWidth) throws DOMException {
        this.getPropertyCSSValue("min-width").setCssText(minWidth);
    }

    @Override
    public String getOrphans() {
        return this.getPropertyValue("orphans");
    }

    @Override
    public void setOrphans(String orphans) throws DOMException {
        this.getPropertyCSSValue("orphans").setCssText(orphans);
    }

    @Override
    public String getOutline() {
        return this.getPropertyValue("outline");
    }

    @Override
    public void setOutline(String outline) throws DOMException {
        this.getPropertyCSSValue("outline").setCssText(outline);
    }

    @Override
    public String getOutlineColor() {
        return this.getPropertyValue("outline-color");
    }

    @Override
    public void setOutlineColor(String outlineColor) throws DOMException {
        this.getPropertyCSSValue("outline-color").setCssText(outlineColor);
    }

    @Override
    public String getOutlineStyle() {
        return this.getPropertyValue("outline-style");
    }

    @Override
    public void setOutlineStyle(String outlineStyle) throws DOMException {
        this.getPropertyCSSValue("outline-style").setCssText(outlineStyle);
    }

    @Override
    public String getOutlineWidth() {
        return this.getPropertyValue("outline-width");
    }

    @Override
    public void setOutlineWidth(String outlineWidth) throws DOMException {
        this.getPropertyCSSValue("outline-width").setCssText(outlineWidth);
    }

    @Override
    public String getOverflow() {
        return this.getPropertyValue("overflow");
    }

    @Override
    public void setOverflow(String overflow) throws DOMException {
        this.getPropertyCSSValue("overflow").setCssText(overflow);
    }

    @Override
    public String getPadding() {
        return this.getPropertyValue("padding");
    }

    @Override
    public void setPadding(String padding) throws DOMException {
        this.getPropertyCSSValue("padding").setCssText(padding);
    }

    @Override
    public String getPaddingTop() {
        return this.getPropertyValue("padding-top");
    }

    @Override
    public void setPaddingTop(String paddingTop) throws DOMException {
        this.getPropertyCSSValue("padding-top").setCssText(paddingTop);
    }

    @Override
    public String getPaddingRight() {
        return this.getPropertyValue("padding-right");
    }

    @Override
    public void setPaddingRight(String paddingRight) throws DOMException {
        this.getPropertyCSSValue("padding-right").setCssText(paddingRight);
    }

    @Override
    public String getPaddingBottom() {
        return this.getPropertyValue("padding-bottom");
    }

    @Override
    public void setPaddingBottom(String paddingBottom) throws DOMException {
        this.getPropertyCSSValue("padding-bottom").setCssText(paddingBottom);
    }

    @Override
    public String getPaddingLeft() {
        return this.getPropertyValue("padding-left");
    }

    @Override
    public void setPaddingLeft(String paddingLeft) throws DOMException {
        this.getPropertyCSSValue("padding-left").setCssText(paddingLeft);
    }

    @Override
    public String getPage() {
        return this.getPropertyValue("page");
    }

    @Override
    public void setPage(String page) throws DOMException {
        this.getPropertyCSSValue("page").setCssText(page);
    }

    @Override
    public String getPageBreakAfter() {
        return this.getPropertyValue("page-break-after");
    }

    @Override
    public void setPageBreakAfter(String pageBreakAfter) throws DOMException {
        this.getPropertyCSSValue("page-break-after").setCssText(pageBreakAfter);
    }

    @Override
    public String getPageBreakBefore() {
        return this.getPropertyValue("page-break-before");
    }

    @Override
    public void setPageBreakBefore(String pageBreakBefore) throws DOMException {
        this.getPropertyCSSValue("page-break-before").setCssText(pageBreakBefore);
    }

    @Override
    public String getPageBreakInside() {
        return this.getPropertyValue("page-break-inside");
    }

    @Override
    public void setPageBreakInside(String pageBreakInside) throws DOMException {
        this.getPropertyCSSValue("page-break-inside").setCssText(pageBreakInside);
    }

    @Override
    public String getPause() {
        return this.getPropertyValue("pause");
    }

    @Override
    public void setPause(String pause) throws DOMException {
        this.getPropertyCSSValue("pause").setCssText(pause);
    }

    @Override
    public String getPauseAfter() {
        return this.getPropertyValue("pause-after");
    }

    @Override
    public void setPauseAfter(String pauseAfter) throws DOMException {
        this.getPropertyCSSValue("pause-after").setCssText(pauseAfter);
    }

    @Override
    public String getPauseBefore() {
        return this.getPropertyValue("pause-before");
    }

    @Override
    public void setPauseBefore(String pauseBefore) throws DOMException {
        this.getPropertyCSSValue("pause-before").setCssText(pauseBefore);
    }

    @Override
    public String getPitch() {
        return this.getPropertyValue("pitch");
    }

    @Override
    public void setPitch(String pitch) throws DOMException {
        this.getPropertyCSSValue("pitch").setCssText(pitch);
    }

    @Override
    public String getPitchRange() {
        return this.getPropertyValue("pitch-range");
    }

    @Override
    public void setPitchRange(String pitchRange) throws DOMException {
        this.getPropertyCSSValue("pitch-range").setCssText(pitchRange);
    }

    @Override
    public String getPlayDuring() {
        return this.getPropertyValue("play-during");
    }

    @Override
    public void setPlayDuring(String playDuring) throws DOMException {
        this.getPropertyCSSValue("play-during").setCssText(playDuring);
    }

    @Override
    public String getPosition() {
        return this.getPropertyValue("position");
    }

    @Override
    public void setPosition(String position) throws DOMException {
        this.getPropertyCSSValue("position").setCssText(position);
    }

    @Override
    public String getQuotes() {
        return this.getPropertyValue("quotes");
    }

    @Override
    public void setQuotes(String quotes) throws DOMException {
        this.getPropertyCSSValue("quotes").setCssText(quotes);
    }

    @Override
    public String getRichness() {
        return this.getPropertyValue("richness");
    }

    @Override
    public void setRichness(String richness) throws DOMException {
        this.getPropertyCSSValue("richness").setCssText(richness);
    }

    @Override
    public String getRight() {
        return this.getPropertyValue("right");
    }

    @Override
    public void setRight(String right) throws DOMException {
        this.getPropertyCSSValue("right").setCssText(right);
    }

    @Override
    public String getSize() {
        return this.getPropertyValue("size");
    }

    @Override
    public void setSize(String size) throws DOMException {
        this.getPropertyCSSValue("size").setCssText(size);
    }

    @Override
    public String getSpeak() {
        return this.getPropertyValue("speak");
    }

    @Override
    public void setSpeak(String speak) throws DOMException {
        this.getPropertyCSSValue("speak").setCssText(speak);
    }

    @Override
    public String getSpeakHeader() {
        return this.getPropertyValue("speak-header");
    }

    @Override
    public void setSpeakHeader(String speakHeader) throws DOMException {
        this.getPropertyCSSValue("speak-header").setCssText(speakHeader);
    }

    @Override
    public String getSpeakNumeral() {
        return this.getPropertyValue("speak-numeral");
    }

    @Override
    public void setSpeakNumeral(String speakNumeral) throws DOMException {
        this.getPropertyCSSValue("speak-numeral").setCssText(speakNumeral);
    }

    @Override
    public String getSpeakPunctuation() {
        return this.getPropertyValue("speak-punctuation");
    }

    @Override
    public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
        this.getPropertyCSSValue("speak-punctuation").setCssText(speakPunctuation);
    }

    @Override
    public String getSpeechRate() {
        return this.getPropertyValue("speech-rate");
    }

    @Override
    public void setSpeechRate(String speechRate) throws DOMException {
        this.getPropertyCSSValue("speech-rate").setCssText(speechRate);
    }

    @Override
    public String getStress() {
        return this.getPropertyValue("stress");
    }

    @Override
    public void setStress(String stress) throws DOMException {
        this.getPropertyCSSValue("stress").setCssText(stress);
    }

    @Override
    public String getTableLayout() {
        return this.getPropertyValue("table-layout");
    }

    @Override
    public void setTableLayout(String tableLayout) throws DOMException {
        this.getPropertyCSSValue("table-layout").setCssText(tableLayout);
    }

    @Override
    public String getTextAlign() {
        return this.getPropertyValue("text-align");
    }

    @Override
    public void setTextAlign(String textAlign) throws DOMException {
        this.getPropertyCSSValue("text-align").setCssText(textAlign);
    }

    @Override
    public String getTextDecoration() {
        return this.getPropertyValue("text-decoration");
    }

    @Override
    public void setTextDecoration(String textDecoration) throws DOMException {
        this.getPropertyCSSValue("text-decoration").setCssText(textDecoration);
    }

    @Override
    public String getTextIndent() {
        return this.getPropertyValue("text-indent");
    }

    @Override
    public void setTextIndent(String textIndent) throws DOMException {
        this.getPropertyCSSValue("text-indent").setCssText(textIndent);
    }

    @Override
    public String getTextShadow() {
        return this.getPropertyValue("text-shadow");
    }

    @Override
    public void setTextShadow(String textShadow) throws DOMException {
        this.getPropertyCSSValue("text-shadow").setCssText(textShadow);
    }

    @Override
    public String getTextTransform() {
        return this.getPropertyValue("text-transform");
    }

    @Override
    public void setTextTransform(String textTransform) throws DOMException {
        this.getPropertyCSSValue("text-transform").setCssText(textTransform);
    }

    @Override
    public String getTop() {
        return this.getPropertyValue("top");
    }

    @Override
    public void setTop(String top) throws DOMException {
        this.getPropertyCSSValue("top").setCssText(top);
    }

    @Override
    public String getUnicodeBidi() {
        return this.getPropertyValue("unicode-bidi");
    }

    @Override
    public void setUnicodeBidi(String unicodeBidi) throws DOMException {
        this.getPropertyCSSValue("unicode-bidi").setCssText(unicodeBidi);
    }

    @Override
    public String getVerticalAlign() {
        return this.getPropertyValue("vertical-align");
    }

    @Override
    public void setVerticalAlign(String verticalAlign) throws DOMException {
        this.getPropertyCSSValue("vertical-align").setCssText(verticalAlign);
    }

    @Override
    public String getVisibility() {
        return this.getPropertyValue("visibility");
    }

    @Override
    public void setVisibility(String visibility) throws DOMException {
        this.getPropertyCSSValue("visibility").setCssText(visibility);
    }

    @Override
    public String getVoiceFamily() {
        return this.getPropertyValue("voice-family");
    }

    @Override
    public void setVoiceFamily(String voiceFamily) throws DOMException {
        this.getPropertyCSSValue("voice-family").setCssText(voiceFamily);
    }

    @Override
    public String getVolume() {
        return this.getPropertyValue("volume");
    }

    @Override
    public void setVolume(String volume) throws DOMException {
        this.getPropertyCSSValue("volume").setCssText(volume);
    }

    @Override
    public String getWhiteSpace() {
        return this.getPropertyValue("white-space");
    }

    @Override
    public void setWhiteSpace(String whiteSpace) throws DOMException {
        this.getPropertyCSSValue("white-space").setCssText(whiteSpace);
    }

    @Override
    public String getWidows() {
        return null;
    }

    @Override
    public void setWidows(String widows) throws DOMException {
        this.getPropertyCSSValue("widows").setCssText(widows);
    }

    @Override
    public String getWidth() {
        return this.getPropertyValue("width");
    }

    @Override
    public void setWidth(String width) throws DOMException {
        this.getPropertyCSSValue("width").setCssText(width);
    }

    @Override
    public String getWordSpacing() {
        return this.getPropertyValue("word-spacing");
    }

    @Override
    public void setWordSpacing(String wordSpacing) throws DOMException {
        this.getPropertyCSSValue("word-spacing").setCssText(wordSpacing);
    }

    @Override
    public String getZIndex() {
        return this.getPropertyValue("z-index");
    }

    @Override
    public void setZIndex(String zIndex) throws DOMException {
        this.getPropertyCSSValue("z-index").setCssText(zIndex);
    }

    class BackgroundShorthandSetter
    extends ShorthandSetter {
        private String cssText;
        private int layerCount;
        private DOMCSSValueList lstImage;
        private DOMCSSValueList lstPosition;
        private DOMCSSValueList lstSize;
        private DOMCSSValueList lstRepeat;
        private DOMCSSValueList lstClip;
        private DOMCSSValueList lstOrigin;
        private DOMCSSValueList lstAttachment;
        private boolean finalLayer;

        BackgroundShorthandSetter() {
            super("background");
            this.cssText = null;
            this.layerCount = 0;
            this.lstImage = DOMCSSValueList.createCSValueList();
            this.lstPosition = DOMCSSValueList.createCSValueList();
            this.lstSize = DOMCSSValueList.createCSValueList();
            this.lstRepeat = DOMCSSValueList.createCSValueList();
            this.lstClip = DOMCSSValueList.createCSValueList();
            this.lstOrigin = DOMCSSValueList.createCSValueList();
            this.lstAttachment = DOMCSSValueList.createCSValueList();
            this.finalLayer = false;
        }

        @Override
        public void init(LexicalUnit shorthandValue, String priority) {
            this.currentValue = shorthandValue;
            this.setPriority(priority);
            this.setCssText(shorthandValue);
            this.countLayers(shorthandValue);
        }

        private void setCssText(LexicalUnit value) {
            StringBuilder valueBuffer = new StringBuilder(32);
            do {
                AbstractCSSValue cssValue;
                if ((cssValue = AbstractCSSValue.createCSSValueItem(value, true)) == null) continue;
                String cssText = cssValue.getCssText();
                if (valueBuffer.length() > 0) {
                    valueBuffer.append(' ');
                }
                valueBuffer.append(cssText);
            } while ((value = value.getNextLexicalUnit()) != null);
            this.cssText = valueBuffer.toString();
        }

        @Override
        public String getCssText() {
            return this.cssText;
        }

        protected void countLayers(LexicalUnit shorthandValue) {
            this.layerCount = 0;
            int valueCount = 0;
            LexicalUnit value = shorthandValue;
            while (value != null) {
                if (value.getLexicalUnitType() == 0) {
                    if (valueCount > 0) {
                        ++this.layerCount;
                        valueCount = 0;
                    }
                } else {
                    ++valueCount;
                }
                value = value.getNextLexicalUnit();
            }
            if (valueCount > 0) {
                ++this.layerCount;
            }
        }

        @Override
        public void assignSubproperties() {
            String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
            int i = 0;
            while (i < this.layerCount && this.currentValue != null) {
                HashSet<String> subp = new HashSet<String>(subparray.length);
                subp.addAll(Arrays.asList((String[])subparray.clone()));
                while (this.currentValue != null) {
                    CSSStyleDeclarationRule prule;
                    if (this.currentValue.getLexicalUnitType() == 0) {
                        ++i;
                        this.nextCurrentValue();
                        break;
                    }
                    if (this.testColor("background-color")) {
                        AbstractCSSValue cssValue = this.createCSSValue("background-color", this.currentValue);
                        this.setSubpropertyValue("background-color", cssValue);
                        subp.remove("background-color");
                        this.finalLayer = true;
                        this.nextCurrentValue();
                        continue;
                    }
                    if (this.testBackgroundImage(i, subp)) {
                        this.nextCurrentValue();
                        continue;
                    }
                    if (this.testBackgroundPosition(i, subp)) {
                        this.nextCurrentValue();
                        if (this.currentValue == null || 4 != this.currentValue.getLexicalUnitType()) continue;
                        this.nextCurrentValue();
                        if (this.currentValue != null && this.testBackgroundSize(i, subp)) {
                            this.nextCurrentValue();
                            continue;
                        }
                        prule = BaseCSSStyleDeclaration.this.getParentRule();
                        if (prule == null) continue;
                        prule.getStyleDeclarationErrorHandler().shorthandSyntaxError("background", "Size not found after slash");
                        continue;
                    }
                    if (this.testIdentifierProperty(i, subp, "background-attachment", this.lstAttachment)) {
                        this.nextCurrentValue();
                        subp.remove("background-attachment");
                        continue;
                    }
                    if (this.testIdentifierProperty(i, subp, "background-repeat", this.lstRepeat)) {
                        this.nextCurrentValue();
                        subp.remove("background-repeat");
                        continue;
                    }
                    if (this.testIdentifierProperty(i, subp, "background-origin", this.lstOrigin)) {
                        LexicalUnit lastValue = this.currentValue;
                        this.nextCurrentValue();
                        subp.remove("background-origin");
                        if (this.currentValue != null && this.testIdentifierProperty(i, subp, "background-clip", this.lstClip)) {
                            this.nextCurrentValue();
                        } else {
                            AbstractCSSValue value = this.createCSSValue("background-clip", lastValue);
                            this.lstClip.add(value);
                        }
                        subp.remove("background-clip");
                        continue;
                    }
                    prule = BaseCSSStyleDeclaration.this.getParentRule();
                    if (prule != null) {
                        if (this.currentValue.getLexicalUnitType() == 35) {
                            prule.getStyleDeclarationErrorHandler().unknownIdentifier("background", this.currentValue.getStringValue());
                        } else {
                            AbstractCSSValue val = this.createCSSValue("background", this.currentValue);
                            prule.getStyleDeclarationErrorHandler().unassignedSubpropertyValue("background", val.getCssText());
                        }
                    }
                    this.nextCurrentValue();
                }
                if (subp.size() > 0) {
                    for (String pname : subp) {
                        ExtendedCSSValue cssVal = BaseCSSStyleDeclaration.this.defaultPropertyValue(pname);
                        if ("background-image".equals(pname)) {
                            if (this.lstPosition.getLength() == i) {
                                this.lstPosition.remove(i - 1);
                            }
                            if (this.lstSize.getLength() == i) {
                                this.lstSize.remove(i - 1);
                            }
                            if (this.lstOrigin.getLength() == i) {
                                this.lstOrigin.remove(i - 1);
                            }
                            if (this.lstClip.getLength() == i) {
                                this.lstClip.remove(i - 1);
                            }
                            if (this.lstRepeat.getLength() == i) {
                                this.lstRepeat.remove(i - 1);
                            }
                            if (this.lstAttachment.getLength() != i) continue;
                            this.lstAttachment.remove(i - 1);
                            continue;
                        }
                        if ("background-position".equals(pname)) {
                            if (i > 1) {
                                this.lstPosition.add(this.lstPosition.item(0));
                                continue;
                            }
                            this.lstPosition.add(cssVal);
                            continue;
                        }
                        if ("background-size".equals(pname)) {
                            if (i > 1) {
                                this.lstSize.add(this.lstSize.item(0));
                                continue;
                            }
                            DOMCSSValueList list = DOMCSSValueList.createWSValueList();
                            list.add(cssVal);
                            list.add(cssVal);
                            this.lstSize.add(list);
                            continue;
                        }
                        if ("background-origin".equals(pname)) {
                            if (i > 1) {
                                this.lstOrigin.add(this.lstOrigin.item(0));
                                continue;
                            }
                            this.lstOrigin.add(cssVal);
                            continue;
                        }
                        if ("background-clip".equals(pname)) {
                            if (i > 1) {
                                this.lstClip.add(this.lstClip.item(0));
                                continue;
                            }
                            this.lstClip.add(cssVal);
                            continue;
                        }
                        if ("background-repeat".equals(pname)) {
                            if (i > 1) {
                                this.lstRepeat.add(this.lstRepeat.item(0));
                                continue;
                            }
                            this.lstRepeat.add(cssVal);
                            continue;
                        }
                        if (!"background-attachment".equals(pname)) continue;
                        if (i > 1) {
                            this.lstAttachment.add(this.lstAttachment.item(0));
                            continue;
                        }
                        this.lstAttachment.add(cssVal);
                    }
                }
                if (this.finalLayer) break;
            }
            this.setSubpropertyValue("background-image", this.lstImage);
            this.setSubpropertyValue("background-position", this.lstPosition);
            this.setSubpropertyValue("background-size", this.lstSize);
            this.setSubpropertyValue("background-origin", this.lstOrigin);
            this.setSubpropertyValue("background-clip", this.lstClip);
            this.setSubpropertyValue("background-repeat", this.lstRepeat);
            this.setSubpropertyValue("background-attachment", this.lstAttachment);
        }

        @Override
        protected void nextCurrentValue() {
            this.currentValue = this.currentValue.getNextLexicalUnit();
            this.appendValueString();
        }

        private boolean testBackgroundImage(int i, Set<String> subp) {
            if (this.currentValue.getLexicalUnitType() == 24) {
                this.lstImage.add(this.createCSSValue("background-image", this.currentValue));
                subp.remove("background-image");
                return true;
            }
            return false;
        }

        private boolean testBackgroundPosition(int i, Set<String> subp) {
            short utype = this.currentValue.getLexicalUnitType();
            if (35 == utype && this.testIdentifiers("background-position") || AbstractCSSPrimitiveValue.isNumericSACUnitType(utype)) {
                DOMCSSValueList list = DOMCSSValueList.createWSValueList();
                AbstractCSSValue value = this.createCSSValue("background-position", this.currentValue);
                list.add(value);
                int count = 1;
                LexicalUnit nlu = this.currentValue.getNextLexicalUnit();
                while (nlu != null && count < 4) {
                    boolean isident;
                    utype = nlu.getLexicalUnitType();
                    boolean bl = isident = utype == 35;
                    if (isident && this.getPropertyDatabase().isIdentifierValue("background-position", nlu.getStringValue()) || AbstractCSSPrimitiveValue.isNumericSACUnitType(utype)) {
                        value = this.createCSSValue("background-position", nlu);
                        list.add(value);
                        count = (short)(count + 1);
                        this.nextCurrentValue();
                        nlu = this.currentValue.getNextLexicalUnit();
                        continue;
                    }
                    nlu = null;
                }
                if (list.getLength() == 1) {
                    this.lstPosition.add(list.item(0));
                } else if (this.checkPositionProperty(list)) {
                    this.lstPosition.add(list);
                } else {
                    CSSStyleDeclarationRule prule = BaseCSSStyleDeclaration.this.getParentRule();
                    if (prule != null) {
                        CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for background-position");
                        ex.setValueText(list.getCssText());
                        prule.getStyleDeclarationErrorHandler().wrongValue("background-position", ex);
                    }
                    return false;
                }
                subp.remove("background-position");
                return true;
            }
            return false;
        }

        private boolean checkPositionProperty(DOMCSSValueList list) {
            int count = list.getLength();
            if (count == 2) {
                return true;
            }
            if (count == 4) {
                return ((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(3))).getPrimitiveType() != 21;
            }
            if (((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() != 21) {
                return false;
            }
            if (((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() != 21) {
                return true;
            }
            return ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21;
        }

        private boolean testBackgroundSize(int i, Set<String> subp) {
            short utype = this.currentValue.getLexicalUnitType();
            if (35 == utype && this.testIdentifiers("background-size") || AbstractCSSPrimitiveValue.isNumericSACUnitType(utype)) {
                DOMCSSValueList list = DOMCSSValueList.createWSValueList();
                AbstractCSSValue value = this.createCSSValue("background-size", this.currentValue);
                list.add(value);
                LexicalUnit nlu = this.currentValue.getNextLexicalUnit();
                if (nlu != null) {
                    boolean isident;
                    utype = nlu.getLexicalUnitType();
                    boolean bl = isident = utype == 35;
                    if (isident && this.getPropertyDatabase().isIdentifierValue("background-size", nlu.getStringValue()) || AbstractCSSPrimitiveValue.isNumericSACUnitType(utype)) {
                        value = this.createCSSValue("background-size", nlu);
                        list.add(value);
                        this.nextCurrentValue();
                    }
                }
                if (list.getLength() == 1) {
                    this.lstSize.add(list.item(0));
                } else {
                    this.lstSize.add(list);
                }
                subp.remove("background-size");
                return true;
            }
            return false;
        }

        private boolean testIdentifierProperty(int layer, Set<String> subp, String subpropertyName, DOMCSSValueList lst) {
            if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subpropertyName)) {
                AbstractCSSValue value = this.createCSSValue(subpropertyName, this.currentValue);
                lst.add(value);
                return true;
            }
            return false;
        }
    }

    class BorderImageShorthandSetter
    extends ShorthandSetter {
        BorderImageShorthandSetter() {
            super("border-image");
        }

        @Override
        public void init(LexicalUnit shorthandValue, String priority) {
            this.currentValue = shorthandValue;
            this.setPriority(priority);
        }

        @Override
        public void assignSubproperties() {
            boolean bisourceUnset = true;
            boolean bisliceUnset = true;
            boolean biwidthUnset = true;
            boolean bioutsetUnset = true;
            boolean birepeatUnset = true;
            while (this.currentValue != null) {
                int c;
                short lut = this.currentValue.getLexicalUnitType();
                if (lut == 24) {
                    this.setSubpropertyValue("border-image-source", this.createCSSValue("border-image-source", this.currentValue));
                    bisourceUnset = false;
                    this.nextCurrentValue();
                    continue;
                }
                if (lut == 35) {
                    if (this.testIdentifiers("border-image-repeat")) {
                        this.setSubpropertyValue("border-image-repeat", this.createCSSValue("border-image-repeat", this.currentValue));
                        birepeatUnset = false;
                    } else if ("auto".equals(this.currentValue.getStringValue())) {
                        this.setSubpropertyValue("border-image-width", this.createCSSValue("border-image-width", this.currentValue));
                        biwidthUnset = false;
                    } else {
                        CSSStyleDeclarationRule prule = BaseCSSStyleDeclaration.this.getParentRule();
                        if (prule != null) {
                            prule.getStyleDeclarationErrorHandler().unknownIdentifier("border-image", this.currentValue.getStringValue());
                        }
                    }
                    this.nextCurrentValue();
                    continue;
                }
                if (!AbstractCSSPrimitiveValue.isNumericSACUnitType(lut)) continue;
                DOMCSSValueList list = DOMCSSValueList.createWSValueList();
                do {
                    list.add(this.createCSSValue("border-image-slice", this.currentValue));
                    this.nextCurrentValue();
                } while (this.currentValue != null && (lut = this.currentValue.getLexicalUnitType()) != 4 && lut != 35);
                this.setSubpropertyValue("border-image-slice", list);
                bisliceUnset = false;
                if (this.currentValue == null) continue;
                if (lut == 35) {
                    if (!"fill".equals(this.currentValue.getStringValue())) continue;
                    list.add(this.createCSSValue("border-image-slice", this.currentValue));
                    this.nextCurrentValue();
                    if (this.currentValue == null) break;
                    lut = this.currentValue.getLexicalUnitType();
                }
                if (lut != 4) continue;
                this.nextCurrentValue();
                lut = this.currentValue.getLexicalUnitType();
                if (lut == 4) {
                    this.nextCurrentValue();
                    if (!AbstractCSSPrimitiveValue.isNumericSACUnitType(this.currentValue.getLexicalUnitType())) break;
                    list = DOMCSSValueList.createWSValueList();
                    c = 0;
                    while (AbstractCSSPrimitiveValue.isNumericSACUnitType(this.currentValue.getLexicalUnitType())) {
                        list.add(this.createCSSValue("border-image-outset", this.currentValue));
                        this.nextCurrentValue();
                        c = (byte)(c + 1);
                        if (this.currentValue != null && c < 4) continue;
                    }
                    if (list.getLength() == 0) continue;
                    this.setSubpropertyValue("border-image-outset", list);
                    bioutsetUnset = false;
                    continue;
                }
                if (lut == 35) {
                    if (!"auto".equals(this.currentValue.getStringValue())) continue;
                    this.setSubpropertyValue("border-image-width", this.createCSSValue("border-image-width", this.currentValue));
                    biwidthUnset = false;
                    this.nextCurrentValue();
                    continue;
                }
                c = 0;
                list = DOMCSSValueList.createWSValueList();
                while (AbstractCSSPrimitiveValue.isNumericSACUnitType(lut)) {
                    list.add(this.createCSSValue("border-image-width", this.currentValue));
                    this.nextCurrentValue();
                    if (this.currentValue == null) break;
                    lut = this.currentValue.getLexicalUnitType();
                    c = (byte)(c + 1);
                    if (lut != 4 && lut != 35 && c < 4) continue;
                }
                if (list.getLength() != 0) {
                    this.setSubpropertyValue("border-image-width", list);
                    biwidthUnset = false;
                }
                if (lut != 4) continue;
                this.nextCurrentValue();
                if (this.currentValue == null) break;
                lut = this.currentValue.getLexicalUnitType();
                list = DOMCSSValueList.createWSValueList();
                while (AbstractCSSPrimitiveValue.isNumericSACUnitType(lut) && c < 4) {
                    list.add(this.createCSSValue("border-image-outset", this.currentValue));
                    this.nextCurrentValue();
                    if (this.currentValue == null) break;
                    lut = this.currentValue.getLexicalUnitType();
                    c = (byte)(c + 1);
                }
                if (list.getLength() == 0) continue;
                this.setSubpropertyValue("border-image-outset", list);
                bioutsetUnset = false;
            }
            if (bisourceUnset) {
                this.setSubpropertyValue("border-image-source", BaseCSSStyleDeclaration.this.defaultPropertyValue("border-image-source"));
            }
            if (bisliceUnset) {
                this.setSubpropertyValue("border-image-slice", BaseCSSStyleDeclaration.this.defaultPropertyValue("border-image-slice"));
            }
            if (biwidthUnset) {
                this.setSubpropertyValue("border-image-width", BaseCSSStyleDeclaration.this.defaultPropertyValue("border-image-width"));
            }
            if (bioutsetUnset) {
                this.setSubpropertyValue("border-image-outset", BaseCSSStyleDeclaration.this.defaultPropertyValue("border-image-outset"));
            }
            if (birepeatUnset) {
                this.setSubpropertyValue("border-image-repeat", BaseCSSStyleDeclaration.this.defaultPropertyValue("border-image-repeat"));
            }
        }
    }

    class BorderShorthandSetter
    extends ShorthandSetter {
        BorderShorthandSetter() {
            super("border");
        }

        @Override
        protected boolean assignSubproperty(String subproperty) {
            if ("border-width".equals(subproperty)) {
                short utype = this.currentValue.getLexicalUnitType();
                if (35 == utype && this.testIdentifiers(subproperty) || AbstractCSSPrimitiveValue.isNumericSACUnitType(utype)) {
                    AbstractCSSValue cssValue = this.createCSSValue("border-width", this.currentValue);
                    String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                    int i = 0;
                    while (i < subparray.length) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                        ++i;
                    }
                    this.nextCurrentValue();
                    return true;
                }
            } else if ("border-style".equals(subproperty)) {
                short utype = this.currentValue.getLexicalUnitType();
                if (35 == utype && this.testIdentifiers(subproperty)) {
                    AbstractCSSValue cssValue = this.createCSSValue("border-style", this.currentValue);
                    String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                    int i = 0;
                    while (i < subparray.length) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                        ++i;
                    }
                    this.nextCurrentValue();
                    return true;
                }
            } else if ("border-color".equals(subproperty) && this.testColor(subproperty)) {
                AbstractCSSValue cssValue = this.createCSSValue("border-color", this.currentValue);
                String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                int i = 0;
                while (i < subparray.length) {
                    this.setSubpropertyValue(subparray[i], cssValue);
                    ++i;
                }
                this.currentValue = null;
                return true;
            }
            return false;
        }
    }

    class BorderSideShorthandSetter
    extends ShorthandSetter {
        private String pnameWidth;
        private String pnameStyle;
        private String pnameColor;

        BorderSideShorthandSetter(String shorthandName, String side) {
            super(shorthandName);
            this.pnameWidth = "border-" + side + "-width";
            this.pnameStyle = "border-" + side + "-style";
            this.pnameColor = "border-" + side + "-color";
        }

        @Override
        protected boolean assignSubproperty(String subproperty) {
            if (this.pnameWidth.equals(subproperty)) {
                short utype = this.currentValue.getLexicalUnitType();
                if (35 == utype && this.testIdentifiers("border-width") || AbstractCSSPrimitiveValue.isNumericSACUnitType(utype)) {
                    AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.nextCurrentValue();
                    return true;
                }
            } else if (this.pnameStyle.equals(subproperty)) {
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("border-style")) {
                    AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.nextCurrentValue();
                    return true;
                }
            } else if (this.pnameColor.equals(subproperty) && this.testColor(subproperty)) {
                AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.currentValue = null;
                return true;
            }
            return false;
        }
    }

    class BoxShorthandSetter
    extends ShorthandSetter {
        BoxShorthandSetter(String shorthand) {
            super(shorthand);
        }

        @Override
        public void assignSubproperties() {
            String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
            switch (this.getPropertyCount()) {
                case 1: {
                    AbstractCSSValue cssValue = this.createCSSValue(this.getShorthandName(), this.currentValue);
                    int i = 0;
                    while (i < subparray.length) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    AbstractCSSValue cssValue = this.createCSSValue(subparray[0], this.currentValue);
                    this.setSubpropertyValue(subparray[0], cssValue);
                    this.setSubpropertyValue(subparray[2], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(subparray[1], this.currentValue);
                    this.setSubpropertyValue(subparray[1], cssValue);
                    this.setSubpropertyValue(subparray[3], cssValue);
                    break;
                }
                case 3: {
                    AbstractCSSValue cssValue = this.createCSSValue(subparray[0], this.currentValue);
                    this.setSubpropertyValue(subparray[0], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(subparray[1], this.currentValue);
                    this.setSubpropertyValue(subparray[1], cssValue);
                    this.setSubpropertyValue(subparray[3], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(subparray[2], this.currentValue);
                    this.setSubpropertyValue(subparray[2], cssValue);
                    break;
                }
                case 4: {
                    int i = 0;
                    while (i < subparray.length) {
                        AbstractCSSValue cssValue = this.createCSSValue(subparray[i], this.currentValue);
                        this.setSubpropertyValue(subparray[i], cssValue);
                        this.nextCurrentValue();
                        ++i;
                    }
                    break;
                }
                default: {
                    CSSStyleDeclarationRule prule = BaseCSSStyleDeclaration.this.getParentRule();
                    if (prule == null) break;
                    prule.getStyleDeclarationErrorHandler().wrongSubpropertyCount(this.getShorthandName(), this.getPropertyCount());
                }
            }
        }
    }

    class FontShorthandSetter
    extends ShorthandSetter {
        private LexicalUnit nextLex;

        FontShorthandSetter() {
            super("font");
            this.nextLex = null;
        }

        @Override
        protected void nextCurrentValue() {
            super.nextCurrentValue();
            this.nextLex = this.currentValue != null ? this.currentValue.getNextLexicalUnit() : null;
        }

        @Override
        protected boolean assignSubproperty(String subproperty) {
            if (subproperty.equals("font-size") && this.assignFontSize()) {
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 4) {
                    this.nextCurrentValue();
                    AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                    this.setProperty("line-height", cssValue, this.getPriority());
                }
                this.nextCurrentValue();
                return true;
            }
            switch (this.currentValue.getLexicalUnitType()) {
                case 35: {
                    if (super.assignSubproperty(subproperty)) {
                        return true;
                    }
                    if (!subproperty.equals("font-family")) break;
                    boolean is_set = false;
                    while (this.currentValue != null && (this.nextLex == null || this.nextLex.getLexicalUnitType() == 0)) {
                        AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                        if (cssValue != null) {
                            this.addSubpropertyValue(subproperty, cssValue);
                            is_set = true;
                        }
                        this.nextCurrentValue();
                    }
                    if (is_set) {
                        this.currentValue = null;
                        this.nextLex = null;
                    }
                    return is_set;
                }
                case 36: {
                    if (!subproperty.equals("font-family")) break;
                    boolean is_set = false;
                    while (this.currentValue != null && (this.nextLex == null || this.nextLex.getLexicalUnitType() == 0)) {
                        AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                        if (cssValue != null) {
                            this.addSubpropertyValue(subproperty, cssValue);
                            is_set = true;
                        }
                        this.nextCurrentValue();
                    }
                    return is_set;
                }
            }
            return false;
        }

        protected boolean assignFontSize() {
            if (this.currentValue.getLexicalUnitType() == 35) {
                return super.assignSubproperty("font-size");
            }
            AbstractCSSValue cssValue = this.createCSSValue("font-size", this.currentValue);
            if (cssValue instanceof CSSNumberValue) {
                this.setSubpropertyValue("font-size", cssValue);
                this.nextCurrentValue();
                return true;
            }
            return false;
        }
    }

    class ShorthandSetter
    implements SubpropertySetter {
        private String shorthandName;
        private String priority = null;
        private PropertyDatabase pdb = PropertyDatabase.getInstance();
        protected LexicalUnit currentValue = null;
        private short valueCount = 0;
        private short propertyCount = 0;
        protected short lookupCount = 0;
        private StringBuilder valueBuffer = new StringBuilder(32);
        private ArrayList<String> unassignedProperties = new ArrayList(6);
        private List<LexicalUnit> unassignedValues = new ArrayList<LexicalUnit>(8);

        ShorthandSetter(String shorthandName) {
            this.shorthandName = shorthandName;
        }

        public String getShorthandName() {
            return this.shorthandName;
        }

        public String getPriority() {
            return this.priority;
        }

        protected void setPriority(String priority) {
            this.priority = priority;
        }

        public final PropertyDatabase getPropertyDatabase() {
            return this.pdb;
        }

        public short getValueCount() {
            return this.valueCount;
        }

        public short getPropertyCount() {
            return this.propertyCount;
        }

        protected void addUnassignedProperty(String propertyName) {
            this.unassignedProperties.add(propertyName);
            int sz = this.unassignedValues.size();
            if (sz > 0 && !this.unassignedValues.get(sz - 1).equals(this.currentValue)) {
                this.unassignedValues.add(this.currentValue);
            }
        }

        protected List<String> getUnassignedProperties() {
            return this.unassignedProperties;
        }

        protected void nextCurrentValue() {
            if (this.currentValue != null) {
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 0) {
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                }
                this.appendValueString();
            }
        }

        @Override
        public void init(LexicalUnit shorthandValue, String priority) {
            this.currentValue = shorthandValue;
            this.setPriority(priority);
            this.unassignedValues.clear();
            this.initValueString();
            this.appendValueString();
            this.countValues(shorthandValue);
        }

        protected void countValues(LexicalUnit shorthandValue) {
            this.valueCount = 0;
            this.propertyCount = 0;
            LexicalUnit value = shorthandValue;
            while (value != null) {
                this.valueCount = (short)(this.valueCount + 1);
                this.propertyCount = value.getLexicalUnitType() != 0 ? (short)(this.propertyCount + 1) : (short)(this.propertyCount - 1);
                value = value.getNextLexicalUnit();
            }
        }

        protected void resetSubproperties() {
            List<String> props = this.getUnassignedProperties();
            for (String pname : props) {
                if (!this.getPropertyDatabase().isShorthand(pname)) {
                    this.setPropertyDefault(pname);
                    continue;
                }
                String[] sh = this.getPropertyDatabase().getShorthandSubproperties(pname);
                int i = 0;
                while (i < sh.length) {
                    this.setPropertyDefault(sh[i]);
                    ++i;
                }
            }
        }

        private void setPropertyDefault(String pname) {
            ExtendedCSSValue cssVal = BaseCSSStyleDeclaration.this.defaultPropertyValue(pname);
            if (cssVal != null) {
                ((AbstractCSSPrimitiveValue)cssVal).setSubproperty(true);
                this.setProperty(pname, cssVal, this.getPriority());
            } else {
                CSSStyleDeclarationRule prule = BaseCSSStyleDeclaration.this.getParentRule();
                if (prule != null) {
                    prule.getStyleDeclarationErrorHandler().noDefault(pname);
                }
            }
        }

        @Override
        public void assignSubproperties() {
            String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
            ArrayList<String> subp = new ArrayList<String>(subparray.length);
            subp.addAll(Arrays.asList((String[])subparray.clone()));
            block0: while (this.currentValue != null && this.lookupCount <= this.getValueCount()) {
                this.unassignedProperties.clear();
                int i = 0;
                while (i < subp.size()) {
                    String pname = (String)subp.get(i);
                    if (this.currentValue == null) continue block0;
                    if (!this.assignSubproperty(pname)) {
                        this.addUnassignedProperty(pname);
                    } else {
                        subp.remove(i);
                        --i;
                    }
                    this.lookupCount = (short)(this.lookupCount + 1);
                    ++i;
                }
            }
            if (subp.size() > 0) {
                Iterator it = subp.iterator();
                while (it.hasNext()) {
                    this.addUnassignedProperty((String)it.next());
                }
            }
            this.resetSubproperties();
        }

        protected boolean assignSubproperty(String subproperty) {
            return 35 == this.currentValue.getLexicalUnitType() && this.assignIdentifiers(subproperty);
        }

        protected boolean assignIdentifiers(String subproperty) {
            if (this.testIdentifiers(subproperty)) {
                AbstractCSSValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.nextCurrentValue();
                return true;
            }
            return false;
        }

        protected boolean testIdentifiers(String subproperty) {
            return this.getPropertyDatabase().isIdentifierValue(subproperty, this.currentValue.getStringValue());
        }

        protected void setSubpropertyValue(String subproperty, ExtendedCSSValue cssValue) {
            this.setProperty(subproperty, cssValue, this.getPriority());
            int szm1 = this.unassignedValues.size() - 1;
            if (szm1 >= 0) {
                CSSStyleDeclarationRule prule;
                if (this.unassignedValues.get(szm1).equals(this.currentValue)) {
                    this.unassignedValues.remove(szm1);
                    --szm1;
                }
                if (szm1 >= 0 && (prule = BaseCSSStyleDeclaration.this.getParentRule()) != null) {
                    prule.getStyleDeclarationErrorHandler().unassignedSubproperties(this.getShorthandName(), this.unassignedProperties.toArray(new String[0]));
                }
            }
        }

        protected void addSubpropertyValue(String subproperty, ExtendedCSSValue cssValue) {
            ExtendedCSSValue cssval = BaseCSSStyleDeclaration.this.getDeclaredCSSValue(subproperty);
            if (cssval == null) {
                this.setSubpropertyValue(subproperty, cssValue);
            } else {
                switch (cssval.getCssValueType()) {
                    case 2: {
                        ((DOMCSSValueList)cssval).add(cssValue);
                        cssValue = cssval;
                        break;
                    }
                    default: {
                        DOMCSSValueList list = DOMCSSValueList.createCSValueList();
                        list.add(cssval);
                        list.add(cssValue);
                        cssValue = list;
                    }
                }
                this.setProperty(subproperty, cssValue, this.getPriority());
            }
        }

        protected void setProperty(String subpropertyName, ExtendedCSSValue cssValue, String priority) {
            BaseCSSStyleDeclaration.this.setProperty(subpropertyName, cssValue, priority);
        }

        public AbstractCSSValue createCSSValue(String propertyName, LexicalUnit lunit) {
            try {
                return AbstractCSSValue.createCSSValueItem(lunit, true);
            }
            catch (DOMException e) {
                CSSStyleDeclarationRule prule = BaseCSSStyleDeclaration.this.getParentRule();
                if (prule != null) {
                    CSSPropertyValueException ex = new CSSPropertyValueException(e.getMessage());
                    ex.setStackTrace(e.getStackTrace());
                    prule.getStyleDeclarationErrorHandler().wrongValue(propertyName, ex);
                }
                return null;
            }
        }

        protected void initValueString() {
            this.valueBuffer.setLength(0);
        }

        protected void appendValueString(CSSValue cssValue) {
            if (cssValue != null) {
                String cssText = cssValue.getCssText();
                if (this.valueBuffer.length() > 0) {
                    this.valueBuffer.append(' ');
                }
                this.valueBuffer.append(cssText);
            }
        }

        protected void appendValueString() {
            if (this.currentValue != null) {
                AbstractCSSValue currentCss = AbstractCSSValue.createCSSValueItem(this.currentValue, true);
                this.appendValueString(currentCss);
            }
        }

        @Override
        public String getCssText() {
            return this.valueBuffer.toString();
        }

        protected boolean testColor(String subproperty) {
            String func;
            short utype = this.currentValue.getLexicalUnitType();
            if (35 == utype) {
                return this.getPropertyDatabase().isIdentifierValue(subproperty, this.currentValue.getStringValue());
            }
            if (27 == utype) {
                return true;
            }
            if (36 == utype && this.currentValue.getStringValue().charAt(0) == '#') {
                return true;
            }
            return 41 == utype && ("rgba".equals(func = this.currentValue.getFunctionName()) || "hsla".equals(func) || "hsl".equals(func));
        }
    }

    public class StyleDeclarationDocumentHandler
    extends PropertyDocumentHandler
    implements ErrorHandler {
        @Override
        public void startSelector(SelectorList selectors) throws CSSException {
            BaseCSSStyleDeclaration.this.parentRule.setSelectorList(selectors);
        }

        public void warning(CSSParseException exception) throws CSSException {
            if (BaseCSSStyleDeclaration.this.getParentRule() != null && BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().sacWarning(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }

        public void error(CSSParseException exception) throws CSSException {
            if (BaseCSSStyleDeclaration.this.getParentRule() != null && BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().sacError(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            if (BaseCSSStyleDeclaration.this.getParentRule() != null && BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler() != null) {
                BaseCSSStyleDeclaration.this.getParentRule().getStyleDeclarationErrorHandler().sacFatalError(exception, BaseCSSStyleDeclaration.this.propertyList.size() - 1);
            }
        }
    }

    static interface SubpropertySetter {
        public void init(LexicalUnit var1, String var2);

        public void assignSubproperties();

        public String getCssText();
    }

    class TransitionShorthandSetter
    extends ShorthandSetter {
        private String cssText;
        private int transitionsCount;
        private DOMCSSValueList lstProperty;
        private DOMCSSValueList lstDuration;
        private DOMCSSValueList lstTiming;
        private DOMCSSValueList lstDelay;

        TransitionShorthandSetter() {
            super("transition");
            this.cssText = null;
            this.transitionsCount = 0;
            this.lstProperty = DOMCSSValueList.createCSValueList();
            this.lstDuration = DOMCSSValueList.createCSValueList();
            this.lstTiming = DOMCSSValueList.createCSValueList();
            this.lstDelay = DOMCSSValueList.createCSValueList();
        }

        @Override
        public void init(LexicalUnit shorthandValue, String priority) {
            this.currentValue = shorthandValue;
            this.setPriority(priority);
            this.setCssText(shorthandValue);
            this.countTransitions(shorthandValue);
        }

        private void setCssText(LexicalUnit value) {
            StringBuilder valueBuffer = new StringBuilder(32);
            do {
                AbstractCSSValue cssValue;
                if ((cssValue = AbstractCSSValue.createCSSValueItem(value, true)) == null) continue;
                String cssText = cssValue.getCssText();
                if (valueBuffer.length() > 0) {
                    valueBuffer.append(' ');
                }
                valueBuffer.append(cssText);
            } while ((value = value.getNextLexicalUnit()) != null);
            this.cssText = valueBuffer.toString();
        }

        @Override
        public String getCssText() {
            return this.cssText;
        }

        protected void countTransitions(LexicalUnit shorthandValue) {
            this.transitionsCount = 0;
            int valueCount = 0;
            LexicalUnit value = shorthandValue;
            while (value != null) {
                if (value.getLexicalUnitType() == 0) {
                    if (valueCount > 0) {
                        ++this.transitionsCount;
                        valueCount = 0;
                    }
                } else {
                    ++valueCount;
                }
                value = value.getNextLexicalUnit();
            }
            if (valueCount > 0) {
                ++this.transitionsCount;
            }
        }

        @Override
        public void assignSubproperties() {
            int i = 0;
            while (i < this.transitionsCount && this.currentValue != null) {
                boolean tpropUnset = true;
                boolean tdurUnset = true;
                boolean ttfUnset = true;
                boolean tdelayUnset = true;
                while (this.currentValue != null) {
                    AbstractCSSValue value;
                    short lut = this.currentValue.getLexicalUnitType();
                    if (lut == 0) {
                        ++i;
                        this.nextCurrentValue();
                        break;
                    }
                    if ((tdurUnset || tdelayUnset) && AbstractCSSPrimitiveValue.isTimeSACUnitType(lut)) {
                        if (tdurUnset) {
                            value = this.createCSSValue("transition-duration", this.currentValue);
                            if (value != null) {
                                this.lstDuration.add(value);
                                tdurUnset = false;
                                this.nextCurrentValue();
                                continue;
                            }
                        } else {
                            value = this.createCSSValue("transition-delay", this.currentValue);
                            if (value != null) {
                                this.lstDelay.add(value);
                                tdelayUnset = false;
                                this.nextCurrentValue();
                                continue;
                            }
                        }
                    }
                    if (ttfUnset) {
                        if (35 == lut && this.testIdentifiers("transition-timing-function")) {
                            value = this.createCSSValue("transition-timing-function", this.currentValue);
                            this.lstTiming.add(value);
                            ttfUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                        if (lut == 41 && (value = this.createCSSValue("transition-timing-function", this.currentValue)) != null) {
                            this.lstTiming.add(value);
                            ttfUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                    }
                    if (tpropUnset && (lut == 35 || lut == 36)) {
                        this.lstProperty.add(this.createCSSValue("transition-property", this.currentValue));
                        tpropUnset = false;
                        this.nextCurrentValue();
                        continue;
                    }
                    CSSStyleDeclarationRule prule = BaseCSSStyleDeclaration.this.getParentRule();
                    if (prule != null) {
                        if (lut == 35) {
                            prule.getStyleDeclarationErrorHandler().unknownIdentifier("transition", this.currentValue.getStringValue());
                        } else {
                            AbstractCSSValue val = this.createCSSValue("transition", this.currentValue);
                            prule.getStyleDeclarationErrorHandler().unassignedSubpropertyValue("transition", val.getCssText());
                        }
                    }
                    this.nextCurrentValue();
                }
                if (tpropUnset) {
                    this.lstProperty.add(BaseCSSStyleDeclaration.this.defaultPropertyValue("transition-property"));
                }
                if (tdurUnset) {
                    if (i == 0) {
                        this.lstDuration.add(BaseCSSStyleDeclaration.this.defaultPropertyValue("transition-duration"));
                    } else {
                        this.lstDuration.add(this.lstDuration.item(0));
                    }
                }
                if (ttfUnset) {
                    if (i == 0) {
                        this.lstTiming.add(BaseCSSStyleDeclaration.this.defaultPropertyValue("transition-timing-function"));
                    } else {
                        this.lstTiming.add(this.lstTiming.item(0));
                    }
                }
                if (!tdelayUnset) continue;
                if (i == 0) {
                    this.lstDelay.add(BaseCSSStyleDeclaration.this.defaultPropertyValue("transition-delay"));
                    continue;
                }
                this.lstDelay.add(this.lstDelay.item(0));
            }
            this.setSubpropertyValue("transition-property", this.lstProperty);
            this.setSubpropertyValue("transition-duration", this.lstDuration);
            this.setSubpropertyValue("transition-timing-function", this.lstTiming);
            this.setSubpropertyValue("transition-delay", this.lstDelay);
        }

        @Override
        protected void nextCurrentValue() {
            this.currentValue = this.currentValue.getNextLexicalUnit();
            this.appendValueString();
        }
    }
}

