/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.dom.AbstractCSSRule;
import info.informatica.doc.style.css.dom.AbstractCSSStyleSheet;
import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.DOMCSSImportRule;
import info.informatica.doc.style.css.dom.DOMCSSMediaRule;
import info.informatica.doc.style.css.dom.DOMMediaList;

public abstract class BaseDocumentCSSStyleSheet
extends BaseCSSStyleSheet {
    private String targetMedium = null;

    protected BaseDocumentCSSStyleSheet(CSSStyleSheetFactory factory, String medium) {
        super(factory, null, DOMMediaList.createUnmodifiable(medium), null);
        this.targetMedium = "all".equals(medium) ? null : medium;
    }

    @Override
    public void setHref(String href) {
        throw new IllegalStateException("Document sheet's href is parent document href");
    }

    @Override
    public String getHref() {
        return this.getOwnerNode().getBaseURI();
    }

    public void addStyleSheet(AbstractCSSStyleSheet sheet) {
        if (!sheet.getDisabled()) {
            DOMMediaList mediaList = sheet.getMedia();
            if (mediaList.getLength() == 0) {
                CSSRuleArrayList otherRules = sheet.getCssRules();
                int orl = otherRules.getLength();
                int i = 0;
                while (i < orl) {
                    this.addLocalRule(otherRules.item(i));
                    ++i;
                }
            } else {
                DOMCSSMediaRule mrule = this.createCSSMediaRule(mediaList);
                CSSRuleArrayList otherRules = sheet.getCssRules();
                int orl = otherRules.getLength();
                int i = 0;
                while (i < orl) {
                    AbstractCSSRule orule = ((AbstractCSSRule)otherRules.item(i)).clone(this, i);
                    orule.setParentRule(mrule);
                    mrule.addRule(orule);
                    ++i;
                }
                this.addLocalRule(mrule);
            }
        }
    }

    protected void copyTo(BaseDocumentCSSStyleSheet myCopy) {
        if (myCopy.getTargetMedium() == null) {
            throw new NullPointerException();
        }
        if (!this.getMedia().matchMedium(myCopy.getTargetMedium())) {
            throw new IllegalArgumentException("Incompatible target medium: " + this.targetMedium);
        }
        myCopy.currentInsertionIndex = this.currentInsertionIndex;
        myCopy.setDisabled(this.getDisabled());
        myCopy.namespaces = this.namespaces;
        myCopy.setParentStyleSheet(this.getParentStyleSheet());
        myCopy.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        for (AbstractCSSRule rule : this.cssRules) {
            short type = rule.getType();
            if (type == 4 && !((DOMCSSMediaRule)rule).getMedia().matchMedium(this.targetMedium) || type == 3 && !((DOMCSSImportRule)rule).getMedia().matchMedium(this.targetMedium)) continue;
            myCopy.cssRules.add(rule.clone(myCopy, i++));
        }
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }
}

