/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.dom.AbstractCSSRule;
import info.informatica.doc.style.css.dom.RuleStore;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public class CSSRuleArrayList
extends ArrayList<AbstractCSSRule>
implements CSSRuleList,
RuleStore {
    private static final long serialVersionUID = 1L;

    public CSSRuleArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public CSSRuleArrayList() {
    }

    public CSSRuleArrayList(Collection<? extends AbstractCSSRule> c) {
        super(c);
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public AbstractCSSRule item(int index) {
        if (index >= this.getLength() || index < 0) {
            return null;
        }
        return (AbstractCSSRule)this.get(index);
    }

    @Override
    public int insertRule(CSSRule cssrule, int index) {
        if (index >= this.size()) {
            index = this.size();
        } else if (index < 0) {
            index = 0;
        }
        this.add(index, (AbstractCSSRule)cssrule);
        ((AbstractCSSRule)cssrule).setInsertionIndex(index);
        int i = index + 1;
        while (i < this.size()) {
            ((AbstractCSSRule)this.get(i)).setInsertionIndex(i);
            ++i;
        }
        return index;
    }

    @Override
    public boolean add(AbstractCSSRule o) {
        o.setInsertionIndex(this.size());
        return super.add(o);
    }

    public String toMinifiedString() {
        int sz = this.size();
        StringBuilder sb = new StringBuilder(sz * 20);
        int i = 0;
        while (i < sz) {
            sb.append(this.item(i).getMinifiedCssText());
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        int sz = this.size();
        StringBuilder sb = new StringBuilder(sz * 20);
        int i = 0;
        while (i < sz) {
            sb.append(this.item(i).getCssText()).append('\n');
            ++i;
        }
        return sb.toString();
    }
}

