/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.agent.CSSCanvas;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.CSSDocument;
import info.informatica.doc.style.css.StyleDatabaseAware;
import info.informatica.doc.style.css.dom.BaseCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.CSSStyleDeclarationRule;
import info.informatica.doc.style.css.property.AbstractCSSPrimitiveValue;
import info.informatica.doc.style.css.property.AbstractCSSValue;
import info.informatica.doc.style.css.property.CSSIdentifierValue;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.property.CSSStringValue;
import info.informatica.doc.style.css.property.CSSStringValueWrapper;
import info.informatica.doc.style.css.property.ExtendedCSSValue;
import info.informatica.doc.style.css.property.PropertyDatabase;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValueList;

public abstract class ComputedCSSStyle
extends BaseCSSStyleDeclaration
implements CSS2ComputedProperties,
StyleDatabaseAware {
    private Node node = null;

    protected ComputedCSSStyle() {
    }

    protected ComputedCSSStyle(BaseCSSStyleDeclaration copiedObject) {
        super(copiedObject);
    }

    public void setPeerNode(Node node) {
        this.node = node;
    }

    @Override
    public Node getOwnerNode() {
        return this.node;
    }

    @Override
    protected void setPropertyCSSValue(String propertyName, ExtendedCSSValue value, CSSStyleDeclarationRule parentRule) {
        if ("background-image".equals(propertyName)) {
            value = new CSSStringValueWrapper((CSSStringValue)value, parentRule.getParentStyleSheet().getHref());
        }
        super.setPropertyCSSValue(propertyName, value, parentRule);
    }

    @Override
    public ExtendedCSSValue getCSSValue(String property) {
        ExtendedCSSValue value = super.getCSSValue(property);
        boolean inherited = PropertyDatabase.getInstance().isInherited(property);
        CSS2ComputedProperties ancStyle = this;
        while (!(value == null ? !inherited : value.getCssValueType() != 0)) {
            if ((ancStyle = ancStyle.getParentComputedStyle()) == null) break;
            value = (ExtendedCSSValue)ancStyle.getPropertyCSSValue(property);
        }
        if (value != null && value.getCssValueType() == 0) {
            value = null;
        }
        if (value == null) {
            value = this.defaultPropertyValue(property);
        }
        if (value != null) {
            if (property.equalsIgnoreCase("font-family")) {
                int i;
                CSSStringValue fontFamily;
                CSSValueList fontList = null;
                if (value.getCssValueType() == 2) {
                    fontList = (CSSValueList)((Object)value);
                    fontFamily = (CSSStringValue)fontList.item(0);
                    i = 1;
                } else {
                    fontFamily = (CSSStringValue)value;
                    i = 0;
                }
                ancStyle = this;
                String requestedFamily = fontFamily.getStringValue();
                while (!this.isFontFamilyAvailable(requestedFamily)) {
                    if (i > 0 && i < fontList.getLength()) {
                        fontFamily = (CSSStringValue)fontList.item(i);
                        ++i;
                    } else {
                        ancStyle = ancStyle.getParentComputedStyle();
                        while (ancStyle != null) {
                            value = ((BaseCSSStyleDeclaration)((Object)ancStyle)).getDeclaredCSSValue(property);
                            if (value == null) {
                                fontFamily = null;
                                break;
                            }
                            if (value.getCssValueType() == 2) {
                                fontList = (CSSValueList)((Object)value);
                                fontFamily = (CSSStringValue)fontList.item(0);
                                i = 1;
                            } else {
                                fontFamily = (CSSStringValue)value;
                                i = 0;
                            }
                            if (value != null) break;
                        }
                        if (fontFamily == null) break;
                    }
                    requestedFamily = fontFamily.getStringValue();
                }
                if (fontFamily == null) {
                    requestedFamily = this.getStyleDatabase().getDefaultGenericFontFamily();
                }
                value = new CSSIdentifierValue();
                ((CSSIdentifierValue)value).setStringValue((short)19, requestedFamily);
                ((StyleDatabaseAware)((Object)value)).setStyleDatabase(this.getStyleDatabase());
            } else {
                if (value instanceof StyleDatabaseAware) {
                    ((StyleDatabaseAware)((Object)value)).setStyleDatabase(this.getStyleDatabase());
                }
                value = this.applyConstrains(property, value);
            }
        }
        return value;
    }

    private ExtendedCSSValue applyConstrains(String property, ExtendedCSSValue value) {
        ExtendedCSSValue computedValue = value;
        if ("display".equals(property)) {
            if (value.getCssValueType() != 1) {
                return value;
            }
            String strVal = ((CSSPrimitiveValue)((Object)value)).getStringValue();
            if (!"none".equals(strVal)) {
                String position = ((CSSPrimitiveValue)((Object)this.getCSSValue("position"))).getStringValue();
                if ("absolute".equals(position) || "fixed".equals(position)) {
                    computedValue = this.computeConstrainedDisplay(value);
                } else {
                    String floatProp = ((CSSPrimitiveValue)((Object)this.getCSSValue("float"))).getStringValue();
                    if (!"none".equals(floatProp)) {
                        computedValue = this.computeConstrainedDisplay(value);
                    }
                }
            }
        }
        return computedValue;
    }

    private ExtendedCSSValue computeConstrainedDisplay(ExtendedCSSValue value) {
        String display = ((CSSPrimitiveValue)((Object)value)).getStringValue();
        if ("inline-table".equals(display)) {
            return AbstractCSSValue.parseProperty("table");
        }
        if ("inline".equals(display) || "run-in".equals(display) || "table-row-group".equals(display) || "table-column".equals(display) || "table-column-group".equals(display) || "table-header-group".equals(display) || "table-footer-group".equals(display) || "table-row".equals(display) || "table-cell".equals(display) || "table-caption".equals(display) || "inline-block".equals(display)) {
            return AbstractCSSValue.parseProperty("block");
        }
        return value;
    }

    @Override
    public AbstractCSSPrimitiveValue getCSSColor() {
        return (AbstractCSSPrimitiveValue)this.getCSSValue("color");
    }

    @Override
    public CSSPrimitiveValue getCSSBackgroundColor() {
        return (CSSPrimitiveValue)((Object)this.getCSSValue("background-color"));
    }

    @Override
    public String[] getBackgroundImages() {
        ExtendedCSSValue cssVal = this.getCSSValue("background-image");
        if (cssVal == null) {
            return null;
        }
        if (cssVal.getCssValueType() == 1) {
            return new String[]{this.getHref((CSSPrimitiveValue)((Object)cssVal))};
        }
        CSSValueList list = (CSSValueList)((Object)cssVal);
        int len = list.getLength();
        String[] sa = new String[len];
        int i = 0;
        while (i < len) {
            sa[i] = this.getHref((CSSPrimitiveValue)list.item(i));
            ++i;
        }
        return sa;
    }

    public String getHref(CSSPrimitiveValue cssVal) {
        String href = cssVal.getStringValue();
        if (!href.contains("://")) {
            String baseHref = null;
            if (cssVal instanceof CSSStringValueWrapper) {
                baseHref = ((CSSStringValueWrapper)cssVal).getParentSheetHref();
            } else {
                CSSStyleDeclarationRule pRule = this.getParentRule();
                if (pRule != null) {
                    baseHref = pRule.getParentStyleSheet().getHref();
                }
            }
            URL baseUrl = null;
            if (baseHref == null) {
                String documentURI = this.getOwnerNode().getBaseURI();
                if (documentURI != null) {
                    try {
                        baseUrl = new URL(documentURI);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else if (!baseHref.contains("://")) {
                try {
                    baseUrl = new URL(new URL(this.getOwnerNode().getBaseURI()), baseHref);
                }
                catch (MalformedURLException e) {
                    this.getParentRule().getStyleDeclarationErrorHandler().malformedURIValue(baseHref);
                }
            } else {
                try {
                    baseUrl = new URL(baseHref);
                }
                catch (MalformedURLException e) {
                    this.getParentRule().getStyleDeclarationErrorHandler().malformedURIValue(baseHref);
                }
            }
            if (baseUrl != null) {
                try {
                    URL url = new URL(baseUrl, href);
                    href = url.toExternalForm();
                }
                catch (MalformedURLException e) {
                    this.getParentRule().getStyleDeclarationErrorHandler().malformedURIValue(href);
                }
            }
        }
        return href;
    }

    @Override
    public String getFontFamily() {
        if (this.getStyleDatabase() == null) {
            throw new IllegalStateException("Style database not set");
        }
        CSSStringValue fontFamily = (CSSStringValue)this.getCSSValue("font-family");
        return fontFamily.getStringValue();
    }

    @Override
    public String getFontWeight() {
        CSSStringValue fontWeight = (CSSStringValue)this.getCSSValue("font-weight");
        return fontWeight.getStringValue();
    }

    @Override
    public int getComputedFontSize() {
        CSSPrimitiveValue cssSize = (CSSPrimitiveValue)((Object)this.getCSSValue("font-size"));
        int sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "medium");
        if (cssSize == null) {
            return sz;
        }
        switch (cssSize.getPrimitiveType()) {
            case 3: {
                float factor = cssSize.getFloatValue((short)3);
                sz = Math.round((float)this.getParentElementFontSize() * factor);
                break;
            }
            case 21: {
                String sizeIdentifier = cssSize.getStringValue();
                try {
                    if ("larger".equalsIgnoreCase(sizeIdentifier)) {
                        sz = this.getLargerFontSize(sz);
                        break;
                    }
                    if ("smaller".equalsIgnoreCase(sizeIdentifier)) {
                        sz = this.getSmallerFontSize(sz);
                        break;
                    }
                    sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, sizeIdentifier);
                }
                catch (DOMException e) {
                    this.getParentRule().getStyleDeclarationErrorHandler().unknownIdentifier("font-size", sizeIdentifier);
                }
                break;
            }
            case 2: {
                float pcnt = cssSize.getFloatValue((short)2);
                sz = Math.round((float)this.getParentElementFontSize() * pcnt / 100.0f);
                break;
            }
            case 9: {
                sz = (int)cssSize.getFloatValue((short)9);
            }
        }
        return sz;
    }

    protected int getLargerFontSize(int defaultSize) {
        CSSPrimitiveValue csssize;
        float sz = (float)defaultSize * 1.2f;
        ComputedCSSStyle parentCss = (ComputedCSSStyle)this.getParentComputedStyle();
        if (parentCss != null && (csssize = (CSSPrimitiveValue)((Object)parentCss.getCSSValue("font-size"))) != null) {
            switch (csssize.getPrimitiveType()) {
                case 21: {
                    String baseFontSize = csssize.getStringValue();
                    if (baseFontSize.equals("xx-small")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-small");
                        break;
                    }
                    if (baseFontSize.equals("x-small")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "small");
                        break;
                    }
                    if (baseFontSize.equals("small")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "medium");
                        break;
                    }
                    if (baseFontSize.equals("medium")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "large");
                        break;
                    }
                    if (baseFontSize.equals("large")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-large");
                        break;
                    }
                    if (baseFontSize.equals("x-large")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "xx-large");
                        break;
                    }
                    if (baseFontSize.equals("xx-large")) {
                        sz = 2.0f * (float)this.getStyleDatabase().getFontSizeFromIdentifier(null, "xx-large") - (float)this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-large");
                        break;
                    }
                    this.getParentRule().getStyleDeclarationErrorHandler().unknownIdentifier("font-size", baseFontSize);
                    break;
                }
                default: {
                    sz = (float)parentCss.getComputedFontSize() * 1.2f;
                }
            }
        }
        return Math.round(sz);
    }

    protected int getSmallerFontSize(int defaultSize) {
        CSSPrimitiveValue csssize;
        float sz = (float)defaultSize * 0.82f;
        ComputedCSSStyle parentCss = (ComputedCSSStyle)this.getParentComputedStyle();
        if (parentCss != null && (csssize = (CSSPrimitiveValue)((Object)parentCss.getCSSValue("font-size"))) != null) {
            switch (csssize.getPrimitiveType()) {
                case 21: {
                    String baseFontSize = csssize.getStringValue();
                    if (baseFontSize.equals("xx-small")) {
                        sz = 2.0f * (float)this.getStyleDatabase().getFontSizeFromIdentifier(null, "xx-small") - (float)this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-small");
                        if (!(sz < 0.1f)) break;
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "xx-small");
                        break;
                    }
                    if (baseFontSize.equals("x-small")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "xx-small");
                        break;
                    }
                    if (baseFontSize.equals("small")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-small");
                        break;
                    }
                    if (baseFontSize.equals("medium")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "small");
                        break;
                    }
                    if (baseFontSize.equals("large")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "medium");
                        break;
                    }
                    if (baseFontSize.equals("x-large")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "large");
                        break;
                    }
                    if (baseFontSize.equals("xx-large")) {
                        sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-large");
                        break;
                    }
                    this.getParentRule().getStyleDeclarationErrorHandler().unknownIdentifier("font-size", baseFontSize);
                    break;
                }
                default: {
                    sz = (float)parentCss.getComputedFontSize() * 0.82f;
                }
            }
        }
        return Math.round(sz);
    }

    protected int getParentElementFontSize() {
        int sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "medium");
        CSS2ComputedProperties parentCss = this.getParentComputedStyle();
        if (parentCss != null) {
            sz = parentCss.getComputedFontSize();
        }
        return sz;
    }

    @Override
    public float computeFloatValue(CSSNumberValue cssValue) {
        float value;
        if (cssValue.getPrimitiveType() == 2) {
            value = cssValue.getFloatValue((short)2);
        } else {
            switch (cssValue.getPrimitiveType()) {
                case 3: {
                    value = (float)this.getComputedFontSize() * cssValue.getFloatValue((short)9);
                }
                case 4: {
                    value = (float)this.getStyleDatabase().getExSizeInPt(this.getFontFamily(), this.getComputedFontSize()) * cssValue.getFloatValue((short)9);
                }
            }
            value = cssValue.getFloatValue();
        }
        return value;
    }

    @Override
    protected boolean isFontFamilyAvailable(String requestedFamily) {
        if (super.isFontFamilyAvailable(requestedFamily)) {
            return true;
        }
        CSSCanvas canvas = ((CSSDocument)this.getOwnerNode().getOwnerDocument()).getCanvas();
        if (canvas != null) {
            return canvas.isFontFaceName(requestedFamily);
        }
        return false;
    }

    @Override
    public abstract String getOwnerXPath();

    public abstract String getParentXPath();

    @Override
    public abstract CSS2ComputedProperties getParentComputedStyle();

    public abstract String getText();

    @Override
    public abstract ComputedCSSStyle clone();
}

