/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.dom.AbstractCSSStyleSheet;
import info.informatica.doc.style.css.dom.BaseCSSRule;
import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.DOMMediaList;
import java.io.IOException;
import java.net.URL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;

public class DOMCSSImportRule
extends BaseCSSRule
implements CSSImportRule {
    private AbstractCSSStyleSheet loadedSheet = null;
    private String styleSheetURI = null;
    private DOMMediaList mediaList;

    public DOMCSSImportRule(AbstractCSSStyleSheet parentSheet) {
        super(parentSheet, (short)3);
        this.mediaList = DOMMediaList.create();
    }

    DOMCSSImportRule(AbstractCSSStyleSheet parentSheet, DOMMediaList mediaList) {
        super(parentSheet, (short)3);
        this.mediaList = mediaList;
    }

    @Override
    public String getHref() {
        return this.styleSheetURI;
    }

    @Override
    public DOMMediaList getMedia() {
        return this.mediaList;
    }

    @Override
    public AbstractCSSStyleSheet getStyleSheet() {
        return this.loadedSheet;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("@import url(\"").append(this.getStyleSheet().getHref()).append("\")");
        if (this.mediaList.getLength() > 0) {
            sb.append(' ').append(this.mediaList.getMediaText());
        }
        return sb.append(';').toString();
    }

    public boolean loadStyleSheet(String uri, String title, SACMediaList media) throws CSSException, IOException, DOMException {
        URL styleSheetURL = this.getURL(uri);
        this.styleSheetURI = styleSheetURL.toExternalForm();
        this.mediaList.appendSACMediaList(media);
        AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
        if (title == null && parentSS != null) {
            title = parentSS.getTitle();
        }
        BaseCSSStyleSheet css = (BaseCSSStyleSheet)parentSS.getStyleSheetFactory().createRuleStyleSheet(this, title, this.mediaList);
        css.setParentStyleSheet(parentSS);
        boolean result = css.loadStyleSheet(styleSheetURL);
        this.loadedSheet = css;
        return result;
    }

    @Override
    public DOMCSSImportRule clone(AbstractCSSStyleSheet parentSheet, int insertionIndex) {
        DOMCSSImportRule rule = new DOMCSSImportRule(parentSheet, this.getMedia().unmodifiable());
        rule.styleSheetURI = this.getHref();
        rule.loadedSheet = this.getStyleSheet();
        rule.setInsertionIndex(insertionIndex);
        return rule;
    }
}

