/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.CSSElement;
import info.informatica.doc.style.css.CSSNode;
import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.dom.AbstractCSSRule;
import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.dom.DOMCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.DOMMediaList;
import info.informatica.doc.style.css.dom.DOMSelectorMatcher;
import java.util.Iterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DOMCSSStyleSheet
extends BaseCSSStyleSheet
implements Cloneable {
    private CSSNode ownerNode = null;

    public DOMCSSStyleSheet(CSSStyleSheetFactory factory, String title, CSSNode ownerNode, DOMMediaList media, CSSRule ownerRule) {
        super(factory, title, media, ownerRule);
        this.ownerNode = ownerNode;
    }

    @Override
    public CSSNode getOwnerNode() {
        return this.ownerNode;
    }

    @Override
    public String getHref() {
        String href = super.getHref();
        if (href == null) {
            return this.ownerNode.getOwnerDocument().getBaseURL().toExternalForm();
        }
        return href;
    }

    @Override
    public CSSStyleDeclaration getComputedStyle(CSSElement elm, String pseudoElt) {
        DOMCSSStyleDeclaration inline = null;
        String st = elm.getAttribute("style");
        if (st.length() > 0) {
            inline = new DOMCSSStyleDeclaration();
            try {
                inline.setCssText(st);
                inline.setPeerNode(elm);
            }
            catch (DOMException e) {
                this.getErrorHandler().inlineStyleError(e, elm, st);
                inline = null;
            }
        }
        ComputedCSSStyle style = this.computeStyle(new DOMCSSStyleDeclaration(this), new DOMSelectorMatcher(elm), inline, pseudoElt);
        return style;
    }

    public DOMCSSStyleSheet clone() {
        DOMCSSStyleSheet myClone = new DOMCSSStyleSheet(this.getStyleSheetFactory(), this.getTitle(), this.getOwnerNode(), this.getMedia(), this.getOwnerRule());
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.setHref(this.getHref());
        myClone.namespaces = this.namespaces;
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myClone.cssRules.add(((AbstractCSSRule)it.next()).clone(myClone, i++));
        }
        return myClone;
    }
}

