/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.CSSDocument;
import info.informatica.doc.style.css.CSSElement;
import info.informatica.doc.style.css.CSSNode;
import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.DocumentCSSStyleSheet;
import info.informatica.doc.style.css.dom.AbstractCSSRule;
import info.informatica.doc.style.css.dom.BaseDocumentCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.dom.DOMCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.DOMSelectorMatcher;
import java.util.Iterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DOMDocumentCSSStyleSheet
extends BaseDocumentCSSStyleSheet
implements DocumentCSSStyleSheet,
Cloneable {
    private CSSDocument ownerNode = null;

    public DOMDocumentCSSStyleSheet(CSSStyleSheetFactory factory) {
        super(factory, null);
    }

    private DOMDocumentCSSStyleSheet(CSSStyleSheetFactory factory, String medium) {
        super(factory, medium);
    }

    @Override
    public CSSNode getOwnerNode() {
        return this.ownerNode;
    }

    public void setOwnerDocument(CSSDocument ownerNode) {
        this.ownerNode = ownerNode;
    }

    @Override
    public CSSStyleDeclaration getComputedStyle(CSSElement elm, String pseudoElt) {
        DOMCSSStyleDeclaration inline = null;
        String st = elm.getAttribute("style");
        if (st.length() > 0) {
            inline = new DOMCSSStyleDeclaration();
            try {
                inline.setCssText(st);
                inline.setPeerNode(elm);
            }
            catch (DOMException e) {
                this.getErrorHandler().inlineStyleError(e, elm, st);
                inline = null;
            }
        }
        ComputedCSSStyle style = this.computeStyle(new DOMCSSStyleDeclaration(this), new DOMSelectorMatcher(elm), inline, pseudoElt);
        return style;
    }

    @Override
    public DOMDocumentCSSStyleSheet clone() {
        DOMDocumentCSSStyleSheet myClone = new DOMDocumentCSSStyleSheet(this.getStyleSheetFactory(), this.getTargetMedium());
        myClone.setOwnerDocument(this.ownerNode);
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.namespaces = this.namespaces;
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myClone.cssRules.add(((AbstractCSSRule)it.next()).clone(myClone, i++));
        }
        return myClone;
    }

    @Override
    public DOMDocumentCSSStyleSheet clone(String targetMedium) {
        DOMDocumentCSSStyleSheet myClone = new DOMDocumentCSSStyleSheet(this.getStyleSheetFactory(), targetMedium);
        myClone.setOwnerDocument(this.ownerNode);
        this.copyTo(myClone);
        return myClone;
    }
}

