/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.j2d;

import info.informatica.doc.agent.AbstractDeviceFactory;
import info.informatica.doc.agent.CSSCanvas;
import info.informatica.doc.agent.DownloadListener;
import info.informatica.doc.agent.ResourceDownloader;
import info.informatica.doc.agent.Viewport;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.CSSDocument;
import info.informatica.doc.style.css.MediaQueryFactory;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.dom.CSSStyleDeclarationRule;
import info.informatica.doc.style.css.dom.DOMCSSFontFaceRule;
import info.informatica.doc.style.css.j2d.AWTMediaAgent;
import info.informatica.doc.style.css.j2d.CSSComponent;
import info.informatica.doc.style.css.j2d.DefaultAWTMediaAgent;
import info.informatica.doc.style.css.j2d.Java2DRenderer;
import info.informatica.doc.style.css.j2d.Java2DStyleDatabase;
import info.informatica.doc.style.css.property.CSSPropertyValueException;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.w3c.MediaQueryList;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;

public class AWTDeviceFactory
extends AbstractDeviceFactory {
    private AWTMediaAgent awtMediaAgent = new DefaultAWTMediaAgent();
    private Java2DRenderer renderer;

    public AWTDeviceFactory(Java2DRenderer renderer) {
        this.renderer = renderer;
    }

    public static Font createFont(CSS2ComputedProperties styledecl) {
        String fontweight;
        String fontfamily = styledecl.getFontFamily();
        int sz = styledecl.getComputedFontSize();
        String stylename = styledecl.getPropertyValue("font-style");
        int style = 0;
        if (stylename.length() > 0 && (stylename = stylename.toLowerCase()).equals("italic")) {
            style = 2;
        }
        if ((fontweight = styledecl.getFontWeight()) != null && (fontweight = fontweight.toLowerCase()).equals("bold")) {
            style = style != 2 ? 1 : 0;
        }
        HashMap<TextAttribute, Constable> textAttrs = new HashMap<TextAttribute, Constable>();
        String decoration = styledecl.getPropertyValue("text-decoration");
        if (decoration.length() > 0) {
            if ((decoration = decoration.toLowerCase()).equals("underline")) {
                textAttrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            } else if (decoration.equals("line-through")) {
                textAttrs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
        }
        Font font = new Font(fontfamily, style, sz);
        return font.deriveFont(textAttrs);
    }

    public static void configureGraphics(Graphics2D g2, CSSContainerBox box) {
        CSS2ComputedProperties style = box.getComputedStyle();
        try {
            g2.setColor(Java2DStyleDatabase.getAWTColor(style.getCSSColor()));
        }
        catch (CSSPropertyValueException e) {
            ((CSSStyleDeclarationRule)style.getParentRule()).getStyleDeclarationErrorHandler().wrongValue("color", e);
        }
        try {
            g2.setBackground(Java2DStyleDatabase.getAWTColor(box.getComputedStyle().getCSSBackgroundColor()));
        }
        catch (CSSPropertyValueException e) {
            ((CSSStyleDeclarationRule)style.getParentRule()).getStyleDeclarationErrorHandler().wrongValue("color", e);
        }
    }

    @Override
    public CSSCanvas createCanvas(String medium, CSSDocument doc) {
        if ("screen".equals(medium)) {
            return new AWTCanvas(doc);
        }
        return null;
    }

    class AWTCanvas
    implements CSSCanvas {
        private CSSDocument document;
        private Viewport viewport;
        private MediaQueryFactory mqfactory;
        private Map<String, Font> fontfaceNames;

        public AWTCanvas(CSSDocument doc) {
            this.viewport = new CSSComponent(AWTDeviceFactory.this.renderer);
            this.mqfactory = null;
            this.fontfaceNames = new HashMap<String, Font>();
            this.document = doc;
        }

        @Override
        public CSSDocument getDocument() {
            return this.document;
        }

        @Override
        public boolean isFontFaceName(String requestedFamily) {
            return this.fontfaceNames.containsKey(requestedFamily);
        }

        @Override
        public Viewport getViewport() {
            return this.viewport;
        }

        @Override
        public StyleDatabase getStyleDatabase() {
            return AWTDeviceFactory.this.getStyleDatabase("screen");
        }

        AWTMediaAgent getAWTMediaAgent() {
            return AWTDeviceFactory.this.awtMediaAgent;
        }

        @Override
        public MediaQueryList parseMediaQueryList(String mediaQueryString) {
            if (this.mqfactory != null) {
                return this.mqfactory.createMediaQuery(mediaQueryString, this);
            }
            return null;
        }

        public void setMediaQueryFactory(MediaQueryFactory mqf) {
            this.mqfactory = mqf;
        }

        @Override
        public void loadFontFace(DOMCSSFontFaceRule rule) {
            String familyName = rule.getStyle().getPropertyValue("font-family");
            if (familyName == null) {
                rule.getStyleDeclarationErrorHandler().missingRequiredProperty(familyName);
                return;
            }
            if (!this.fontfaceNames.containsKey(familyName)) {
                ResourceDownloader<Font> dlr = this.getAWTMediaAgent().getFontDownloader(rule);
                dlr.addListener(new FontfaceListener(rule));
            }
        }

        class FontfaceListener
        implements DownloadListener<Font> {
            DOMCSSFontFaceRule rule;
            private Font font = null;

            FontfaceListener(DOMCSSFontFaceRule rule) {
                this.rule = rule;
            }

            @Override
            public void doContentDownloaded(Font font) {
                this.font = font;
                AWTCanvas.this.fontfaceNames.put(this.rule.getStyle().getPropertyValue("font-family"), font);
            }

            @Override
            public void doFailedDownload() {
            }

            @Override
            public Font getNativeContent() {
                return this.font;
            }

            @Override
            public CSSDocument getDocument() {
                return AWTCanvas.this.document;
            }
        }
    }
}

