/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.j2d;

import info.informatica.doc.agent.AbstractResourceAgent;
import info.informatica.doc.agent.ResourceDownloader;
import info.informatica.doc.style.css.dom.DOMCSSFontFaceRule;
import info.informatica.doc.style.css.j2d.AWTMediaAgent;
import info.informatica.doc.style.css.j2d.Java2DXHTMLElementReplacer;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAWTMediaAgent
implements AWTMediaAgent {
    private AWTResourceAgent resAgent = new AWTResourceAgent();
    static Logger log = LoggerFactory.getLogger((String)DefaultAWTMediaAgent.class.getName());

    public AWTResourceAgent getImageResourceAgent() {
        return this.resAgent;
    }

    @Override
    public ResourceDownloader<Font> getFontDownloader(DOMCSSFontFaceRule rule) {
        return new AWTFontDownloader(rule);
    }

    class AWTFontDownloader
    extends ResourceDownloader<Font> {
        private DOMCSSFontFaceRule rule;

        public AWTFontDownloader(DOMCSSFontFaceRule rule) {
            super(rule.getSrcURL());
            this.rule = rule;
        }

        public DOMCSSFontFaceRule getFontFaceRule() {
            return this.rule;
        }

        @Override
        protected void readContent(InputStream is) throws IOException {
            try {
                this.nativeContent = Font.createFont(0, is);
            }
            catch (FontFormatException e) {
                this.notifyFailure(e);
            }
        }

        @Override
        protected void notifyFailure(Exception e) {
            super.notifyFailure(e);
            log.error("Failure to download " + this.getURL().toExternalForm(), (Throwable)e);
        }
    }

    class AWTImageDownloader
    extends ResourceDownloader<BufferedImage> {
        public AWTImageDownloader(URL url) {
            super(url);
        }

        @Override
        protected void readContent(InputStream is) throws IOException {
            this.nativeContent = ImageIO.read(is);
        }

        @Override
        protected void notifyFailure(Exception e) {
            super.notifyFailure(e);
            log.error("Failure to download " + this.getURL().toExternalForm(), (Throwable)e);
        }
    }

    class AWTResourceAgent
    extends AbstractResourceAgent<BufferedImage> {
        AWTResourceAgent() {
            this.setElementReplacer("http://www.w3.org/1999/xhtml", new Java2DXHTMLElementReplacer());
        }

        @Override
        public ResourceDownloader<BufferedImage> createDownloader(URL url) {
            return new AWTImageDownloader(url);
        }
    }
}

