/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.property;

import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.property.AbstractCSSPrimitiveValue;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class CSSNumberValue
extends AbstractCSSPrimitiveValue {
    protected float realvalue = 0.0f;
    private String dimensionUnitText = "";
    private boolean asInteger = false;

    CSSNumberValue() {
    }

    protected CSSNumberValue(CSSNumberValue copied) {
        super(copied);
        this.realvalue = copied.realvalue;
        this.asInteger = copied.asInteger;
        this.dimensionUnitText = copied.dimensionUnitText;
    }

    @Override
    public String getCssText() {
        boolean notaNumber;
        boolean bl = notaNumber = this.getPrimitiveType() != 1;
        if (this.realvalue == 0.0f && notaNumber && this.getPrimitiveType() != 2) {
            return "0";
        }
        double rintValue = Math.rint(this.realvalue);
        if (this.asInteger) {
            return Integer.toString((int)rintValue);
        }
        if ((double)this.realvalue == rintValue ? notaNumber : this.getPrimitiveType() == 2) {
            return String.valueOf(Integer.toString((int)rintValue)) + this.dimensionUnitText;
        }
        return String.valueOf(Float.toString(this.realvalue)) + this.dimensionUnitText;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify the whole style declaration.");
        }
        this.setCSSUnitType(unitType);
        this.realvalue = floatValue;
        this.dimensionUnitText = CSSNumberValue.dimensionUnitString(unitType);
        this.asInteger = false;
    }

    public void setIntegerValue(int intValue) {
        this.realvalue = intValue;
        this.setCSSUnitType((short)1);
        this.asInteger = true;
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        if (unitType == this.getPrimitiveType() || unitType == 1) {
            return this.realvalue;
        }
        switch (this.getPrimitiveType()) {
            case 14: {
                if (unitType != 15) break;
                return this.realvalue * 1000.0f;
            }
            case 11: {
                if (unitType == 12) {
                    return (float)Math.toRadians(this.realvalue);
                }
                if (unitType != 13) break;
                return this.realvalue * 1.1111112f;
            }
            case 12: {
                if (unitType == 11) {
                    return (float)Math.toDegrees(this.realvalue);
                }
                if (unitType != 13) break;
                return this.realvalue * 63.661976f;
            }
        }
        StyleDatabase deviceStyleDb = this.getStyleDatabase();
        if (deviceStyleDb == null) {
            throw new DOMException(15, "Cannot transform unit to " + CSSNumberValue.dimensionUnitString(unitType));
        }
        return deviceStyleDb.floatValueConversion(this.realvalue, this.getPrimitiveType(), unitType);
    }

    public float getFloatValue() throws DOMException {
        StyleDatabase deviceStyleDb = this.getStyleDatabase();
        if (deviceStyleDb == null) {
            throw new DOMException(15, "Cannot transform value to natural unit.");
        }
        return deviceStyleDb.floatValueConversion(this.realvalue, this.getPrimitiveType());
    }

    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp) {
        super.setLexicalUnit(lunit, subp);
        this.nextLexicalUnit = lunit.getNextLexicalUnit();
        switch (lunit.getLexicalUnitType()) {
            case 13: {
                this.realvalue = lunit.getIntegerValue();
                this.asInteger = true;
                break;
            }
            default: {
                this.realvalue = lunit.getFloatValue();
                this.asInteger = false;
                this.dimensionUnitText = lunit.getDimensionUnitText();
            }
        }
        this.setSubproperty(subp);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Float.floatToIntBits(this.realvalue);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CSSNumberValue)) {
            return false;
        }
        CSSNumberValue other = (CSSNumberValue)obj;
        return Float.floatToIntBits(this.realvalue) == Float.floatToIntBits(other.realvalue);
    }

    @Override
    public CSSNumberValue clone() {
        return new CSSNumberValue(this);
    }

    static String dimensionUnitString(short unitType) {
        switch (unitType) {
            case 3: {
                return "em";
            }
            case 4: {
                return "ex";
            }
            case 5: {
                return "px";
            }
            case 8: {
                return "in";
            }
            case 6: {
                return "cm";
            }
            case 7: {
                return "mm";
            }
            case 9: {
                return "pt";
            }
            case 10: {
                return "pc";
            }
            case 2: {
                return "%";
            }
            case 11: {
                return "deg";
            }
            case 13: {
                return "grad";
            }
            case 12: {
                return "rad";
            }
            case 14: {
                return "ms";
            }
            case 15: {
                return "s";
            }
            case 16: {
                return "Hz";
            }
            case 17: {
                return "kHz";
            }
        }
        return "";
    }
}

