/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.xml.dtd;

import info.informatica.doc.xml.dtd.DefaultEntityResolver;
import info.informatica.doc.xml.dtd.DocumentTypeDeclaration;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ContentModel {
    private static Map<String, ContentModel> contentModelMap = new HashMap<String, ContentModel>();
    private Set<String> emptyElements;
    static Logger log = LoggerFactory.getLogger((String)ContentModel.class.getName());

    protected ContentModel(DocumentTypeDeclaration dtDecl) throws SAXException, IOException {
        String line;
        DefaultEntityResolver resolver = new DefaultEntityResolver();
        InputSource isrc = resolver.resolveEntity(dtDecl);
        if (isrc == null) {
            throw new NullPointerException("Unable to resolve declaration " + dtDecl.toString());
        }
        BufferedReader re = new BufferedReader(isrc.getCharacterStream());
        HashSet<String> emptySet = new HashSet<String>(60);
        while ((line = re.readLine()) != null) {
            int igt;
            if (line.length() == 0) continue;
            if (line.charAt(0) == ' ') {
                line = line.trim();
            }
            if (line.startsWith("<!-- ")) {
                if (line.contains(" -->")) continue;
                while ((line = re.readLine()) != null && !line.contains(" -->")) {
                }
            }
            if (!line.startsWith("<!ELEMENT ") || (igt = line.indexOf(62, 10)) < 16 || !line.regionMatches(igt - 6, " EMPTY", 0, 6)) continue;
            emptySet.add(line.substring(10, igt - 6).trim());
        }
        this.emptyElements = new HashSet<String>(emptySet.size());
        this.emptyElements.addAll(emptySet);
        emptySet.clear();
    }

    public static synchronized ContentModel getModel(String docTypeDecl) throws SAXException {
        if (!contentModelMap.containsKey(docTypeDecl)) {
            try {
                contentModelMap.put(docTypeDecl, new ContentModel(DocumentTypeDeclaration.parse(docTypeDecl)));
            }
            catch (RuntimeException e) {
                log.error("Unable to get content models for " + docTypeDecl, (Throwable)e);
            }
            catch (IOException e) {
                log.error("Unable to get content models for " + docTypeDecl, (Throwable)e);
            }
        }
        return contentModelMap.get(docTypeDecl);
    }

    public static synchronized ContentModel getXHTML1TransitionalModel() {
        try {
            return ContentModel.getModel("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        }
        catch (SAXException e) {
            throw new IllegalStateException();
        }
    }

    public boolean isEmpty(String name) {
        return this.emptyElements.contains(name);
    }
}

