/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.app;

import java.util.Enumeration;

public final class CommandLine {
    private final String[] cmdline;

    public CommandLine(String[] cmdline) {
        this.cmdline = cmdline;
    }

    public String getParam(String pname) {
        int l = pname.length() + 1;
        int i = 0;
        while (i < this.cmdline.length) {
            if (this.cmdline[i].length() >= l && this.cmdline[i].charAt(0) == '-' && pname.equals(this.cmdline[i].substring(1, l))) {
                if (l == this.cmdline[i].length()) {
                    return "";
                }
                return this.cmdline[i].substring(l);
            }
            ++i;
        }
        return null;
    }

    public String getAssignParam(String pname) {
        int l = pname.length() + 2;
        int i = 0;
        while (i < this.cmdline.length) {
            if (this.cmdline[i].length() + 1 > l && this.cmdline[i].startsWith("--") && pname.equals(this.cmdline[i].substring(2, l)) && this.cmdline[i].charAt(l) == '=') {
                if (++l == this.cmdline[i].length()) {
                    return "";
                }
                return this.cmdline[i].substring(l);
            }
            ++i;
        }
        return null;
    }

    public boolean hasParameter(String pname) {
        int l = pname.length() + 1;
        int i = 0;
        while (i < this.cmdline.length) {
            if (pname.equals(this.cmdline[i].substring(1, l))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getLastArgument() {
        String s = this.cmdline[this.cmdline.length - 1];
        if (s.startsWith("-")) {
            return null;
        }
        return s;
    }

    public String[] getLastArguments() {
        int i = this.cmdline.length - 1;
        while (i >= 0) {
            if (this.cmdline[i].startsWith("-")) break;
            --i;
        }
        if (i < 0) {
            return null;
        }
        String[] sa = new String[this.cmdline.length - ++i];
        int j = 0;
        while (j < sa.length) {
            sa[j] = this.cmdline[i + j];
            ++j;
        }
        return sa;
    }

    public String[] getArguments() {
        return this.cmdline;
    }

    public Enumeration getParameterValues(String pname) {
        return new ParamEnumerator(pname);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.cmdline.length * 10);
        int i = 0;
        while (i < this.cmdline.length) {
            sb.append(this.cmdline[i]).append('\n');
            ++i;
        }
        return sb.toString().replace('\n', ' ');
    }

    private class ParamEnumerator
    implements Enumeration {
        private int enum_i = -1;
        private final String enum_pname;

        ParamEnumerator(String pname) {
            this.enum_pname = pname;
            int l = this.enum_pname.length() + 1;
            this.enum_i = 0;
            while (this.enum_i < CommandLine.this.cmdline.length) {
                if (this.enum_pname.equals(CommandLine.this.cmdline[this.enum_i].substring(1, l))) {
                    return;
                }
                ++this.enum_i;
            }
            this.enum_i = -1;
        }

        public boolean hasMoreElements() {
            return this.enum_i >= 0 && this.enum_pname.equals(CommandLine.this.cmdline[this.enum_i].substring(1, this.enum_pname.length() + 1));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object nextElement() {
            if (this.enum_i < 0) {
                return null;
            }
            String s = CommandLine.this.cmdline[this.enum_i];
            ++this.enum_i;
            int l = this.enum_pname.length() + 1;
            while (this.enum_i < CommandLine.this.cmdline.length) {
                if (CommandLine.this.cmdline[this.enum_i].length() >= l && this.enum_pname.equals(CommandLine.this.cmdline[this.enum_i].substring(1, l))) break;
                ++this.enum_i;
            }
            if (this.enum_i >= CommandLine.this.cmdline.length) {
                this.enum_i = -1;
            }
            if (!this.enum_pname.startsWith("-")) return s.substring(l);
            int j = s.indexOf(61) + 1;
            if (j <= 0) return "";
            return s.substring(j);
        }
    }
}

