/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.awt;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ColorUtil {
    private static ColorUtil me = new ColorUtil();
    private Map<String, Color> colornames = new HashMap<String, Color>(30);

    protected ColorUtil() {
        this.colornames.put("black", Color.black);
        this.colornames.put("blue", Color.blue);
        this.colornames.put("cyan", Color.cyan);
        this.colornames.put("darkgray", Color.darkGray);
        this.colornames.put("dark_gray", Color.darkGray);
        this.colornames.put("gray", Color.gray);
        this.colornames.put("green", Color.green);
        this.colornames.put("lightgray", Color.lightGray);
        this.colornames.put("light_gray", Color.lightGray);
        this.colornames.put("magenta", Color.magenta);
        this.colornames.put("orange", Color.orange);
        this.colornames.put("pink", Color.pink);
        this.colornames.put("red", Color.red);
        this.colornames.put("white", Color.white);
        this.colornames.put("yellow", Color.yellow);
        this.colornames.put("negro", Color.black);
        this.colornames.put("azul", Color.blue);
        this.colornames.put("gris", Color.gray);
        this.colornames.put("verde", Color.green);
        this.colornames.put("naranja", Color.orange);
        this.colornames.put("rosa", Color.pink);
        this.colornames.put("rojo", Color.red);
        this.colornames.put("blanco", Color.white);
        this.colornames.put("amarillo", Color.yellow);
        this.colornames.put("grisclaro", Color.lightGray);
        this.colornames.put("grisoscuro", Color.darkGray);
        this.colornames.put("gris_claro", Color.lightGray);
        this.colornames.put("gris_oscuro", Color.darkGray);
    }

    public static ColorUtil getInstance() {
        return me;
    }

    public Color parseColor(String name) {
        Color c = this.parseColorName(name);
        if (c == null) {
            c = this.parseRGB(name);
        }
        return c;
    }

    public Color parseColorName(String name) {
        if (name == null) {
            return null;
        }
        name = name.toLowerCase();
        return this.colornames.get(name);
    }

    public Color parseRGB(String rgb) {
        if (rgb == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(rgb, ",-");
        int[] rgbvec = new int[3];
        int i = 0;
        while (st.hasMoreTokens()) {
            try {
                rgbvec[i] = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse color: " + rgb);
            }
            ++i;
        }
        if (i < 3) {
            throw new IllegalArgumentException("Unable to parse color: " + rgb);
        }
        return new Color(rgbvec[0], rgbvec[1], rgbvec[2]);
    }
}

